/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.LockoutPolicy;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.LockoutPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockoutPolicyServiceImpl
extends AdminServiceBase
implements LockoutPolicyService {
    private static final Log _logger = LogFactory.getLog(LockoutPolicyServiceImpl.class);

    public LockoutPolicyServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public LockoutPolicy getLockoutPolicy() throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getLockoutPolicyService().getLockoutPolicy();
        }
        catch (Exception exception) {
            _logger.error((Object)"LockoutPolicyServiceImpl.getLockoutPolicy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void updateLockoutPolicy(LockoutPolicy lockoutPolicy) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getLockoutPolicyService().updateLockoutPolicy(lockoutPolicy);
        }
        catch (Exception exception) {
            _logger.error((Object)"LockoutPolicyServiceImpl.updateLockoutPolicy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }
}

