/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.GroupDetails;
import com.vmware.vim.binding.sso.admin.PersonDetails;
import com.vmware.vim.binding.sso.admin.PersonUser;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.PrincipalManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.ApplicationUser;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrincipalManagementServiceImpl
extends AdminServiceBase
implements PrincipalManagementService {
    private static final Log _logger = LogFactory.getLog(PrincipalManagementServiceImpl.class);
    private static final int USER_COUNT_LIMIT = 200;
    private String _systemDomainName;

    public PrincipalManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    public PrincipalManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, Boolean bl, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, bl, backendExceptionTransformer);
    }

    public PrincipalManagementServiceImpl(SsoAdminService ssoAdminService) {
        super(ssoAdminService);
    }

    private synchronized String getSystemDomainName() throws SsoServiceException {
        if (StringUtil.isNullOrEmpty((String)this._systemDomainName)) {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this._systemDomainName = this.getAdminService(httpSession).getIdentitySourceManagementService().getSystemDomainName();
        }
        return this._systemDomainName;
    }

    @Override
    public void addToGroup(PrincipalId[] principalIdArray, PrincipalId[] principalIdArray2, String string) throws Exception {
        boolean[] blArray = new boolean[]{};
        boolean[] blArray2 = new boolean[]{};
        boolean bl = false;
        try {
            HttpSession object = SessionUtil.getHttpSession();
            if (!ArrayUtil.isNullOrEmpty((Object[])principalIdArray)) {
                blArray2 = this.getAdminService(object).getPrincipalManagementService().addUsersToLocalGroup(principalIdArray, string);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])principalIdArray2)) {
                blArray = this.getAdminService(object).getPrincipalManagementService().addGroupsToLocalGroup(principalIdArray2, string);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.addToGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
        for (boolean bl2 : blArray) {
            bl |= !bl2;
        }
        for (boolean bl2 : blArray2) {
            bl |= !bl2;
        }
        if (bl) {
            throw new InvalidArgument();
        }
    }

    @Override
    public void createGroup(String string, GroupDetails groupDetails) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().createLocalGroup(string, groupDetails);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.createGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void updateGroup(String string, GroupDetails groupDetails) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().updateLocalGroupDetails(string, groupDetails);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.updateGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public PersonUser findUserAccount(String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchResult searchResult = this.getAdminService(httpSession).getPrincipalDiscoveryService().findUserAccount(string);
            if (searchResult.personUsers != null && searchResult.personUsers.length > 0) {
                return searchResult.personUsers[0];
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUserAccount", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
        return null;
    }

    @Override
    public void createUser(String string, PersonDetails personDetails, String string2) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().createLocalPersonUser(string, personDetails, string2);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.createUser", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void deletePrincipal(PrincipalId principalId) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().deleteLocalPrincipal(principalId.name);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.deletePrincipal", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void editUser(String string, String string2, PersonDetails personDetails, String string3) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            if (personDetails != null) {
                this.getAdminService(httpSession).getPrincipalManagementService().updateLocalPersonUserDetails(string2, personDetails);
            }
            if (!StringUtil.isNullOrEmpty((String)string3)) {
                this.getAdminService(httpSession).getPrincipalManagementService().resetLocalPersonUserPassword(string2, string3);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.editUser", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void editUserOwnDetails(PersonDetails personDetails, String string, String string2, String string3) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().updateSelfLocalPersonUserDetails(personDetails);
            if (!StringUtil.isNullOrEmpty((String)string) && !StringUtil.isNullOrEmpty((String)string3)) {
                this.getAdminService(httpSession).getPrincipalManagementService().resetLocalUserPassword(string2, string3, string);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.editSelfUser", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public Group[] findGroups(String string, String string2) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchCriteria searchCriteria = new PrincipalDiscoveryService.SearchCriteria();
            searchCriteria.domain = StringUtil.isNullOrEmpty((String)string) ? this.getSystemDomainName() : string;
            searchCriteria.searchString = string2;
            return this.getAdminService(httpSession).getPrincipalDiscoveryService().findGroups(searchCriteria, 200);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroups", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public Group findGroupAccount(String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getPrincipalDiscoveryService().findGroupAccount(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroupAccount", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public Group[] findGroupsInGroup(PrincipalId principalId, String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getPrincipalDiscoveryService().findGroupsInGroup(principalId, string, 200);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findGroupsInGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public ApplicationUser[] findSolutionUsers(String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            Object[] objectArray = this.getAdminService(httpSession).getPrincipalDiscoveryService().findSolutionUsers(string, 200);
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                return new ApplicationUser[0];
            }
            ArrayList<ApplicationUser> arrayList = new ArrayList<ApplicationUser>(objectArray.length);
            for (Object object : objectArray) {
                arrayList.add(SsoAdminUtil.toApplicationUser((SolutionUser)object));
            }
            return (ApplicationUser[])ArrayUtil.toArray(arrayList, ApplicationUser.class);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findSolutionUsers", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    public PrincipalDiscoveryService.SearchResult find(String string, String string2) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PrincipalDiscoveryService.SearchCriteria searchCriteria = new PrincipalDiscoveryService.SearchCriteria();
            searchCriteria.domain = StringUtil.isNullOrEmpty((String)string) ? this.getSystemDomainName() : string;
            searchCriteria.searchString = string2;
            return this.getAdminService(httpSession).getPrincipalDiscoveryService().findByName(searchCriteria, 200);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.find", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public PersonUser[] findUsers(String string, String string2) throws Exception {
        try {
            PrincipalDiscoveryService.SearchCriteria searchCriteria = new PrincipalDiscoveryService.SearchCriteria();
            searchCriteria.domain = string;
            searchCriteria.searchString = string2;
            PersonUser[] personUserArray = this.findPersonUsersInternal(searchCriteria);
            return personUserArray;
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUsers", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    private PersonUser[] findPersonUsersInternal(PrincipalDiscoveryService.SearchCriteria searchCriteria) throws NotAuthenticated, InvalidCredentials, SsoServiceException, InvalidPrincipalFault {
        PersonUser[] personUserArray;
        block4: {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PrincipalDiscoveryService principalDiscoveryService = this.getAdminService(httpSession).getPrincipalDiscoveryService();
            personUserArray = new PersonUser[]{};
            if (StringUtil.isNullOrEmpty((String)searchCriteria.domain)) {
                PersonUser personUser = principalDiscoveryService.findSelfPersonUser();
                if (this.isMatching(personUser, searchCriteria)) {
                    personUserArray = new PersonUser[]{personUser};
                }
                return personUserArray;
            }
            try {
                personUserArray = this.getAdminService(httpSession).getPrincipalDiscoveryService().findPersonUsers(searchCriteria, 200);
            }
            catch (NoPermission noPermission) {
                PersonUser personUser = principalDiscoveryService.findSelfPersonUser();
                if (!this.isMatching(personUser, searchCriteria)) break block4;
                personUserArray = new PersonUser[]{personUser};
            }
        }
        return personUserArray;
    }

    private boolean isMatching(PersonUser personUser, PrincipalDiscoveryService.SearchCriteria searchCriteria) {
        String string;
        if (!StringUtil.isNullOrEmpty((String)searchCriteria.domain) && !searchCriteria.domain.equalsIgnoreCase(personUser.id.domain)) {
            return false;
        }
        if (StringUtil.isNullOrEmpty((String)searchCriteria.searchString)) {
            return true;
        }
        String string2 = searchCriteria.searchString.toLowerCase();
        if (!StringUtil.isNullOrEmpty((String)personUser.id.name) && (string = personUser.id.name.toLowerCase()).indexOf(string2) > -1) {
            return true;
        }
        if (!StringUtil.isNullOrEmpty((String)personUser.details.firstName) && (string = personUser.details.firstName.toLowerCase()).indexOf(string2) > -1) {
            return true;
        }
        if (!StringUtil.isNullOrEmpty((String)personUser.details.lastName) && (string = personUser.details.lastName.toLowerCase()).indexOf(string2) > -1) {
            return true;
        }
        return personUser.alias != null && !StringUtil.isNullOrEmpty((String)personUser.alias.name) && (string = personUser.alias.name.toLowerCase()).indexOf(string2) > -1;
    }

    @Override
    public PersonUser[] findDisabledUsers(String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PersonUser[] personUserArray = this.getAdminService(httpSession).getPrincipalDiscoveryService().findDisabledPersonUsers(string, 200);
            return personUserArray;
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findDisabledUsers", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public PersonUser[] findLockedUsers(String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            PersonUser[] personUserArray = this.getAdminService(httpSession).getPrincipalDiscoveryService().findLockedUsers(string, 200);
            return personUserArray;
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findLockedUsers", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public PersonUser[] findUsersInGroup(PrincipalId principalId, String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getPrincipalDiscoveryService().findPersonUsersInGroup(principalId, string, 200);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.findUsersInGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void removeFromGroup(PrincipalId[] principalIdArray, String string) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().removePrincipalsFromLocalGroup(principalIdArray, string);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.removeFromGroup", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void setUserPassword(String string, String string2) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getPrincipalManagementService().resetLocalPersonUserPassword(string, string2);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.setUserPassword", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public boolean enableUser(PrincipalId principalId, boolean bl) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            boolean bl2 = bl ? this.getAdminService(httpSession).getPrincipalManagementService().enableUserAccount(principalId) : this.getAdminService(httpSession).getPrincipalManagementService().disableUserAccount(principalId);
            return bl2;
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.enableUser", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public boolean unlockUser(PrincipalId principalId) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getPrincipalManagementService().unlockUserAccount(principalId);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.unlockUser", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public boolean changePasswordAllowed() throws Exception {
        HttpSession httpSession = SessionUtil.getHttpSession();
        SamlToken samlToken = AuthSessionUtil.getSsoToken((HttpSession)httpSession);
        String string = samlToken.getSubject().getDomain();
        String string2 = this.getSystemDomainName();
        return string.equalsIgnoreCase(string2);
    }

    @Override
    public void changePassword(String string, String string2) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            SamlToken samlToken = AuthSessionUtil.getSsoToken((HttpSession)httpSession);
            String string3 = samlToken.getSubject().getName();
            this.getAdminService(httpSession).getPrincipalManagementService().resetLocalUserPassword(string3, string, string2);
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.changePassword", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public int getSelfPasswordExpiration() throws Exception {
        int n = -1;
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            n = this.getAdminService(httpSession).getPrincipalManagementService().getDaysRemainingUntilSelfPasswordExpiration();
        }
        catch (Exception exception) {
            _logger.error((Object)"PrincipalManagementServiceImpl.getSelfPasswordExpiration", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
        return n;
    }
}

