/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.SystemManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemManagementServiceImpl
extends AdminServiceBase
implements SystemManagementService {
    private static final Log _logger = LogFactory.getLog(SystemManagementServiceImpl.class);

    public SystemManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public String getDomainName() throws SsoServiceException {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            SsoAdminService ssoAdminService = this.getAdminService(httpSession);
            ActiveDirectoryJoinInfo activeDirectoryJoinInfo = ssoAdminService.getSystemManagementService().getActiveDirectoryJoinStatus();
            if (!activeDirectoryJoinInfo.getJoinStatus().equals(ActiveDirectoryJoinInfo.JoinStatus.ACTIVE_DIRECTORY_JOIN_STATUS_DOMAIN.toString())) {
                return "";
            }
            return activeDirectoryJoinInfo.getName();
        }
        catch (SsoServiceException ssoServiceException) {
            _logger.warn((Object)("Error while extracting domain name information : " + ssoServiceException.getMessage()), (Throwable)ssoServiceException);
            throw ssoServiceException;
        }
    }
}

