/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.TokenPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.model.TokenPolicySpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TokenPolicyServiceImpl
extends AdminServiceBase
implements TokenPolicyService {
    private static final Log _logger = LogFactory.getLog(TokenPolicyServiceImpl.class);

    public TokenPolicyServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public TokenPolicySpec getTokenPolicy() throws Exception {
        ConfigurationManagementService configurationManagementService = this.getConfigService();
        TokenPolicySpec tokenPolicySpec = new TokenPolicySpec();
        try {
            tokenPolicySpec.clockTolerance = configurationManagementService.getClockTolerance();
            tokenPolicySpec.maxTokenRenewalCount = configurationManagementService.getRenewCount();
            tokenPolicySpec.maxTokenDelegationCount = configurationManagementService.getDelegationCount();
            tokenPolicySpec.maxBearerTokenLifetime = configurationManagementService.getMaximumBearerTokenLifetime();
            tokenPolicySpec.maxHoKTokenLifetime = configurationManagementService.getMaximumHoKTokenLifetime();
        }
        catch (Exception exception) {
            _logger.error((Object)"Unable to get token policy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
        return tokenPolicySpec;
    }

    @Override
    public void updateTokenPolicy(TokenPolicySpec tokenPolicySpec) throws IllegalArgumentException, Exception {
        ConfigurationManagementService configurationManagementService = this.getConfigService();
        try {
            this.validateTokenPolicy(tokenPolicySpec);
            configurationManagementService.setClockTolerance(tokenPolicySpec.clockTolerance);
            configurationManagementService.setRenewCount(tokenPolicySpec.maxTokenRenewalCount);
            configurationManagementService.setDelegationCount(tokenPolicySpec.maxTokenDelegationCount);
            configurationManagementService.setMaximumBearerTokenLifetime(tokenPolicySpec.maxBearerTokenLifetime);
            configurationManagementService.setMaximumHoKTokenLifetime(tokenPolicySpec.maxHoKTokenLifetime);
        }
        catch (Exception exception) {
            _logger.error((Object)"Unable to get token policy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    private final void validateTokenPolicy(TokenPolicySpec tokenPolicySpec) throws IllegalArgumentException {
        String string = null;
        if (tokenPolicySpec.maxTokenRenewalCount <= 0) {
            string = Integer.toString(tokenPolicySpec.maxTokenRenewalCount);
        } else if (tokenPolicySpec.maxTokenDelegationCount <= 0) {
            string = Integer.toString(tokenPolicySpec.maxTokenDelegationCount);
        } else if (tokenPolicySpec.maxBearerTokenLifetime <= 0L) {
            string = Long.toString(tokenPolicySpec.maxBearerTokenLifetime);
        } else if (tokenPolicySpec.maxHoKTokenLifetime <= 0L) {
            string = Long.toString(tokenPolicySpec.maxHoKTokenLifetime);
        }
        if (string != null) {
            throw new IllegalArgumentException("Illegal non-positive value: " + string);
        }
    }

    private final ConfigurationManagementService getConfigService() throws SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        ConfigurationManagementService configurationManagementService = this.getAdminService(httpSession).getConfigurationManagementService();
        return configurationManagementService;
    }
}

