/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.client;

import com.vmware.cis.cm.client.CisEndPointType;
import com.vmware.cis.cm.client.CisServiceType;
import com.vmware.cis.cm.common.CommonEndPointDataKey;
import com.vmware.cis.cm.common.CommonEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceAttribute;
import com.vmware.vim.binding.cis.cm.ServiceEndPoint;
import com.vmware.vim.binding.cis.cm.ServiceEndPointData;
import com.vmware.vim.binding.cis.cm.ServiceEndPointType;
import com.vmware.vim.binding.cis.cm.ServiceSpec;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.impl.cis.cm.ServiceAttributeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointDataImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceEndPointTypeImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceSpecImpl;
import com.vmware.vim.binding.impl.cis.cm.ServiceTypeImpl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceSpecFactory {
    private static Log _logger = LogFactory.getLog(ServiceSpecFactory.class);

    public static ServiceSpec createServiceSpec() throws Exception {
        ServiceSpecImpl def;
        try {
            ServiceEndPointImpl endpoint1 = new ServiceEndPointImpl(new String[]{"(String)sslTrust"}, new URI("http://java.sun.com/j2se/1.3/sampleUrl1"), (ServiceEndPointType)new ServiceEndPointTypeImpl("(String)protocol1", "(String)typeId1"), new ServiceEndPointData[]{new ServiceEndPointDataImpl("(String)key1", "(String)value1"), new ServiceEndPointDataImpl("(String)key2", "(String)value2")});
            ServiceEndPointImpl endpoint2 = new ServiceEndPointImpl(new String[]{"(String)sslTrust2"}, new URI("http://java.sun.com/j2se/1.3/sampleUrl2"), (ServiceEndPointType)new ServiceEndPointTypeImpl("(String)protocol2", "(String)typeId2"), new ServiceEndPointData[]{new ServiceEndPointDataImpl("(String)key1", "(String)value1"), new ServiceEndPointDataImpl("(String)key2", "(String)value2")});
            def = new ServiceSpecImpl();
            def.setServiceEndPoints(new ServiceEndPoint[]{endpoint1, endpoint2});
            def.setServiceAttributes(new ServiceAttribute[]{new ServiceAttributeImpl("(String)key1", "(String)value1"), new ServiceAttributeImpl("(String)key2", "(String)value2")});
            def.setServiceNameResourceKey("(String)serviceNameResourceKey");
            def.setServiceDescriptionResourceKey("(String)serviceDescriptionResourceKey");
            def.setHostId("(String)hostId");
            def.setServiceGroupResourceKey("(String)serviceGroupResourceKey");
            def.setServiceGroupInternalId("(String)serviceGroupInternalId");
            def.setControlScriptPath("ctlScriptPath");
            def.setOwnerId("(String)ownerId");
            def.setServiceVersion("(String)serviceVersion");
            def.setServiceType((ServiceType)new ServiceTypeImpl("(String)productId", "(String)typeId"));
        }
        catch (URISyntaxException e) {
            _logger.error((Object)e);
            throw new Exception("Creating Service Spec failed", e);
        }
        return def;
    }

    public static ServiceSpec createServiceSpec(String file) throws IOException, Exception {
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(file);
            ServiceSpec serviceSpec = ServiceSpecFactory.createServiceSpec(fileStream);
            return serviceSpec;
        }
        finally {
            if (null != fileStream) {
                IOUtils.closeQuietly((InputStream)fileStream);
            }
        }
    }

    public static ServiceSpec createServiceSpec(InputStream stream) throws IOException, Exception {
        Properties props = new Properties();
        props.load(stream);
        return ServiceSpecFactory.createServiceSpec(props);
    }

    public static ServiceSpec createServiceSpec(Properties props) throws Exception {
        try {
            String name;
            ServiceAttribute attr;
            String name2;
            ServiceEndPoint endpoint;
            ArrayList<ServiceEndPoint> endpoints = new ArrayList<ServiceEndPoint>();
            int i = 0;
            while ((endpoint = ServiceSpecFactory.getEndpoint(name2 = "endpoint" + i + ".", props)) != null) {
                endpoints.add(endpoint);
                ++i;
            }
            ServiceSpecFactory.parseCommonEndPoint(CommonEndPointType.HEALTH_STATUS, props, endpoints);
            ServiceSpecFactory.parseCommonEndPoint(CommonEndPointType.RESOURCE_BUNDLE, props, endpoints);
            ServiceSpecFactory.parseCommonEndPoint(CommonEndPointType.SERVICE_CONFIG_REQUEST, props, endpoints);
            ServiceEndPoint[] endpointArray = endpoints.toArray(new ServiceEndPoint[endpoints.size()]);
            ArrayList<ServiceAttribute> attributes = new ArrayList<ServiceAttribute>();
            int i2 = 0;
            while ((attr = ServiceSpecFactory.getAttribute(name = "attribute" + i2 + ".", props)) != null) {
                attributes.add(attr);
                ++i2;
            }
            ServiceAttribute[] attributeArray = attributes.toArray(new ServiceAttribute[attributes.size()]);
            ServiceSpecImpl spec = new ServiceSpecImpl();
            spec.setServiceEndPoints(endpointArray);
            spec.setServiceAttributes(attributeArray);
            spec.setServiceNameResourceKey(props.getProperty("serviceNameResourceKey"));
            spec.setServiceDescriptionResourceKey(props.getProperty("serviceDescriptionResourceKey"));
            spec.setServiceGroupResourceKey(props.getProperty("serviceGroupResourceKey"));
            spec.setServiceGroupInternalId(props.getProperty("serviceGroupInternalId"));
            spec.setHostId(props.getProperty("hostId"));
            spec.setControlScriptPath(props.getProperty("controlScriptPath"));
            spec.setOwnerId(props.getProperty("ownerId"));
            spec.setServiceVersion(props.getProperty("serviceVersion"));
            spec.setServiceType((ServiceType)new ServiceTypeImpl(props.getProperty("serviceType.product"), props.getProperty("serviceType.type")));
            return spec;
        }
        catch (Exception e) {
            throw new Exception("Could not create ServiceSpec from properties", e);
        }
    }

    private static ServiceEndPoint parseCommonEndPoint(CommonEndPointType type, Properties props, List<ServiceEndPoint> endPoints) throws Exception {
        ServiceEndPoint endpoint = null;
        if (type.equals((Object)CommonEndPointType.HEALTH_STATUS)) {
            endpoint = ServiceSpecFactory.getEndpoint("health.", props);
        } else if (type.equals((Object)CommonEndPointType.RESOURCE_BUNDLE)) {
            endpoint = ServiceSpecFactory.getEndpoint("resourcebundle.", props);
        } else if (type.equals((Object)CommonEndPointType.SERVICE_CONFIG_REQUEST)) {
            endpoint = ServiceSpecFactory.getEndpoint("serviceconfig.", props);
        }
        if (endpoint != null) {
            endpoint.setEndPointType(type.endPointType());
            endPoints.add(endpoint);
        }
        return endpoint;
    }

    private static ServiceEndPoint getEndpoint(String name, Properties props) throws Exception {
        String string;
        String val;
        String url = props.getProperty(name + "url");
        if (url == null) {
            return null;
        }
        ArrayList<ServiceEndPointDataImpl> endpointData = new ArrayList<ServiceEndPointDataImpl>();
        int d = 0;
        while (true) {
            String data = name + "data" + d + ".";
            String key = props.getProperty(data + "key");
            String string2 = props.getProperty(data + "value");
            if (key == null) break;
            endpointData.add(new ServiceEndPointDataImpl(key, string2));
            ++d;
        }
        String localUrl = props.getProperty(name + "localurl");
        if (localUrl != null) {
            boolean found = false;
            for (ServiceEndPointData serviceEndPointData : endpointData) {
                if (!serviceEndPointData.getKey().equals(CommonEndPointDataKey.LOCAL_URL.endPointDataKey())) continue;
                serviceEndPointData.setValue(localUrl);
                found = true;
                break;
            }
            if (!found) {
                endpointData.add(new ServiceEndPointDataImpl(CommonEndPointDataKey.LOCAL_URL.endPointDataKey(), localUrl));
            }
        }
        ArrayList<String> certificateList = new ArrayList<String>();
        int c = 0;
        while ((val = props.getProperty(string = name + "ssltrust" + c)) != null) {
            ServiceSpecFactory.validateCertificate(val);
            certificateList.add(val);
            ++c;
        }
        String[] certificates = certificateList.toArray(new String[certificateList.size()]);
        ServiceEndPointTypeImpl serviceEndPointTypeImpl = new ServiceEndPointTypeImpl(props.getProperty(name + "type.protocol"), props.getProperty(name + "type.id"));
        ServiceEndPointImpl endpoint = new ServiceEndPointImpl(certificates, ServiceSpecFactory.convertToURIEscapingIllegalChars(url), (ServiceEndPointType)serviceEndPointTypeImpl, endpointData.toArray(new ServiceEndPointData[endpointData.size()]));
        return endpoint;
    }

    private static URI convertToURIEscapingIllegalChars(String string) throws Exception {
        String decodedURL = URLDecoder.decode(string, "UTF-8");
        URL url = new URL(decodedURL);
        return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
    }

    private static void validateCertificate(String val) {
        if (val == null) {
            _logger.warn((Object)"SSL certificate is empty");
        } else {
            boolean hasPadding;
            boolean needsPadding = val.length() % 3 != 0;
            boolean bl = hasPadding = val.charAt(val.length() - 1) == '=';
            if (needsPadding && !hasPadding && _logger.isWarnEnabled()) {
                _logger.warn((Object)("The following SSL certificate may not be properly encoded as a base64 string:\n" + val));
            }
        }
    }

    private static ServiceAttribute getAttribute(String name, Properties props) {
        String key = props.getProperty(name + "key");
        String val = props.getProperty(name + "value");
        ServiceAttributeImpl ret = null;
        if (key != null) {
            ret = new ServiceAttributeImpl(key, val);
        }
        return ret;
    }

    public static ServiceSpec createSsoServiceSpec(String[] sslTrust, String ssoAdminUri, String ssoStsUri) throws Exception {
        ServiceSpecImpl def;
        try {
            ServiceEndPointImpl admin = new ServiceEndPointImpl(sslTrust, new URI(ssoAdminUri), CisEndPointType.SSOADMIN.endPointType(), null);
            ServiceEndPointImpl sts = new ServiceEndPointImpl(sslTrust, new URI(ssoStsUri), CisEndPointType.SSOSTS.endPointType(), null);
            def = new ServiceSpecImpl();
            def.setServiceEndPoints(new ServiceEndPoint[]{admin, sts});
            def.setServiceNameResourceKey("serviceNameResourceKey");
            def.setServiceDescriptionResourceKey("serviceDescriptionResourceKey");
            def.setServiceGroupInternalId("serviceGroupInternalId");
            def.setServiceGroupResourceKey("serviceGroupResourceKey");
            def.setHostId("hostId");
            def.setOwnerId("ownerId");
            def.setServiceVersion("1.0");
            def.setServiceType(CisServiceType.SSO.getServiceType());
        }
        catch (URISyntaxException e) {
            _logger.error((Object)e);
            throw new Exception("Creating Sso Service Spec failed", e);
        }
        return def;
    }
}

