/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.common.impl;

import com.vmware.vim.vmomi.core.impl.SslUtil;
import com.vmware.vim.vmomi.server.common.SslBindingInfo;
import com.vmware.vim.vmomi.server.common.impl.TcpBindingInfoImpl;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class SslBindingInfoImpl
extends TcpBindingInfoImpl
implements SslBindingInfo {
    private X509Certificate[] _certificateChain;
    private String _thumbprint;

    public SslBindingInfoImpl(X509Certificate[] certificateChain) {
        this._certificateChain = certificateChain;
    }

    @Deprecated
    public SslBindingInfoImpl(X509Certificate[] certificateChain, Boolean isTrusted) {
        this(certificateChain);
    }

    @Override
    public X509Certificate[] getClientCertificateChain() {
        return this._certificateChain;
    }

    @Override
    public void setClientCertificate(X509Certificate[] certificateChain) {
        this._certificateChain = certificateChain;
    }

    @Override
    public String getThumbprint() throws CertificateEncodingException, NoSuchAlgorithmException {
        return this.getThumbprint("SHA-1");
    }

    @Override
    public String getThumbprint(String digestAlgorithm) throws CertificateEncodingException, NoSuchAlgorithmException {
        if (null == this._thumbprint && null != this._certificateChain && this._certificateChain.length > 0) {
            this._thumbprint = SslUtil.computeCertificateThumbprint((X509Certificate)this._certificateChain[0], (String)digestAlgorithm);
        }
        return this._thumbprint;
    }
}

