/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.BodyHandler;
import com.vmware.vim.vmomi.server.DeserializedRequest;
import com.vmware.vim.vmomi.server.SoapBinding;
import com.vmware.vim.vmomi.server.common.ChainedProcessingStep;
import com.vmware.vim.vmomi.server.common.Request;
import com.vmware.vim.vmomi.server.common.Response;
import com.vmware.vim.vmomi.server.impl.ActivationImpl;
import com.vmware.vim.vmomi.server.impl.SoapBindingImpl;
import com.vmware.vim.vmomi.server.security.RequestSignatureValidator;
import com.vmware.vim.vmomi.server.session.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BodyHandlerImpl
implements BodyHandler {
    private Log _logger = LogFactory.getLog(this.getClass());
    private VmodlVersion _version;
    private AdapterServer _adapterServer;
    private String _supportedVersionUri;
    private String _supportedNamespace;
    private VmodlContext _vmodlContext;
    private SoapBinding _soapBinding;
    private final RequestSignatureValidator _requestSignatureValidator;

    public BodyHandlerImpl(VmodlVersion version, AdapterServer adapterServer, VmodlContext vmodlContext, RequestSignatureValidator requestSignatureValidator) {
        this._version = version;
        this._adapterServer = adapterServer;
        this._vmodlContext = vmodlContext;
        this._soapBinding = new SoapBindingImpl(this._version, this._vmodlContext);
        this._requestSignatureValidator = requestSignatureValidator;
        String versionId = version.getVersionId();
        String wsdlNamespace = version.getNamespace();
        if (versionId != null && versionId.length() > 0) {
            this._supportedVersionUri = String.format("%1$s%2$s/%3$s", "urn:", wsdlNamespace, versionId);
        }
        if (wsdlNamespace != null && wsdlNamespace.length() > 0) {
            this._supportedNamespace = "urn:" + wsdlNamespace;
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug((Object)String.format("supportedVersionURI: '%1$s', supportedNamespace: '%2$s'", this._supportedVersionUri, this._supportedNamespace));
        }
    }

    public BodyHandlerImpl(VmodlVersion version, AdapterServer adapterServer, VmodlContext vmodlContext) {
        this(version, adapterServer, vmodlContext, null);
    }

    @Override
    public void handleBody(DeserializedRequest deserializedRequest, Request request, Response response, Session session, ChainedProcessingStep<Activation, Activation> nextStep, ChainedProcessingStep<Activation, Activation> completionStep) throws ManagedObjectNotFound {
        String moId = deserializedRequest.getMoId();
        ManagedObject mo = this._adapterServer.lookupManagedObject(moId);
        if (mo == null) {
            ManagedObjectReference moRef = new ManagedObjectReference(deserializedRequest.getMoType(), moId, this._adapterServer.getServerGuid());
            ManagedObjectNotFound monf = new ManagedObjectNotFound();
            monf.setMessage(String.format("Managed object of type '%1$s' with id '%2$s' not found", deserializedRequest.getMoType(), moId));
            monf.setObj(moRef);
            throw monf;
        }
        ActivationImpl activation = new ActivationImpl(this._version, mo, deserializedRequest.getManagedMethod(), deserializedRequest.getArgs(), session, request, response, this._adapterServer.getSTSCertificates(), this._requestSignatureValidator);
        this._adapterServer.invoke(activation, nextStep, completionStep);
    }

    @Override
    public SoapBinding getSoapBinding() {
        return this._soapBinding;
    }

    @Override
    public String getSupportedNamespace() {
        return this._supportedNamespace;
    }

    @Override
    public String getSupportedVersionUri() {
        return this._supportedVersionUri;
    }
}

