/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.common.DiagnosticContextProvider;
import com.vmware.vim.vmomi.server.exception.ExceptionUtil;
import com.vmware.vim.vmomi.server.util.DataObjectLoggerUtil;
import com.vmware.vim.vmomi.server.util.DiagnosticContextUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InvocationTask
implements Runnable,
DiagnosticContextProvider {
    private static final Log _logger = LogFactory.getLog(InvocationTask.class);
    Activation _activation;

    public InvocationTask(Activation activation) {
        this._activation = activation;
    }

    @Override
    public void run() {
        try {
            Method method = this._activation.getMethod().getMethod();
            if (_logger.isTraceEnabled()) {
                StringBuilder buffer = new StringBuilder(String.format("(%3$s) Invoking %1$s.%2$s() [MORef %4$s] with parameters:", method.getDeclaringClass().getName(), method.getName(), this._activation.getRequest().getCorrelator(), this._activation.getTarget()._getRef().getValue()));
                for (int i = 0; i < this._activation.getArgs().length - 1; ++i) {
                    buffer.append('\n');
                    DataObjectLoggerUtil.formatField(buffer, this._activation.getMethod().getParameters()[i], this._activation.getArgs()[i]);
                }
                _logger.trace((Object)buffer.toString());
            } else if (_logger.isDebugEnabled()) {
                String buffer = String.format("Invoking %1$s.%2$s", method.getDeclaringClass().getName(), method.getName());
                _logger.debug((Object)buffer);
            }
            method.invoke((Object)this._activation.getTarget(), this._activation.getArgs());
            if (_logger.isTraceEnabled()) {
                _logger.trace((Object)String.format("(%3$s) Exiting %1$s.%2$s [MORef %4$s]", method.getDeclaringClass().getName(), method.getName(), this._activation.getRequest().getCorrelator(), this._activation.getTarget()._getRef().getValue()));
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                this.handleInternalServerException(e);
            }
            if (cause instanceof RuntimeFault) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Managed method threw RuntimeFault", cause);
                }
                this._activation.getFutureArg().setException((Exception)((RuntimeFault)cause));
            }
            if (cause instanceof Exception) {
                this.handleUnexpectedMethodException((Exception)cause);
            }
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)"Method invocation threw unexpected error!", cause);
            }
            throw (Error)cause;
        }
        catch (Exception ex) {
            this.handleInternalServerException(ex);
        }
    }

    private void handleUnexpectedMethodException(Exception ex) {
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)"Method invocation threw unexpected exception!", (Throwable)ex);
        }
        this._activation.getFutureArg().setException(ex);
    }

    private void handleInternalServerException(Exception ex) {
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)"Internal server error during managed method invocation", (Throwable)ex);
        }
        this._activation.getFutureArg().setException((Exception)ExceptionUtil.buildFaultForInternalException(ex));
    }

    @Override
    public Map<String, Object> getDiagnosticContext() {
        return DiagnosticContextUtils.getDiagnosticContext(this._activation.getRequest().getRequestContext());
    }
}

