/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.impl;

import com.vmware.vim.vmomi.server.Activation;
import com.vmware.vim.vmomi.server.ActivationValidator;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.common.ProcessingStep;
import com.vmware.vim.vmomi.server.common.impl.BaseProcessingStep;
import com.vmware.vim.vmomi.server.common.impl.ResponseImpl;
import com.vmware.vim.vmomi.server.impl.DispatchErrorActivationImpl;
import com.vmware.vim.vmomi.server.impl.ValidationStartTask;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ValidationStartStep
extends BaseProcessingStep<Activation, Activation> {
    private AdapterServer _adapterServer;

    public ValidationStartStep() {
    }

    public ValidationStartStep(ProcessingStep<Activation> nextStep, ExecutorService exe, AdapterServer adapterServer) {
        this.setNextStep(nextStep);
        this.setExecutor(exe);
        this.setAdapterServer(adapterServer);
    }

    public void setAdapterServer(AdapterServer adapterServer) {
        this._adapterServer = adapterServer;
    }

    @Override
    public Runnable buildTask(Activation activation) {
        return new ValidationStartTask(new ValidationInfo(activation, this._adapterServer.getActivationValidators()), this.getNextStep());
    }

    @Override
    public Activation buildErrorActivation(Activation activation, Exception ex) {
        return new DispatchErrorActivationImpl(ex, new ResponseImpl(activation.getRequest().getCorrelator()), activation.getSession());
    }

    public static class ValidationInfo {
        private Activation _activation;
        private List<ActivationValidator> _activationValidators;

        public ValidationInfo(Activation activation, List<ActivationValidator> validators) {
            this._activation = activation;
            this._activationValidators = validators;
        }

        public Activation getActivation() {
            return this._activation;
        }

        public List<ActivationValidator> getActivationValidators() {
            return this._activationValidators;
        }
    }
}

