/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.security.impl;

import com.vmware.vim.vmomi.core.soap.Constants;
import com.vmware.vim.vmomi.server.security.impl.QNameUtil;
import com.vmware.vim.vmomi.server.security.impl.WssElementResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public final class WssElementResolverImpl
implements WssElementResolver {
    private final Document _document;
    private final Map<String, Element> _foundElementCache;

    public WssElementResolverImpl(Document document) {
        if (document == null) {
            throw new IllegalArgumentException("document must not be null");
        }
        if (!(document instanceof DocumentTraversal)) {
            throw new IllegalArgumentException("Incompatible DOM implementation (must support DocumentTraversal)");
        }
        this._document = document;
        this._foundElementCache = new HashMap<String, Element>();
    }

    @Override
    public Element findElementById(String id) throws URIReferenceException {
        if (!this._foundElementCache.containsKey(id)) {
            this._foundElementCache.put(id, this.findByIdImpl(id));
        }
        return this._foundElementCache.get(id);
    }

    @Override
    public Element findElementByReference(URIReference uriReference) throws URIReferenceException {
        String referencedElementId = WssElementResolverImpl.getReferencedElementId(uriReference);
        if (referencedElementId.isEmpty()) {
            return this._document.getDocumentElement();
        }
        return this.findElementById(referencedElementId);
    }

    private Element findByIdImpl(String id) throws URIReferenceException {
        DocumentTraversal traversal = (DocumentTraversal)((Object)this._document);
        ByIdFilter filter = new ByIdFilter(id);
        NodeIterator iterator = traversal.createNodeIterator(this._document.getDocumentElement(), 1, filter, false);
        Node foundNode = iterator.nextNode();
        if (iterator.nextNode() != null) {
            throw new URIReferenceException(String.format("Duplicate referent: more than one element with id `%s' found", id));
        }
        return (Element)foundNode;
    }

    private static String getReferencedElementId(URIReference uriReference) throws URIReferenceException {
        URI refUri;
        if (uriReference.getType() != null) {
            throw new URIReferenceException("Typed references are not supported");
        }
        try {
            refUri = new URI(uriReference.getURI());
        }
        catch (URISyntaxException e) {
            throw new URIReferenceException("URIReference does not contain valid URI", e);
        }
        if (refUri.isAbsolute() || !refUri.getSchemeSpecificPart().isEmpty()) {
            throw new URIReferenceException("WsSecurityUriDereferncer only allows for dereferencing same-document fragments");
        }
        return refUri.getFragment() == null ? "" : refUri.getFragment();
    }

    private static class ByIdFilter
    implements NodeFilter {
        private static final Set<QName> ID_ATTRIBUTES = new HashSet<QName>();
        private final String _elementId;

        public ByIdFilter(String elementId) {
            this._elementId = elementId;
        }

        @Override
        public short acceptNode(Node node) {
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    if (!ID_ATTRIBUTES.contains(QNameUtil.getQName(attr)) || !this._elementId.equals(attr.getNodeValue())) continue;
                    return 1;
                }
            }
            return 3;
        }

        static {
            ID_ATTRIBUTES.add(new QName("id"));
            ID_ATTRIBUTES.add(new QName("Id"));
            ID_ATTRIBUTES.add(new QName("ID"));
            ID_ATTRIBUTES.add(Constants.WSU_ID_QNAME);
        }
    }
}

