/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.server.util;

import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.server.ServerFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DiagnosticContextUtils {
    public static Map<String, Object> getDiagnosticContext(RequestContext context) {
        String opId = DiagnosticContextUtils.getOperationId(context);
        if (opId == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("operationID", opId);
        return result;
    }

    public static String getOperationId(ServerFuture future) {
        return DiagnosticContextUtils.getOperationId(future.getActivation().getRequest().getRequestContext());
    }

    public static String getOperationId(RequestContext context) {
        if (context == null) {
            return null;
        }
        Object result = context.get((Object)"operationID");
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public static void generateDiagnosticContext(RequestContext context) {
        context.put((Object)"operationID", (Object)DiagnosticContextUtils.generateOpId());
    }

    public static String generateOpId() {
        return UUID.randomUUID().toString();
    }
}

