/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.perfmon;

import com.google.common.base.Function;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.vmware.vim.binding.cis.common.perfmon.CounterInfo;
import com.vmware.vim.binding.cis.common.perfmon.PerfmonManager;
import com.vmware.vim.binding.impl.cis.common.perfmon.CounterInfoImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.server.AdapterServer;
import com.vmware.vim.vmomi.server.ManagedObjectBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerfmonManagerImpl
extends ManagedObjectBase
implements PerfmonManager {
    private static final String MOID = "PerfmonManager";
    private static final Log _log = LogFactory.getLog(PerfmonManagerImpl.class);

    public PerfmonManagerImpl(AdapterServer as) {
        super(MOID, as);
    }

    public PerfmonManagerImpl(String serverGuid) {
        super(MOID, serverGuid);
    }

    public void enumerateNames(String regex, boolean ignoreCase, Future<String[]> res) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("enumerateNames: Entering (regex:%s, ignoreCase:%b)", regex, ignoreCase));
        }
        Pattern p = Pattern.compile(regex, ignoreCase ? 2 : 0);
        ArrayList<String> names = new ArrayList<String>();
        Monitor[] mons = MonitorFactory.getRootMonitor().getMonitors();
        for (Monitor mon : PerfmonManagerImpl.firstNonNull(mons, new Monitor[0])) {
            String name = mon.getLabel();
            if (!p.matcher(name).matches()) continue;
            names.add(name);
        }
        res.set((Object)names.toArray(new String[names.size()]));
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("enumerateNames: Leaving (names:%d)", names.size()));
        }
    }

    public void executeNameQuery(String[] names, Future<CounterInfo[]> res) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("executeNameQuery: Entering (names:%d)", names != null ? names.length : 0));
        }
        if (names == null) {
            names = new String[]{};
        }
        CounterInfo[] ctrs = this.executeQueryImpl(PerfmonManagerImpl.createNameListMatcher(names));
        res.set((Object)ctrs);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("executeNameQuery: Leaving (ctrs:%d)", ctrs.length));
        }
    }

    private static Function<String, Boolean> createNameListMatcher(String[] names) {
        final List<String> namesList = Arrays.asList(names);
        return new Function<String, Boolean>(){

            public Boolean apply(String name) {
                return namesList.contains(name);
            }
        };
    }

    public void executeRegexQuery(String regex, boolean ignoreCase, Future<CounterInfo[]> res) {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("executeRegexQuery: Entering (regex:%s, ignoreCase:%b)", regex, ignoreCase));
        }
        CounterInfo[] ctrs = this.executeQueryImpl(PerfmonManagerImpl.createRegexMatcher(regex, ignoreCase));
        res.set((Object)ctrs);
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("executeNameQuery: Leaving (ctrs:%d)", ctrs.length));
        }
    }

    private static Function<String, Boolean> createRegexMatcher(String regex, boolean ignoreCase) {
        final Pattern p = Pattern.compile(regex, ignoreCase ? 2 : 0);
        return new Function<String, Boolean>(){

            public Boolean apply(String name) {
                return p.matcher(name).matches();
            }
        };
    }

    public void clearAll(Future<Void> f) {
        MonitorFactory.reset();
        f.set();
    }

    private CounterInfo[] executeQueryImpl(Function<String, Boolean> nameMatcher) {
        ArrayList<CounterInfoImpl> results = new ArrayList<CounterInfoImpl>();
        Monitor[] mons = MonitorFactory.getRootMonitor().getMonitors();
        for (Monitor mon : PerfmonManagerImpl.firstNonNull(mons, new Monitor[0])) {
            String name = mon.getLabel();
            if (!((Boolean)nameMatcher.apply((Object)name)).booleanValue()) continue;
            CounterInfoImpl cr = new CounterInfoImpl();
            cr.setName(name);
            cr.setUnits(mon.getUnits());
            cr.setMin((long)mon.getMin());
            cr.setMax((long)mon.getMax());
            cr.setAverage((long)mon.getAvg());
            cr.setTotal((long)mon.getTotal());
            cr.setSamples((int)mon.getHits());
            results.add(cr);
        }
        return results.toArray(new CounterInfo[results.size()]);
    }

    private static <T> T firstNonNull(T first, T second) {
        if (first != null) {
            return first;
        }
        if (second != null) {
            return second;
        }
        throw new NullPointerException();
    }
}

