/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.perfmon;

import com.vmware.cis.services.common.perfmon.PerfmonAggregator;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PerfmonReportServlet
extends HttpServlet {
    public static final String PROP_ENABLED = "cis.perfmon.reportServletEnabled";
    private final Callable<Properties> _configAccessor;

    public PerfmonReportServlet(Callable<Properties> configAccessor) {
        this._configAccessor = configAccessor;
    }

    public PerfmonReportServlet(final boolean enabled) {
        this._configAccessor = new Callable<Properties>(){

            @Override
            public Properties call() throws Exception {
                Properties p = new Properties();
                p.setProperty(PerfmonReportServlet.PROP_ENABLED, Boolean.toString(enabled));
                return p;
            }
        };
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        try {
            this.checkServletEnabled();
            resp.setHeader("Content-Type", "text/html; charset=utf-8");
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), Charset.forName("utf-8")));
            w.write(PerfmonAggregator.getHtmlReport());
            ((Writer)w).flush();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void checkServletEnabled() throws Exception {
        Properties props = this._configAccessor.call();
        if (!Boolean.valueOf(props.getProperty(PROP_ENABLED, "false")).booleanValue()) {
            throw new UnsupportedOperationException("Servlet not enabled");
        }
    }
}

