/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.common.sso.ClientHelper;
import com.vmware.vim.sso.client.SamlToken;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelfRefreshingSamlTokenCache {
    private static final Log _log = LogFactory.getLog(SelfRefreshingSamlTokenCache.class);
    private X509Certificate _cert;
    private PrivateKey _key;
    private ClientHelper _clientHelper;
    private static final int DEFAULT_TOKEN_LIFE_SECS = 3600;
    private static final int DEFAULT_MIN_SECS_TO_LIVE = 300;
    private SamlToken _token = null;
    private int _tokenLifeTimeSecs;

    public SelfRefreshingSamlTokenCache(X509Certificate cert, PrivateKey key, ClientHelper helper) {
        this(cert, key, helper, 3600);
    }

    public SelfRefreshingSamlTokenCache(X509Certificate cert, PrivateKey key, ClientHelper helper, int tokenLifeTimeSecs) {
        if (tokenLifeTimeSecs <= 0) {
            throw new IllegalArgumentException("Token life time (in seconds) must be greater than 0!");
        }
        this._cert = cert;
        this._key = key;
        this._clientHelper = helper;
        this._tokenLifeTimeSecs = tokenLifeTimeSecs;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("SelfRefreshingSamlTokenCache (%x): Token lifetime is %d secs", this.hashCode(), this._tokenLifeTimeSecs));
        }
    }

    public synchronized SamlToken getToken(int minTimeToLiveSecs) throws SelfRefreshingSamlTokenCacheException {
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("getToken (%x, %d): Entering", this.hashCode(), minTimeToLiveSecs));
        }
        try {
            if (this._token == null || this.willExpire(minTimeToLiveSecs)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)String.format("getToken (%x, %d): Acquiring new token", this.hashCode(), minTimeToLiveSecs));
                }
                int newTokenLifeTimeSecs = minTimeToLiveSecs > this._tokenLifeTimeSecs ? minTimeToLiveSecs : this._tokenLifeTimeSecs;
                this._token = this._clientHelper.acquireTokenByCertificate(this._cert, (Key)this._key, (long)newTokenLifeTimeSecs);
            }
            if (_log.isTraceEnabled()) {
                _log.trace((Object)String.format("getToken (%x, %d): Leaving", this.hashCode(), minTimeToLiveSecs));
            }
            return this._token;
        }
        catch (Exception e) {
            throw new SelfRefreshingSamlTokenCacheException(e);
        }
    }

    public synchronized SamlToken getToken() throws SelfRefreshingSamlTokenCacheException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("getToken (%x): Entering", this.hashCode()));
        }
        SamlToken token = this.getToken(300);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)String.format("getToken (%x): Leaving", this.hashCode()));
        }
        return token;
    }

    private boolean willExpire(int minTimeToLiveSecs) {
        return System.currentTimeMillis() + (long)minTimeToLiveSecs * 1000L > this._token.getExpirationTime().getTime();
    }

    public static class SelfRefreshingSamlTokenCacheException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SelfRefreshingSamlTokenCacheException(Throwable cause) {
            super(cause);
        }

        private SelfRefreshingSamlTokenCacheException(String message, Throwable cause) {
            super(message, cause);
        }

        private SelfRefreshingSamlTokenCacheException(String message) {
            super(message);
        }

        private SelfRefreshingSamlTokenCacheException() {
        }
    }
}

