/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.vim.sso.http.Request;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class SsoOverRestHelper
extends com.vmware.cis.common.sso.SsoOverRestHelper {
    static SsoOverRestRequest createSsoOverRestRequest(HttpServletRequest request, byte[] extractedPayload) throws IOException {
        URL requestUrl = new URL(request.getRequestURL().toString());
        String payload = "";
        if (extractedPayload != null && extractedPayload.length > 0) {
            payload = new String(extractedPayload, request.getCharacterEncoding());
        }
        return new SsoOverRestRequest(Request.Method.valueOf((String)request.getMethod()), request.getRequestURI(), requestUrl.getHost(), SsoOverRestHelper.getRequestPort(request, requestUrl), payload);
    }

    private static int getRequestPort(HttpServletRequest request, URL requestUrl) throws IOException {
        int port = requestUrl.getPort();
        if (port != -1) {
            return port;
        }
        int DEFAULT_HTTPS_PORT = 443;
        int DEFAULT_HTTP_PORT = 80;
        String fwdProto = request.getHeader("X-Forwarded-Proto");
        if ("https".equalsIgnoreCase(fwdProto)) {
            return 443;
        }
        return 80;
    }
}

