/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vim.binding.lookup.fault.EntryNotFoundFault;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.sms.version.versions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.HttpConfigurationImpl;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.mks.util.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vmomi.request.DelegatingRequestContextProvider;
import com.vmware.vise.vim.commons.vmomi.request.ManagedObjectContextHandler;
import com.vmware.vise.vim.commons.vmomi.request.OpIdContextHandler;
import com.vmware.vise.vim.commons.vmomi.response.ResultInterceptorImpl;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import com.vmware.vsphere.client.context.VcSessionCookieContextProvider;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.impl.LocationLookupException;
import com.vmware.vsphere.client.sms.impl.SmsServiceImpl;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import com.vmware.vsphere.client.sms.util.SmsServiceLocationLookup;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceFactory {
    private static final Log _logger = LogFactory.getLog(SmsServiceFactory.class);
    private Class<?> _versionClass;
    private String _vmodlPackage;
    private ThreadPoolExecutor _threadPoolExecutor;
    private KeystoreService _keystoreService;
    private LookupService _lookupService;

    public void setVersionClass(Class<?> versionClass) {
        this._versionClass = versionClass;
    }

    public void setVmodlPackage(String vmodlPackage) {
        this._vmodlPackage = vmodlPackage;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this._threadPoolExecutor = executor;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setLookupService(LookupService lookupService) {
        this._lookupService = lookupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        ClassLoader bundleClassLoader = StorageManager.class.getClassLoader();
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            VmodlContext.initContext((String[])new String[]{this._vmodlPackage});
        }
        catch (VmodlAlreadyLoadedException e) {
            _logger.info((Object)"The VmodlContext is already loaded.");
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    public SmsService connectSmsService(VcService vcService) throws LocationLookupException, SmsServiceUnableToConnectException, EntryNotFoundFault {
        HttpConfigurationImpl httpConfiguration = new HttpConfigurationImpl();
        if (this._keystoreService != null && VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) && SmsServiceFactory.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            httpConfiguration.setTrustStore(this._keystoreService.getKeyStore());
        } else {
            SslThumbprintVerifier sslThumbprintVerifier = new SslThumbprintVerifier();
            sslThumbprintVerifier.setThumbprint(vcService.getThumbprint());
            httpConfiguration.setThumbprintVerifier((ThumbprintVerifier)sslThumbprintVerifier);
        }
        HttpClientConfiguration httpClientConfiguration = HttpClientConfiguration.Factory.newInstance();
        httpClientConfiguration.setExecutor((Executor)this._threadPoolExecutor);
        httpClientConfiguration.setHttpConfiguration((HttpConfiguration)httpConfiguration);
        String sessionCookie = vcService.getConnectionInfo().getSessionCookie();
        VcSessionCookieContextProvider cookieProvider = new VcSessionCookieContextProvider(sessionCookie);
        DelegatingRequestContextProvider contextProvider = new DelegatingRequestContextProvider(new ManagedObjectContextHandler[]{cookieProvider, new OpIdContextHandler()});
        httpClientConfiguration.setRequestContextProvider((RequestContextProvider)contextProvider);
        httpClientConfiguration.setResultInterceptor((ResultInterceptor)new ResultInterceptorImpl());
        Client client = VcServiceUtil.is65VcOrLaterByServerGuid((String)vcService.getServiceGuid()) ? Client.Factory.createClient((URI)this.lookupSmsURI(vcService), (Class)versions.SMS_VERSION_NEWEST, (ClientConfiguration)httpClientConfiguration) : Client.Factory.createClient((URI)this.lookupSmsURI(vcService), this._versionClass, (ClientConfiguration)httpClientConfiguration);
        return new SmsServiceImpl(client);
    }

    private static boolean isVcFromStartupLinkedVcGroup(String vcServiceGuid) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return false;
        }
        LinkedVcGroup[] startupGroups = linkedVcGroupRegistry.getUtils().getStartupLinkedVcGroups();
        if (startupGroups == null) {
            return false;
        }
        for (LinkedVcGroup vcGroup : startupGroups) {
            if (vcGroup.getVcService(vcServiceGuid) == null) continue;
            return true;
        }
        return false;
    }

    private URI lookupSmsURI(VcService vcService) throws EntryNotFoundFault, LocationLookupException {
        if (VcServiceUtil.is60VcOrLater((String)vcService.getServiceGuid()) && SmsServiceFactory.isVcFromStartupLinkedVcGroup(vcService.getServiceGuid())) {
            String vcServiceGuid = vcService.getServiceGuid();
            ServiceRegistration.Info vcServiceInfo = this._lookupService.find(vcServiceGuid);
            ServiceRegistration.ServiceType serviceType = new ServiceRegistration.ServiceType("com.vmware.vim.sms", "sms");
            ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
            filter.setNodeId(vcServiceInfo.getNodeId());
            filter.setServiceType(serviceType);
            ServiceRegistration.Info[] searchResult = this._lookupService.getServiceRegistrationInfos(filter);
            ServiceRegistration.Endpoint endpoint = null;
            if (searchResult.length > 0) {
                ServiceRegistration.Info smsServiceVersion = searchResult[0];
                endpoint = LookupUtil.getEndpoint((ServiceRegistration.Info)smsServiceVersion, (String)"com.vmware.vim.sms");
                endpoint = Objects.requireNonNull(endpoint);
            }
            return endpoint.getUrl();
        }
        return SmsServiceLocationLookup.getSmsServiceLocation(vcService);
    }
}

