/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sms.impl;

import com.vmware.vim.binding.sms.ServiceInstance;
import com.vmware.vim.binding.sms.StorageManager;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vsphere.client.sms.SmsService;
import com.vmware.vsphere.client.sms.impl.SmsServiceUnableToConnectException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SmsServiceImpl
implements SmsService {
    private static final Log _logger = LogFactory.getLog(SmsServiceImpl.class);
    private static final String SERVICE_INSTANCE_MO_REF_TYPE = "SmsServiceInstance";
    private static final String SERVICE_INSTANCE_MO_REF_ID = "ServiceInstance";
    private Client _vmomiClient;
    private ServiceInstance _serviceInstance;
    private VmodlTypeMap _typeMap;
    private StorageManager _storageManager;

    public SmsServiceImpl(Client vmomiClient) {
        this._vmomiClient = vmomiClient;
        this._typeMap = VmodlTypeMap.Factory.getTypeMap();
    }

    @Override
    public ServiceInstance getServiceInstace() {
        if (this._serviceInstance == null) {
            ManagedObjectReference serviceMoRef = new ManagedObjectReference(SERVICE_INSTANCE_MO_REF_TYPE, SERVICE_INSTANCE_MO_REF_ID);
            this._serviceInstance = (ServiceInstance)this.getManagedObject(serviceMoRef);
        }
        return this._serviceInstance;
    }

    @Override
    public StorageManager getStorageManager() throws SmsServiceUnableToConnectException {
        if (this._storageManager == null) {
            BlockingFuture future = new BlockingFuture();
            this.getServiceInstace().queryStorageManager((Future)future);
            try {
                this._storageManager = (StorageManager)this.getManagedObject((ManagedObjectReference)future.get());
            }
            catch (ExecutionException e) {
                throw new SmsServiceUnableToConnectException(e);
            }
            catch (InterruptedException e) {
                throw new SmsServiceUnableToConnectException(e);
            }
        }
        return this._storageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        VmodlType vmodlType = this._typeMap.getVmodlType(moRef.getType());
        Class typeClass = vmodlType.getTypeClass();
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ManagedObject result;
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            ManagedObject managedObject = result = this._vmomiClient.createStub(typeClass, moRef);
            return (T)managedObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    @Override
    public void logout() {
        try {
            if (this._vmomiClient != null) {
                this._vmomiClient.shutdown();
            }
        }
        catch (Exception ex) {
            _logger.error((Object)("Failed to shutdown vlsi client: " + ex.getMessage()));
        }
    }
}

