/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.binding.vim;

import com.vmware.vim.binding.impl.vmodl.DynamicDataImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.CannotAccessLocalSource;
import com.vmware.vim.binding.vim.fault.InvalidLicense;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.fault.LicenseServerUnavailable;
import com.vmware.vim.binding.vim.version.version2;
import com.vmware.vim.binding.vim.version.version5;
import com.vmware.vim.binding.vim.version.version7;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.data;
import com.vmware.vim.binding.vmodl.faults;
import com.vmware.vim.binding.vmodl.internal;
import com.vmware.vim.binding.vmodl.list;
import com.vmware.vim.binding.vmodl.localizable;
import com.vmware.vim.binding.vmodl.managed;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.map;
import com.vmware.vim.binding.vmodl.name;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.propertyOrder;
import com.vmware.vim.binding.vmodl.readonly;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.util.StringUtil;
import java.util.Calendar;

@managed
@versionClass(value=version2.class)
@wsdlName(value="LicenseManager")
public interface LicenseManager
extends ManagedObject {
    @readonly
    @name(value="source")
    @versionClass(value=version2.class)
    public void getSource(Future<LicenseSource> var1);

    @name(value="source")
    public LicenseSource getSource();

    @readonly
    @name(value="sourceAvailable")
    @versionClass(value=version2.class)
    public void isSourceAvailable(Future<Boolean> var1);

    @name(value="sourceAvailable")
    public boolean isSourceAvailable();

    @readonly
    @name(value="diagnostics")
    @versionClass(value=version2.class)
    @optional
    public void getDiagnostics(@optional Future<DiagnosticInfo> var1);

    @name(value="diagnostics")
    public DiagnosticInfo getDiagnostics();

    @readonly
    @name(value="featureInfo")
    @versionClass(value=version2.class)
    @optional
    @map
    public void getFeatureInfo(@optional Future<FeatureInfo[]> var1);

    @name(value="featureInfo")
    public FeatureInfo[] getFeatureInfo();

    @readonly
    @name(value="licensedEdition")
    @versionClass(value=version2.class)
    public void getLicensedEdition(Future<String> var1);

    @name(value="licensedEdition")
    public String getLicensedEdition();

    @readonly
    @name(value="licenses")
    @versionClass(value=version5.class)
    @list
    public void getLicenses(Future<LicenseInfo[]> var1);

    @name(value="licenses")
    public LicenseInfo[] getLicenses();

    @readonly
    @name(value="licenseAssignmentManager")
    @privilege(value="System.View")
    @versionClass(value=version5.class)
    @optional
    @managedObjectType(value="com.vmware.vim.binding.vim.LicenseAssignmentManager")
    public void getLicenseAssignmentManager(@optional @managedObjectType(value="com.vmware.vim.binding.vim.LicenseAssignmentManager") Future<ManagedObjectReference> var1);

    @name(value="licenseAssignmentManager")
    public ManagedObjectReference getLicenseAssignmentManager();

    @readonly
    @name(value="evaluation")
    @privilege(value="System.Read")
    @versionClass(value=version5.class)
    public void getEvaluation(Future<EvaluationInfo> var1);

    @name(value="evaluation")
    public EvaluationInfo getEvaluation();

    @versionClass(value=version2.class)
    @wsdlName(value="QuerySupportedFeatures")
    @privilege(value="Global.Licenses")
    @map
    @Deprecated
    public void querySupportedFeatures(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @optional @map Future<FeatureInfo[]> var2);

    @wsdlName(value="QuerySupportedFeatures")
    @Deprecated
    @optional
    public FeatureInfo[] querySupportedFeatures(ManagedObjectReference var1);

    @versionClass(value=version2.class)
    @wsdlName(value="QueryLicenseSourceAvailability")
    @privilege(value="Global.Licenses")
    @list
    @Deprecated
    public void querySourceAvailability(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @optional @list Future<AvailabilityInfo[]> var2);

    @wsdlName(value="QueryLicenseSourceAvailability")
    @Deprecated
    @optional
    public AvailabilityInfo[] querySourceAvailability(ManagedObjectReference var1);

    @versionClass(value=version2.class)
    @wsdlName(value="QueryLicenseUsage")
    @privilege(value="System.Read")
    @Deprecated
    public void queryUsage(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, Future<LicenseUsageInfo> var2);

    @wsdlName(value="QueryLicenseUsage")
    @Deprecated
    public LicenseUsageInfo queryUsage(ManagedObjectReference var1);

    @versionClass(value=version2.class)
    @wsdlName(value="SetLicenseEdition")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void setEdition(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version2.class) @optional String var2, Future<Void> var3);

    @wsdlName(value="SetLicenseEdition")
    @Deprecated
    public void setEdition(ManagedObjectReference var1, String var2) throws InvalidState, LicenseServerUnavailable;

    @versionClass(value=version2.class)
    @wsdlName(value="CheckLicenseFeature")
    @privilege(value="System.Read")
    @faults(value={"InvalidState"})
    @Deprecated
    public void checkFeature(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version2.class) String var2, Future<Boolean> var3);

    @wsdlName(value="CheckLicenseFeature")
    @Deprecated
    public boolean checkFeature(ManagedObjectReference var1, String var2) throws InvalidState;

    @versionClass(value=version2.class)
    @wsdlName(value="EnableFeature")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void enable(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version2.class) String var2, Future<Boolean> var3);

    @wsdlName(value="EnableFeature")
    @Deprecated
    public boolean enable(ManagedObjectReference var1, String var2) throws InvalidState, LicenseServerUnavailable;

    @versionClass(value=version2.class)
    @wsdlName(value="DisableFeature")
    @privilege(value="Global.Licenses")
    @faults(value={"InvalidState", "LicenseServerUnavailable"})
    @Deprecated
    public void disable(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="featureKey") @versionClass(value=version2.class) String var2, Future<Boolean> var3);

    @wsdlName(value="DisableFeature")
    @Deprecated
    public boolean disable(ManagedObjectReference var1, String var2) throws InvalidState, LicenseServerUnavailable;

    @versionClass(value=version2.class)
    @wsdlName(value="ConfigureLicenseSource")
    @privilege(value="Global.Licenses")
    @faults(value={"CannotAccessLocalSource", "InvalidLicense", "LicenseServerUnavailable"})
    @Deprecated
    public void configureSource(@name(value="host") @versionClass(value=version2.class) @optional @managedObjectType(value="com.vmware.vim.binding.vim.HostSystem") ManagedObjectReference var1, @name(value="licenseSource") @versionClass(value=version2.class) LicenseSource var2, Future<Void> var3);

    @wsdlName(value="ConfigureLicenseSource")
    @Deprecated
    public void configureSource(ManagedObjectReference var1, LicenseSource var2) throws CannotAccessLocalSource, InvalidLicense, LicenseServerUnavailable;

    @versionClass(value=version5.class)
    @wsdlName(value="UpdateLicense")
    @privilege(value="Global.Licenses")
    public void updateLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labels") @versionClass(value=version5.class) @optional @map KeyValue[] var2, Future<LicenseInfo> var3);

    @wsdlName(value="UpdateLicense")
    public LicenseInfo updateLicense(String var1, KeyValue[] var2);

    @versionClass(value=version5.class)
    @wsdlName(value="AddLicense")
    @privilege(value="Global.Licenses")
    public void addLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labels") @versionClass(value=version5.class) @optional @map KeyValue[] var2, Future<LicenseInfo> var3);

    @wsdlName(value="AddLicense")
    public LicenseInfo addLicense(String var1, KeyValue[] var2);

    @versionClass(value=version5.class)
    @wsdlName(value="RemoveLicense")
    @privilege(value="Global.Licenses")
    public void removeLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, Future<Void> var2);

    @wsdlName(value="RemoveLicense")
    public void removeLicense(String var1);

    @versionClass(value=version5.class)
    @wsdlName(value="DecodeLicense")
    @privilege(value="Global.Licenses")
    public void decodeLicense(@name(value="licenseKey") @versionClass(value=version5.class) String var1, Future<LicenseInfo> var2);

    @wsdlName(value="DecodeLicense")
    public LicenseInfo decodeLicense(String var1);

    @versionClass(value=version5.class)
    @wsdlName(value="UpdateLicenseLabel")
    @privilege(value="Global.Licenses")
    public void updateLabel(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labelKey") @versionClass(value=version5.class) String var2, @name(value="labelValue") @versionClass(value=version5.class) String var3, Future<Void> var4);

    @wsdlName(value="UpdateLicenseLabel")
    public void updateLabel(String var1, String var2, String var3);

    @versionClass(value=version5.class)
    @wsdlName(value="RemoveLicenseLabel")
    @privilege(value="Global.Licenses")
    public void removeLabel(@name(value="licenseKey") @versionClass(value=version5.class) String var1, @name(value="labelKey") @versionClass(value=version5.class) String var2, Future<Void> var3);

    @wsdlName(value="RemoveLicenseLabel")
    public void removeLabel(String var1, String var2);

    @versionClass(value=version7.class)
    @wsdlName(value="QueryLicenseDataManager")
    @privilege(value="Global.Licenses")
    @internal
    public void queryLicenseDataManager(@managedObjectType(value="com.vmware.vim.binding.vim.LicenseDataManager") Future<ManagedObjectReference> var1);

    @wsdlName(value="QueryLicenseDataManager")
    @managedObjectType(value="com.vmware.vim.binding.vim.LicenseDataManager")
    public ManagedObjectReference queryLicenseDataManager();

    @versionClass(value=version7.class)
    @wsdlName(value="ActivateRemoteHardEnforcement")
    @privilege(value="Global.Licenses")
    @internal
    public void activateRemoteHardEnforcement(@name(value="remoteHardEnforcementTimeout") @versionClass(value=version7.class) int var1, Future<Void> var2);

    @wsdlName(value="ActivateRemoteHardEnforcement")
    public void activateRemoteHardEnforcement(int var1);

    @versionClass(value=version5.class)
    @wsdlName(value="LicenseManagerLicenseInfo")
    @data
    @propertyOrder(value={"licenseKey", "editionKey", "name", "total", "used", "costUnit", "properties", "labels"})
    public static class LicenseInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String licenseKey;
        public String editionKey;
        public String name;
        public int total;
        public Integer used;
        public String costUnit;
        public KeyAnyValue[] properties;
        public KeyValue[] labels;

        public LicenseInfo() {
        }

        public LicenseInfo(String string, String string2, String string3, int n, Integer n2, String string4, KeyAnyValue[] keyAnyValueArray, KeyValue[] keyValueArray) {
            this.licenseKey = string;
            this.editionKey = string2;
            this.name = string3;
            this.total = n;
            this.used = n2;
            this.costUnit = string4;
            this.properties = keyAnyValueArray;
            this.labels = keyValueArray;
        }

        @versionClass(value=version5.class)
        public String getLicenseKey() {
            return this.licenseKey;
        }

        @versionClass(value=version5.class)
        public void setLicenseKey(String string) {
            this.licenseKey = string;
        }

        @versionClass(value=version5.class)
        public String getEditionKey() {
            return this.editionKey;
        }

        @versionClass(value=version5.class)
        public void setEditionKey(String string) {
            this.editionKey = string;
        }

        @versionClass(value=version5.class)
        public String getName() {
            return this.name;
        }

        @versionClass(value=version5.class)
        public void setName(String string) {
            this.name = string;
        }

        @versionClass(value=version5.class)
        public int getTotal() {
            return this.total;
        }

        @versionClass(value=version5.class)
        public void setTotal(int n) {
            this.total = n;
        }

        @optional
        @versionClass(value=version5.class)
        public Integer getUsed() {
            return this.used;
        }

        @optional
        @versionClass(value=version5.class)
        public void setUsed(Integer n) {
            this.used = n;
        }

        @versionClass(value=version5.class)
        public String getCostUnit() {
            return this.costUnit;
        }

        @versionClass(value=version5.class)
        public void setCostUnit(String string) {
            this.costUnit = string;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public KeyAnyValue[] getProperties() {
            return this.properties;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public void setProperties(KeyAnyValue[] keyAnyValueArray) {
            this.properties = keyAnyValueArray;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public KeyValue[] getLabels() {
            return this.labels;
        }

        @map
        @optional
        @versionClass(value=version5.class)
        public void setLabels(KeyValue[] keyValueArray) {
            this.labels = keyValueArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(400);
            stringBuilder.append("(vim.LicenseInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseKey = ");
            stringBuilder.append(this.getLicenseKey());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("editionKey = ");
            stringBuilder.append(this.getEditionKey());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("name = ");
            stringBuilder.append(this.getName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("total = ");
            stringBuilder.append(this.getTotal());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("used = ");
            stringBuilder.append(this.getUsed());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("costUnit = ");
            stringBuilder.append(this.getCostUnit());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("properties = ");
            if (this.getProperties() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.KeyAnyValue) [\n");
                for (n = 0; n < this.getProperties().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getProperties()[n]), (boolean)true));
                    if (n < this.getProperties().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("labels = ");
            if (this.getLabels() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.KeyValue) [\n");
                for (n = 0; n < this.getLabels().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getLabels()[n])), (boolean)true));
                    if (n < this.getLabels().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version7.class)
    @wsdlName(value="HostLicensableResourceInfo")
    @data
    @propertyOrder(value={"resource"})
    public static class LicensableResourceInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyAnyValue[] resource;

        public LicensableResourceInfo() {
        }

        public LicensableResourceInfo(KeyAnyValue[] keyAnyValueArray) {
            this.resource = keyAnyValueArray;
        }

        @map
        @versionClass(value=version7.class)
        public KeyAnyValue[] getResource() {
            return this.resource;
        }

        @map
        @versionClass(value=version7.class)
        public void setResource(KeyAnyValue[] keyAnyValueArray) {
            this.resource = keyAnyValueArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.LicensableResourceInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("resource = ");
            if (this.getResource() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.KeyAnyValue) [\n");
                for (n = 0; n < this.getResource().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getResource()[n]), (boolean)true));
                    if (n < this.getResource().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version7.class)
        @wsdlName(value="HostLicensableResourceKey")
        public static enum ResourceKey {
            numCpuPackages,
            numCpuCores,
            memorySize,
            memoryForVms,
            numVmsStarted,
            numVmsStarting;

        }
    }

    @versionClass(value=version5.class)
    @wsdlName(value="LicenseManagerEvaluationInfo")
    @data
    @propertyOrder(value={"properties"})
    public static class EvaluationInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public KeyAnyValue[] properties;

        public EvaluationInfo() {
        }

        public EvaluationInfo(KeyAnyValue[] keyAnyValueArray) {
            this.properties = keyAnyValueArray;
        }

        @map
        @versionClass(value=version5.class)
        public KeyAnyValue[] getProperties() {
            return this.properties;
        }

        @map
        @versionClass(value=version5.class)
        public void setProperties(KeyAnyValue[] keyAnyValueArray) {
            this.properties = keyAnyValueArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.EvaluationInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("properties = ");
            if (this.getProperties() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.KeyAnyValue) [\n");
                for (n = 0; n < this.getProperties().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getProperties()[n]), (boolean)true));
                    if (n < this.getProperties().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseUsageInfo")
    @Deprecated
    @data
    @propertyOrder(value={"source", "sourceAvailable", "reservationInfo", "featureInfo"})
    public static class LicenseUsageInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public LicenseSource source;
        public boolean sourceAvailable;
        public ReservationInfo[] reservationInfo;
        public FeatureInfo[] featureInfo;

        public LicenseUsageInfo() {
        }

        public LicenseUsageInfo(LicenseSource licenseSource, boolean bl, ReservationInfo[] reservationInfoArray, FeatureInfo[] featureInfoArray) {
            this.source = licenseSource;
            this.sourceAvailable = bl;
            this.reservationInfo = reservationInfoArray;
            this.featureInfo = featureInfoArray;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public LicenseSource getSource() {
            return this.source;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setSource(LicenseSource licenseSource) {
            this.source = licenseSource;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public boolean isSourceAvailable() {
            return this.sourceAvailable;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setSourceAvailable(boolean bl) {
            this.sourceAvailable = bl;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public ReservationInfo[] getReservationInfo() {
            return this.reservationInfo;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setReservationInfo(ReservationInfo[] reservationInfoArray) {
            this.reservationInfo = reservationInfoArray;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public FeatureInfo[] getFeatureInfo() {
            return this.featureInfo;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setFeatureInfo(FeatureInfo[] featureInfoArray) {
            this.featureInfo = featureInfoArray;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(240);
            stringBuilder.append("(vim.LicenseUsageInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("source = ");
            if (this.getSource() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getSource())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sourceAvailable = ");
            stringBuilder.append(this.isSourceAvailable());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("reservationInfo = ");
            if (this.getReservationInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.ReservationInfo) [\n");
                for (n = 0; n < this.getReservationInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getReservationInfo()[n])), (boolean)true));
                    if (n < this.getReservationInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("featureInfo = ");
            if (this.getFeatureInfo() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vim.FeatureInfo) [\n");
                for (n = 0; n < this.getFeatureInfo().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getFeatureInfo()[n])), (boolean)true));
                    if (n < this.getFeatureInfo().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseDiagnostics")
    @Deprecated
    @data
    @propertyOrder(value={"sourceLastChanged", "sourceLost", "sourceLatency", "licenseRequests", "licenseRequestFailures", "licenseFeatureUnknowns", "opState", "lastStatusUpdate", "opFailureMessage"})
    public static class DiagnosticInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public Calendar sourceLastChanged;
        public String sourceLost;
        public float sourceLatency;
        public String licenseRequests;
        public String licenseRequestFailures;
        public String licenseFeatureUnknowns;
        public LicenseState opState;
        public Calendar lastStatusUpdate;
        public String opFailureMessage;

        public DiagnosticInfo() {
        }

        public DiagnosticInfo(Calendar calendar, String string, float f, String string2, String string3, String string4, LicenseState licenseState, Calendar calendar2, String string5) {
            this.sourceLastChanged = calendar;
            this.sourceLost = string;
            this.sourceLatency = f;
            this.licenseRequests = string2;
            this.licenseRequestFailures = string3;
            this.licenseFeatureUnknowns = string4;
            this.opState = licenseState;
            this.lastStatusUpdate = calendar2;
            this.opFailureMessage = string5;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public Calendar getSourceLastChanged() {
            return this.sourceLastChanged;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setSourceLastChanged(Calendar calendar) {
            this.sourceLastChanged = calendar;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getSourceLost() {
            return this.sourceLost;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setSourceLost(String string) {
            this.sourceLost = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public float getSourceLatency() {
            return this.sourceLatency;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setSourceLatency(float f) {
            this.sourceLatency = f;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getLicenseRequests() {
            return this.licenseRequests;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLicenseRequests(String string) {
            this.licenseRequests = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getLicenseRequestFailures() {
            return this.licenseRequestFailures;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLicenseRequestFailures(String string) {
            this.licenseRequestFailures = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getLicenseFeatureUnknowns() {
            return this.licenseFeatureUnknowns;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLicenseFeatureUnknowns(String string) {
            this.licenseFeatureUnknowns = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public LicenseState getOpState() {
            return this.opState;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setOpState(LicenseState licenseState) {
            this.opState = licenseState;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public Calendar getLastStatusUpdate() {
            return this.lastStatusUpdate;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLastStatusUpdate(Calendar calendar) {
            this.lastStatusUpdate = calendar;
        }

        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public String getOpFailureMessage() {
            return this.opFailureMessage;
        }

        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public void setOpFailureMessage(String string) {
            this.opFailureMessage = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(440);
            stringBuilder.append("(vim.DiagnosticInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sourceLastChanged = ");
            stringBuilder.append(this.getSourceLastChanged());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sourceLost = ");
            stringBuilder.append(this.getSourceLost());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sourceLatency = ");
            stringBuilder.append(this.getSourceLatency());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseRequests = ");
            stringBuilder.append(this.getLicenseRequests());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseRequestFailures = ");
            stringBuilder.append(this.getLicenseRequestFailures());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseFeatureUnknowns = ");
            stringBuilder.append(this.getLicenseFeatureUnknowns());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("opState = ");
            stringBuilder.append((Object)this.getOpState());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("lastStatusUpdate = ");
            stringBuilder.append(this.getLastStatusUpdate());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("opFailureMessage = ");
            stringBuilder.append(this.getOpFailureMessage());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseAvailabilityInfo")
    @Deprecated
    @data
    @propertyOrder(value={"feature", "total", "available"})
    public static class AvailabilityInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public FeatureInfo feature;
        public int total;
        public int available;

        public AvailabilityInfo() {
        }

        public AvailabilityInfo(FeatureInfo featureInfo, int n, int n2) {
            this.feature = featureInfo;
            this.total = n;
            this.available = n2;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public FeatureInfo getFeature() {
            return this.feature;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setFeature(FeatureInfo featureInfo) {
            this.feature = featureInfo;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public int getTotal() {
            return this.total;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setTotal(int n) {
            this.total = n;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public int getAvailable() {
            return this.available;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setAvailable(int n) {
            this.available = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.AvailabilityInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("feature = ");
            if (this.getFeature() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(StringUtil.indent((String)("" + (Object)((Object)this.getFeature())), (boolean)false));
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("total = ");
            stringBuilder.append(this.getTotal());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("available = ");
            stringBuilder.append(this.getAvailable());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseReservationInfo")
    @Deprecated
    @data
    @propertyOrder(value={"key", "state", "required"})
    public static class ReservationInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public State state;
        public int required;

        public ReservationInfo() {
        }

        public ReservationInfo(String string, State state, int n) {
            this.key = string;
            this.state = state;
            this.required = n;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setKey(String string) {
            this.key = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public State getState() {
            return this.state;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setState(State state) {
            this.state = state;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public int getRequired() {
            return this.required;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setRequired(int n) {
            this.required = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("(vim.ReservationInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("key = ");
            stringBuilder.append(this.getKey());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("state = ");
            stringBuilder.append((Object)this.getState());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("required = ");
            stringBuilder.append(this.getRequired());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version2.class)
        @wsdlName(value="LicenseReservationInfoState")
        public static enum State {
            notUsed,
            noLicense,
            unlicensedUse,
            licensed;

        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseFeatureInfo")
    @Deprecated
    @data
    @propertyOrder(value={"key", "featureName", "featureDescription", "state", "costUnit", "sourceRestriction", "dependentKey", "edition", "expiresOn"})
    public static class FeatureInfo
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;
        public String key;
        public String featureName;
        public String featureDescription;
        public State state;
        public String costUnit;
        public String sourceRestriction;
        public String[] dependentKey;
        public Boolean edition;
        public Calendar expiresOn;

        public FeatureInfo() {
        }

        public FeatureInfo(String string, String string2, String string3, State state, String string4, String string5, String[] stringArray, Boolean bl, Calendar calendar) {
            this.key = string;
            this.featureName = string2;
            this.featureDescription = string3;
            this.state = state;
            this.costUnit = string4;
            this.sourceRestriction = string5;
            this.dependentKey = stringArray;
            this.edition = bl;
            this.expiresOn = calendar;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getKey() {
            return this.key;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setKey(String string) {
            this.key = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public String getFeatureName() {
            return this.featureName;
        }

        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public void setFeatureName(String string) {
            this.featureName = string;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public String getFeatureDescription() {
            return this.featureDescription;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        @localizable
        public void setFeatureDescription(String string) {
            this.featureDescription = string;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public State getState() {
            return this.state;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setState(State state) {
            this.state = state;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getCostUnit() {
            return this.costUnit;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setCostUnit(String string) {
            this.costUnit = string;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public String getSourceRestriction() {
            return this.sourceRestriction;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setSourceRestriction(String string) {
            this.sourceRestriction = string;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public String[] getDependentKey() {
            return this.dependentKey;
        }

        @map
        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setDependentKey(String[] stringArray) {
            this.dependentKey = stringArray;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean isEdition() {
            return this.edition;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Boolean getEdition() {
            return this.edition;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setEdition(Boolean bl) {
            this.edition = bl;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Calendar getExpiresOn() {
            return this.expiresOn;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setExpiresOn(Calendar calendar) {
            this.expiresOn = calendar;
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder(440);
            stringBuilder.append("(vim.FeatureInfo) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (n = 0; n < this.getDynamicProperty().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[n]), (boolean)true));
                    if (n < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("key = ");
            stringBuilder.append(this.getKey());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("featureName = ");
            stringBuilder.append(this.getFeatureName());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("featureDescription = ");
            stringBuilder.append(this.getFeatureDescription());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("state = ");
            stringBuilder.append((Object)this.getState());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("costUnit = ");
            stringBuilder.append(this.getCostUnit());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("sourceRestriction = ");
            stringBuilder.append(this.getSourceRestriction());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dependentKey = ");
            if (this.getDependentKey() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(STRING) [\n");
                for (n = 0; n < this.getDependentKey().length; ++n) {
                    stringBuilder.append("      ");
                    stringBuilder.append(this.getDependentKey()[n]);
                    if (n < this.getDependentKey().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("edition = ");
            stringBuilder.append(this.isEdition());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("expiresOn = ");
            stringBuilder.append(this.getExpiresOn());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }

        @versionClass(value=version2.class)
        @wsdlName(value="LicenseFeatureInfoSourceRestriction")
        public static enum SourceRestriction {
            unrestricted,
            served,
            file;

        }

        @versionClass(value=version2.class)
        @wsdlName(value="LicenseFeatureInfoState")
        public static enum State {
            enabled,
            disabled,
            optional;

        }

        @versionClass(value=version2.class)
        @wsdlName(value="LicenseFeatureInfoUnit")
        public static enum CostUnit {
            host,
            cpuCore,
            cpuPackage,
            server,
            vm;

        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="EvaluationLicenseSource")
    @Deprecated
    @data
    @propertyOrder(value={"remainingHours"})
    public static class EvaluationLicense
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public Long remainingHours;

        public EvaluationLicense() {
        }

        public EvaluationLicense(Long l) {
            this.remainingHours = l;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public Long getRemainingHours() {
            return this.remainingHours;
        }

        @optional
        @versionClass(value=version2.class)
        @Deprecated
        public void setRemainingHours(Long l) {
            this.remainingHours = l;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.EvaluationLicense) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("remainingHours = ");
            stringBuilder.append(this.getRemainingHours());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LocalLicenseSource")
    @Deprecated
    @data
    @propertyOrder(value={"licenseKeys"})
    public static class LocalLicense
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public String licenseKeys;

        public LocalLicense() {
        }

        public LocalLicense(String string) {
            this.licenseKeys = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getLicenseKeys() {
            return this.licenseKeys;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLicenseKeys(String string) {
            this.licenseKeys = string;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.LocalLicense) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseKeys = ");
            stringBuilder.append(this.getLicenseKeys());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseServerSource")
    @Deprecated
    @data
    @propertyOrder(value={"licenseServer"})
    public static class LicenseServer
    extends LicenseSource {
        private static final long serialVersionUID = 1L;
        public String licenseServer;

        public LicenseServer() {
        }

        public LicenseServer(String string) {
            this.licenseServer = string;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public String getLicenseServer() {
            return this.licenseServer;
        }

        @versionClass(value=version2.class)
        @Deprecated
        public void setLicenseServer(String string) {
            this.licenseServer = string;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(120);
            stringBuilder.append("(vim.LicenseServer) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("licenseServer = ");
            stringBuilder.append(this.getLicenseServer());
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseSource")
    @Deprecated
    @data
    public static class LicenseSource
    extends DynamicDataImpl {
        private static final long serialVersionUID = 1L;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(80);
            stringBuilder.append("(vim.LicenseSource) {\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicType = ");
            stringBuilder.append(this.getDynamicType());
            stringBuilder.append(",\n");
            stringBuilder.append("   ");
            stringBuilder.append("dynamicProperty = ");
            if (this.getDynamicProperty() == null) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append("(vmodl.DynamicProperty) [\n");
                for (int i = 0; i < this.getDynamicProperty().length; ++i) {
                    stringBuilder.append("      ");
                    stringBuilder.append(StringUtil.indent((String)("" + this.getDynamicProperty()[i]), (boolean)true));
                    if (i < this.getDynamicProperty().length - 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append("\n");
                }
                stringBuilder.append("   ");
                stringBuilder.append("]");
            }
            stringBuilder.append("\n}");
            return stringBuilder.toString();
        }
    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseManagerLicenseKey")
    @Deprecated
    public static enum LicenseKey {
        esxFull,
        esxVmtn,
        esxExpress,
        san,
        iscsi,
        nas,
        vsmp,
        backup,
        vc,
        vcExpress,
        esxHost,
        gsxHost,
        serverHost,
        drsPower,
        vmotion,
        drs,
        das;

    }

    @versionClass(value=version2.class)
    @wsdlName(value="LicenseManagerState")
    @Deprecated
    public static enum LicenseState {
        initializing,
        normal,
        marginal,
        fault;

    }
}

