/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.idp.provision.client.vmomi.impl;

import com.vmware.vim.binding.idp.fault.NoPermission;
import com.vmware.vim.binding.idp.fault.NotAuthenticated;
import com.vmware.vim.binding.idp.fault.ServiceFault;
import com.vmware.vim.binding.idp.provision.fault.DuplicateIdpNameFault;
import com.vmware.vim.binding.idp.provision.fault.IdpNotFoundFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.vmodl.fault.InvalidArgument;
import com.vmware.vim.idp.exception.DuplicateIdpNameException;
import com.vmware.vim.idp.exception.IdpNotFoundException;
import com.vmware.vim.idp.exception.InternalError;
import com.vmware.vim.idp.exception.InvalidCredentialsException;
import com.vmware.vim.idp.exception.NoPermissionException;
import com.vmware.vim.idp.exception.NotAuthenticatedException;
import com.vmware.vim.idp.exception.ServiceException;
import com.vmware.vim.idp.exception.SystemException;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.SslException;
import com.vmware.vim.vmomi.core.exception.CertificateValidationException;

public abstract class VmomiClientCommand<T> {
    public final T execute() throws ServiceException, SystemException {
        try {
            return this.actionCommand();
        }
        catch (SslException e) {
            if (e.getCause() instanceof CertificateValidationException) {
                CertificateValidationException cause = (CertificateValidationException)e.getCause();
                throw new com.vmware.vim.sso.admin.exception.CertificateValidationException(e.getMessage(), (Throwable)cause, cause.getCertificateChain(), cause.getThumbprint());
            }
            throw new InternalError(e.getMessage(), e.getCause());
        }
        catch (ConnectionException e) {
            throw new com.vmware.vim.idp.exception.ConnectionException(e.getMessage(), (Throwable)e);
        }
        catch (DuplicateIdpNameFault e) {
            throw new DuplicateIdpNameException((Throwable)e, e.getIdpName());
        }
        catch (IdpNotFoundFault e) {
            throw new IdpNotFoundException((Throwable)e, e.getIdpName());
        }
        catch (ServiceFault e) {
            throw new InternalError("Unhandled VMODL fault.", (Throwable)e);
        }
        catch (InvalidCredentials e) {
            throw new InvalidCredentialsException(e.getMessage());
        }
        catch (NoPermission e) {
            throw new NoPermissionException(e.getMessage());
        }
        catch (NotAuthenticated e) {
            throw new NotAuthenticatedException(e.getMessage());
        }
        catch (InvalidArgument e) {
            throw new IllegalArgumentException(e.getMessage(), e.getCause());
        }
        catch (Bug e) {
            throw new InternalError("Error: ", (Throwable)((Object)e));
        }
        catch (Exception e) {
            throw new InternalError("General failure.", (Throwable)e);
        }
    }

    public abstract T actionCommand() throws ServiceFault;

    public final T executeEnsuringNoDomainError() {
        try {
            return this.execute();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    public final <T1 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1) throws T1 {
        return this.executeEnsuringDomainErrorIs(c1, c1, c1, c1);
    }

    private final <T1 extends ServiceException, T2 extends ServiceException, T3 extends ServiceException, T4 extends ServiceException> T executeEnsuringDomainErrorIs(Class<T1> c1, Class<T2> c2, Class<T3> c3, Class<T4> c4) throws T1, T2, T3, T4 {
        try {
            T res = this.execute();
            return res;
        }
        catch (ServiceException e) {
            if (c1.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c2.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c3.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            if (c4.equals(((Object)((Object)e)).getClass())) {
                throw e;
            }
            throw new Bug(e);
        }
    }

    private static class Bug
    extends SystemException {
        private static final long serialVersionUID = -1538109311689564834L;

        public Bug(Throwable t) {
            super(t);
        }
    }
}

