/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import java.net.URI;
import java.security.KeyStore;

public final class VmomiClientConfiguration {
    private static final Version DEF_VERSION = Version.Version1;
    private final URI _serverUri;
    private final Version _version;
    private final SslConfiguration _sslConfig;

    private VmomiClientConfiguration(URI serverUri, Version version, SslConfiguration sslConfig) {
        assert (serverUri != null);
        this._serverUri = serverUri;
        this._version = version == null ? DEF_VERSION : version;
        this._sslConfig = sslConfig;
    }

    public URI getServerUri() {
        return this._serverUri;
    }

    public Version getVersion() {
        return this._version;
    }

    public SslConfiguration getSslConfig() {
        return this._sslConfig;
    }

    public static enum Version {
        Version1,
        Version1_5,
        Version2,
        Version2_5,
        Version3,
        Version3_1,
        Version3_2,
        Version3_5;

    }

    public static class SslConfiguration {
        private final ThumbprintVerifier _verifier;
        private final KeyStore _trustStore;
        private final String _trustStorePass;

        public SslConfiguration(ThumbprintVerifier thumbprintVerifier) {
            this(thumbprintVerifier, null, null);
        }

        public SslConfiguration(ThumbprintVerifier thumbprintVerifier, KeyStore trustStore, String trustStorePass) {
            this._verifier = thumbprintVerifier;
            this._trustStore = trustStore;
            this._trustStorePass = trustStorePass;
        }

        public ThumbprintVerifier getThumbprintVerifier() {
            return this._verifier;
        }

        public KeyStore getTrustStore() {
            return this._trustStore;
        }

        public String getTrustStorePass() {
            return this._trustStorePass;
        }
    }

    public static class Builder {
        private final URI _serverUri;
        private final Version _version;
        private SslConfiguration _sslConfig;

        public Builder(URI serverUri) {
            ValidateUtil.validateNotNull((Object)serverUri, (String)"Server URI");
            this._serverUri = serverUri;
            this._version = null;
        }

        public Builder(URI serverUri, Version version) {
            ValidateUtil.validateNotNull((Object)serverUri, (String)"Server URI");
            ValidateUtil.validateNotNull((Object)((Object)version), (String)"Server version");
            this._serverUri = serverUri;
            this._version = version;
        }

        public Builder setSslConfiguration(SslConfiguration sslConfig) {
            ValidateUtil.validateNotNull((Object)sslConfig, (String)"SSL configuration");
            this._sslConfig = sslConfig;
            return this;
        }

        public VmomiClientConfiguration createConfig() {
            return new VmomiClientConfiguration(this._serverUri, this._version, this._sslConfig);
        }
    }
}

