/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.DomainManagementService;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.admin.fault.DomainNotFoundFault;
import com.vmware.vim.binding.sso.admin.fault.DuplicateDomainNameFault;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.admin.CertificateManagement;
import com.vmware.vim.sso.admin.DomainManagement;
import com.vmware.vim.sso.admin.Domains;
import com.vmware.vim.sso.admin.ExternalDomain;
import com.vmware.vim.sso.admin.ExternalDomainDetails;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DomainNotFoundException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.LocalOSDomainRegistrationException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.net.URI;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class DomainManagementImpl
implements DomainManagement {
    private static final String AUTH_CRED_NULL_ERR_MGS = "Authentication credentials should be NULL for authentication type ";
    private final DomainManagementService _service;
    private final CertificateManagement _certificateManagement;

    public DomainManagementImpl(DomainManagementService service, CertificateManagement certificateManagement) {
        assert (service != null);
        assert (certificateManagement != null);
        this._service = service;
        this._certificateManagement = certificateManagement;
    }

    public void addExternalDomain(final ExternalDomain.Type serverType, final String domainName, final String domainAlias, final ExternalDomainDetails details, final ExternalDomain.AuthenticationType authenticationType, final DomainManagement.AuthenticationCredentails authnCredentials) throws DirectoryServiceConnectionException, DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)serverType, (String)"Server type");
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"Domain name");
        if (domainAlias != null) {
            ValidateUtil.validateNotEmpty((Object)domainAlias, (String)"Domain alias");
        }
        ValidateUtil.validateNotNull((Object)details, (String)"Domain details");
        this.validateAuthTypeAndCredentials(authenticationType, authnCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DirectoryServiceConnectionFault, DuplicateDomainNameFault, NotAuthenticated {
                DomainManagementImpl.this._service.addExternalDomain(serverType.name(), domainName, domainAlias, VmodlTypeConversions.toVmodl((ExternalDomainDetails)details), authenticationType.name(), SdkVmodlTypeConversions.toVmodl(authnCredentials));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DirectoryServiceConnectionException.class, DuplicateDomainNameException.class, NotAuthenticatedException.class);
    }

    public void registerLocalOSDomain(final String domainName) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, LocalOSDomainRegistrationException {
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"Domain Name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DuplicateDomainNameFault, NotAuthenticated {
                DomainManagementImpl.this._service.registerLocalOSDomain(domainName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DuplicateDomainNameException.class, NotAuthenticatedException.class);
    }

    public void deleteDomain(final String name) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"Domain name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                DomainManagementImpl.this._service.deleteDomain(name);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
    }

    public ExternalDomain findExternalDomain(final String filter) throws NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)filter, (String)"Search filter");
        return (ExternalDomain)new VmomiClientCommand<ExternalDomain>(){

            @Override
            public ExternalDomain actionCommand() throws NotAuthenticated {
                return SdkVmodlTypeConversions.fromVmodl(DomainManagementImpl.this._service.findExternalDomain(filter));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setBrandName(final String brandName) throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.setBrandName(brandName);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public String getBrandName() throws NotAuthenticatedException, NoPermissionException {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getBrandName();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setLogonBanner(final String logonBanner) throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.setLogonBanner(logonBanner);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public String getLogonBanner() throws NotAuthenticatedException, NoPermissionException {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getLogonBanner();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setLogonBannerTitle(final String logonBannerTitle) throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.setLogonBannerTitle(logonBannerTitle);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public String getLogonBannerTitle() throws NotAuthenticatedException, NoPermissionException {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getLogonBannerTitle();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setLogonBannerContent(final String logonBannerContent) throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.setLogonBannerContent(logonBannerContent);
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public String getLogonBannerContent() throws NotAuthenticatedException, NoPermissionException {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getLogonBannerContent();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void setLogonBannerCheckboxFlag(final boolean enableLogonBannerCheckbox) throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.setLogonBannerCheckboxFlag(Boolean.valueOf(enableLogonBannerCheckbox));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public boolean getLogonBannerCheckboxFlag() throws NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getLogonBannerCheckboxFlag();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void disableLogonBanner() throws NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated {
                DomainManagementImpl.this._service.disableLogonBanner();
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public boolean isLogonBannerDisabled() throws NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.isLogonBannerDisabled();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public Domains getDomains() throws NotAuthenticatedException, NoPermissionException {
        return (Domains)new VmomiClientCommand<Domains>(){

            @Override
            public Domains actionCommand() throws NotAuthenticated {
                return SdkVmodlTypeConversions.fromVmodl(DomainManagementImpl.this._service.getDomains());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public CertificateManagement getSslCertificateManagement() {
        return this._certificateManagement;
    }

    public String getSystemDomainName() {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() {
                return DomainManagementImpl.this._service.getSystemDomainName();
            }
        }.executeEnsuringNoDomainError();
    }

    public String getLocalOSDomainName() throws NotAuthenticatedException, NoPermissionException {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getLocalOSDomainName();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void probeConnectivity(URI serviceUri, ExternalDomain.AuthenticationType authenticationType, DomainManagement.AuthenticationCredentails authenticationCredentials) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        this.probeConnectivity(serviceUri, authenticationType, authenticationCredentials, null);
    }

    public void probeConnectivity(final URI serviceUri, final ExternalDomain.AuthenticationType authenticationType, final DomainManagement.AuthenticationCredentails authenticationCredentials, final Collection<X509Certificate> certificates) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)serviceUri, (String)"Service URI");
        this.validateAuthTypeAndCredentials(authenticationType, authenticationCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DirectoryServiceConnectionFault, NotAuthenticated {
                DomainManagementImpl.this._service.probeConnectivity(serviceUri, authenticationType.name(), SdkVmodlTypeConversions.toVmodl(authenticationCredentials), VmodlTypeConversions.certificatesToVmodl((Collection)certificates));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DirectoryServiceConnectionException.class, NotAuthenticatedException.class);
    }

    public void updateExternalDomainAuthnType(final String name, final ExternalDomain.AuthenticationType authnType, final DomainManagement.AuthenticationCredentails authnCredentials) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException, DirectoryServiceConnectionException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"External domain name");
        this.validateAuthTypeAndCredentials(authnType, authnCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                DomainManagementImpl.this._service.updateExternalDomainAuthnType(name, authnType.name(), SdkVmodlTypeConversions.toVmodl(authnCredentials));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class, DirectoryServiceConnectionException.class);
    }

    public void updateExternalDomainDetails(final String name, final ExternalDomainDetails details) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"External domain name");
        ValidateUtil.validateNotNull((Object)details, (String)"External domain details");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                DomainManagementImpl.this._service.updateExternalDomainDetails(name, VmodlTypeConversions.toVmodl((ExternalDomainDetails)details));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
    }

    public List<String> getDefaultDomains() throws NoPermissionException, NotAuthenticatedException {
        String[] domains = (String[])new VmomiClientCommand<String[]>(){

            @Override
            public String[] actionCommand() throws NotAuthenticated {
                return DomainManagementImpl.this._service.getDefaultDomains();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
        return domains != null && domains.length != 0 ? Arrays.asList(domains) : Collections.emptyList();
    }

    public void setDefaultDomains(final List<String> domainNames) throws DomainNotFoundException, DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, DuplicateDomainNameFault, NotAuthenticated {
                String[] arrStr = domainNames == null || domainNames.isEmpty() ? new String[]{} : domainNames.toArray(new String[domainNames.size()]);
                DomainManagementImpl.this._service.setDefaultDomains(arrStr);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, DuplicateDomainNameException.class, NotAuthenticatedException.class);
    }

    public CertPath getSslIdentity(final String host, final int port) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        return (CertPath)new VmomiClientCommand<CertPath>(){

            @Override
            public CertPath actionCommand() throws DomainNotFoundFault, DirectoryServiceConnectionFault, NotAuthenticated {
                return SdkVmodlTypeConversions.fromVmodl(DomainManagementImpl.this._service.getSslIdentity(host, port));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public boolean registerUpnSuffix(final String domainName, final String upnSuffix) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"Domain name");
        ValidateUtil.validateNotEmpty((Object)upnSuffix, (String)"UPN suffix");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                return DomainManagementImpl.this._service.registerUpnSuffix(domainName, upnSuffix);
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
    }

    public boolean unRegisterUpnSuffix(final String domainName, final String upnSuffix) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"Domain name");
        ValidateUtil.validateNotEmpty((Object)upnSuffix, (String)"UPN suffix");
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                return DomainManagementImpl.this._service.unRegisterUpnSuffix(domainName, upnSuffix);
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
    }

    public Set<String> getUpnSuffixes(final String domainName) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"Domain name");
        String[] result = (String[])new VmomiClientCommand<String[]>(){

            @Override
            public String[] actionCommand() throws DomainNotFoundFault, NotAuthenticated {
                return DomainManagementImpl.this._service.getUpnSuffixes(domainName);
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
        if (null == result) {
            return null;
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(result)));
    }

    public String getSystemTenantName() {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() {
                return DomainManagementImpl.this._service.getSystemTenantName();
            }
        }.executeEnsuringNoDomainError();
    }

    private void validateAuthTypeAndCredentials(ExternalDomain.AuthenticationType authType, DomainManagement.AuthenticationCredentails authCredentials) {
        ValidateUtil.validateNotNull((Object)authType, (String)"Authentication type");
        if (authType.equals((Object)ExternalDomain.AuthenticationType.password) || authType.equals((Object)ExternalDomain.AuthenticationType.reuseSession)) {
            ValidateUtil.validateNotNull((Object)authCredentials, (String)"Authentication credentials");
        } else if (authCredentials != null) {
            throw new IllegalArgumentException(AUTH_CRED_NULL_ERR_MGS + authType.toString());
        }
    }
}

