/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.IdentitySourceManagementService;
import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.admin.fault.DirectoryServiceConnectionFault;
import com.vmware.vim.binding.sso.admin.fault.DomainManagerFault;
import com.vmware.vim.binding.sso.admin.fault.DomainNotFoundFault;
import com.vmware.vim.binding.sso.admin.fault.DuplicateDomainNameFault;
import com.vmware.vim.binding.sso.admin.fault.HostNotJoinedRequiredDomainFault;
import com.vmware.vim.binding.sso.admin.fault.InvalidProviderFault;
import com.vmware.vim.binding.sso.fault.InvalidPrincipalFault;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.admin.AuthenticationAccountInfo;
import com.vmware.vim.sso.admin.CertificateManagement;
import com.vmware.vim.sso.admin.ExternalDomainSchemaDetails;
import com.vmware.vim.sso.admin.IdentitySourceManagement;
import com.vmware.vim.sso.admin.IdentitySources;
import com.vmware.vim.sso.admin.LdapIdentitySource;
import com.vmware.vim.sso.admin.LdapIdentitySourceDetails;
import com.vmware.vim.sso.admin.client.vmomi.impl.SdkVmodlTypeConversions;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.ADIDPRegistrationServiceException;
import com.vmware.vim.sso.admin.exception.ADIDSAlreadyExistException;
import com.vmware.vim.sso.admin.exception.DirectoryServiceConnectionException;
import com.vmware.vim.sso.admin.exception.DomainManagerException;
import com.vmware.vim.sso.admin.exception.DomainNotFoundException;
import com.vmware.vim.sso.admin.exception.DuplicateDomainNameException;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.InvalidProviderException;
import com.vmware.vim.sso.admin.exception.LocalOSDomainRegistrationException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;
import java.net.URI;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class IdentitySourceManagementImpl
implements IdentitySourceManagement {
    private static final String AUTH_CRED_NULL_ERR_MGS = "Authentication credentials should be NULL for authentication type ";
    private final IdentitySourceManagementService _service;
    private final CertificateManagement _certificateManagement;

    public IdentitySourceManagementImpl(IdentitySourceManagementService service, CertificateManagement certificateManagement) {
        assert (service != null);
        assert (certificateManagement != null);
        this._service = service;
        this._certificateManagement = certificateManagement;
    }

    public void registerLdap(final LdapIdentitySource.KnownType type, final String name, final String domainAlias, final LdapIdentitySourceDetails details, final LdapIdentitySource.KnownAuthenticationType authenticationType, final IdentitySourceManagement.AuthenticationCredentials authnCredentials) throws DuplicateDomainNameException, InvalidProviderException, NotAuthenticatedException, NoPermissionException, DirectoryServiceConnectionException, ADIDSAlreadyExistException {
        ValidateUtil.validateNotNull((Object)type, (String)"server type");
        ValidateUtil.validateNotEmpty((Object)name, (String)"LDAP IdS name");
        if (domainAlias != null) {
            ValidateUtil.validateNotEmpty((Object)domainAlias, (String)"LDAP IdS alias");
        }
        ValidateUtil.validateNotNull((Object)details, (String)"LDAP IdS details");
        this.validateAuthTypeAndCredentials(authenticationType, authnCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DuplicateDomainNameFault, InvalidProviderFault, ADIDSAlreadyExistFault, DirectoryServiceConnectionFault, NotAuthenticated {
                IdentitySourceManagementImpl.this._service.registerLdap(type.name(), name, domainAlias, VmodlTypeConversions.toVmodl((LdapIdentitySourceDetails)details), authenticationType.name(), SdkVmodlTypeConversions.toVmodl(authnCredentials));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DuplicateDomainNameException.class, InvalidProviderException.class, ADIDSAlreadyExistException.class, NotAuthenticatedException.class, DirectoryServiceConnectionException.class);
    }

    public void registerActiveDirectory(final String domainName, final IdentitySourceManagement.AuthenticationCredentials authnCredentials, final ExternalDomainSchemaDetails schemaMapping) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, InvalidPrincipalException, ADIDPRegistrationServiceException {
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"domain name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DuplicateDomainNameFault, NotAuthenticated, InvalidPrincipalFault, ADIDSAlreadyExistFault, HostNotJoinedRequiredDomainFault, DomainManagerFault {
                IdentitySourceManagementImpl.this._service.registerActiveDirectory(domainName, SdkVmodlTypeConversions.toVmodl(authnCredentials), VmodlTypeConversions.toVmodl((ExternalDomainSchemaDetails)schemaMapping));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DuplicateDomainNameException.class, NotAuthenticatedException.class, InvalidPrincipalException.class, ADIDPRegistrationServiceException.class);
    }

    public void registerLocalOS(final String name) throws DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException, LocalOSDomainRegistrationException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DuplicateDomainNameFault, NotAuthenticated {
                IdentitySourceManagementImpl.this._service.registerLocalOS(name);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DuplicateDomainNameException.class, NotAuthenticatedException.class);
    }

    public IdentitySources get() throws NotAuthenticatedException, NoPermissionException {
        return (IdentitySources)new VmomiClientCommand<IdentitySources>(){

            @Override
            public IdentitySources actionCommand() throws NotAuthenticated {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.IdentitySources)IdentitySourceManagementImpl.this._service.get());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public AuthenticationAccountInfo getActiveDirectoryAuthnAccountInfo() throws NotAuthenticatedException, NoPermissionException {
        return (AuthenticationAccountInfo)new VmomiClientCommand<AuthenticationAccountInfo>(){

            @Override
            public AuthenticationAccountInfo actionCommand() throws NotAuthenticated {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.AuthenticationAccountInfo)IdentitySourceManagementImpl.this._service.getActiveDirectoryAuthnAccountInfo());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public String getSystemDomainName() {
        return (String)new VmomiClientCommand<String>(){

            @Override
            public String actionCommand() throws NotAuthenticated {
                return IdentitySourceManagementImpl.this._service.getSystemDomainName();
            }
        }.executeEnsuringNoDomainError();
    }

    public void updateLdap(final String name, final LdapIdentitySourceDetails details) throws DomainNotFoundException, InvalidProviderException, DirectoryServiceConnectionException, NoPermissionException, NotAuthenticatedException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"LDAP IdS name");
        ValidateUtil.validateNotNull((Object)details, (String)"LDAP IdS details");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, DirectoryServiceConnectionFault, DomainNotFoundFault, InvalidProviderFault {
                IdentitySourceManagementImpl.this._service.updateLdap(name, VmodlTypeConversions.toVmodl((LdapIdentitySourceDetails)details));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, DirectoryServiceConnectionException.class, InvalidProviderException.class, NotAuthenticatedException.class);
    }

    public void updateActiveDirectory(final String domainName, final IdentitySourceManagement.AuthenticationCredentials authnCredentials, final ExternalDomainSchemaDetails schemaMapping) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException, DomainManagerException, InvalidPrincipalException, DuplicateDomainNameException {
        ValidateUtil.validateNotNull((Object)domainName, (String)"domain name");
        ValidateUtil.validateNotEmpty((Object)domainName, (String)"domain name");
        ValidateUtil.validateNotNull((Object)authnCredentials, (String)"authentication credentials");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, DomainManagerFault, NotAuthenticated, InvalidPrincipalFault, DuplicateDomainNameFault {
                IdentitySourceManagementImpl.this._service.updateActiveDirectory(domainName, SdkVmodlTypeConversions.toVmodl(authnCredentials), VmodlTypeConversions.toVmodl((ExternalDomainSchemaDetails)schemaMapping));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, DomainManagerException.class, NotAuthenticatedException.class, InvalidPrincipalException.class, DuplicateDomainNameException.class);
    }

    public void updateLdapAuthnType(final String name, final LdapIdentitySource.KnownAuthenticationType authnType, final IdentitySourceManagement.AuthenticationCredentials authnCredentials) throws DomainNotFoundException, NotAuthenticatedException, DirectoryServiceConnectionException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"LDAP IdS name");
        ValidateUtil.validateNotNull((Object)authnType, (String)"LDAP Auth. type");
        this.validateAuthTypeAndCredentials(authnType, authnCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, DirectoryServiceConnectionFault, DomainNotFoundFault {
                IdentitySourceManagementImpl.this._service.updateLdapAuthnType(name, authnType.name(), SdkVmodlTypeConversions.toVmodl(authnCredentials));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, DirectoryServiceConnectionException.class, NotAuthenticatedException.class);
    }

    public void delete(final String name) throws DomainNotFoundException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotEmpty((Object)name, (String)"IdS name");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws NotAuthenticated, DomainNotFoundFault {
                IdentitySourceManagementImpl.this._service.delete(name);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, NotAuthenticatedException.class);
    }

    public void setDefaultDomains(final List<String> domainNames) throws DomainNotFoundException, DuplicateDomainNameException, NotAuthenticatedException, NoPermissionException {
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DomainNotFoundFault, DuplicateDomainNameFault, NotAuthenticated {
                String[] arrStr = domainNames == null || domainNames.isEmpty() ? new String[]{} : domainNames.toArray(new String[domainNames.size()]);
                IdentitySourceManagementImpl.this._service.setDefaultDomains(arrStr);
                return null;
            }
        }.executeEnsuringDomainErrorIs(DomainNotFoundException.class, DuplicateDomainNameException.class, NotAuthenticatedException.class);
    }

    public List<String> getDefaultDomains() throws NotAuthenticatedException, NoPermissionException {
        String[] domains = (String[])new VmomiClientCommand<String[]>(){

            @Override
            public String[] actionCommand() throws NotAuthenticated {
                return IdentitySourceManagementImpl.this._service.getDefaultDomains();
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
        return domains != null && domains.length != 0 ? Arrays.asList(domains) : Collections.emptyList();
    }

    public CertificateManagement getSslCertificateManagement() {
        return this._certificateManagement;
    }

    public void probeConnectivity(URI serviceUri, LdapIdentitySource.KnownAuthenticationType authenticationType, IdentitySourceManagement.AuthenticationCredentials authnCredentials) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        this.probeConnectivity(serviceUri, authenticationType, authnCredentials, null);
    }

    public void probeConnectivity(final URI serviceUri, final LdapIdentitySource.KnownAuthenticationType authenticationType, final IdentitySourceManagement.AuthenticationCredentials authnCredentials, final Collection<X509Certificate> certificates) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)serviceUri, (String)"serviceUri");
        this.validateAuthTypeAndCredentials(authenticationType, authnCredentials);
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DirectoryServiceConnectionFault, NotAuthenticated {
                IdentitySourceManagementImpl.this._service.probeConnectivity(serviceUri, authenticationType.name(), SdkVmodlTypeConversions.toVmodl(authnCredentials), VmodlTypeConversions.certificatesToVmodl((Collection)certificates));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DirectoryServiceConnectionException.class, NotAuthenticatedException.class);
    }

    public void probeConnectivity(final String domainName, final IdentitySourceManagement.AuthenticationCredentials authnCredentials, final LdapIdentitySource identitySource) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        ValidateUtil.validateNotNull((Object)identitySource, (String)"identitySource");
        ValidateUtil.validateNotNull((Object)identitySource.getDetails(), (String)"identitySourceDetails");
        ValidateUtil.validateNotNull((Object)authnCredentials, (String)"authnCredentials");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws DirectoryServiceConnectionFault, NotAuthenticated {
                IdentitySourceManagementImpl.this._service.probeLdapConnectivity(domainName, SdkVmodlTypeConversions.toVmodl(authnCredentials), VmodlTypeConversions.toVmodl((LdapIdentitySource)identitySource));
                return null;
            }
        }.executeEnsuringDomainErrorIs(DirectoryServiceConnectionException.class, NotAuthenticatedException.class);
    }

    public CertPath getSslIdentity(final String host, final int ldapsPort) throws DirectoryServiceConnectionException, NotAuthenticatedException, NoPermissionException {
        return (CertPath)new VmomiClientCommand<CertPath>(){

            @Override
            public CertPath actionCommand() throws DomainNotFoundFault, DirectoryServiceConnectionFault, NotAuthenticated {
                return SdkVmodlTypeConversions.fromVmodl(IdentitySourceManagementImpl.this._service.getSslIdentity(host, ldapsPort));
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    private void validateAuthTypeAndCredentials(LdapIdentitySource.KnownAuthenticationType authType, IdentitySourceManagement.AuthenticationCredentials authCredentials) {
        ValidateUtil.validateNotNull((Object)authType, (String)"Authentication type");
        if (authType == LdapIdentitySource.KnownAuthenticationType.password) {
            ValidateUtil.validateNotNull((Object)authCredentials, (String)"Authentication credentials");
        } else if (authCredentials != null) {
            throw new IllegalArgumentException(AUTH_CRED_NULL_ERR_MGS + authType.toString());
        }
    }
}

