/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.LockoutPolicyService;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.admin.LockoutPolicy;
import com.vmware.vim.sso.admin.LockoutPolicyConfigurator;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

final class LockoutPolicyConfiguratorImpl
implements LockoutPolicyConfigurator {
    private final LockoutPolicyService _vmomiService;

    public LockoutPolicyConfiguratorImpl(LockoutPolicyService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public LockoutPolicy getLockoutPolicy() throws SystemException, NotAuthenticatedException {
        return (LockoutPolicy)new VmomiClientCommand<LockoutPolicy>(){

            @Override
            public LockoutPolicy actionCommand() throws ServiceFault, SystemException {
                return VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.LockoutPolicy)LockoutPolicyConfiguratorImpl.this._vmomiService.getLockoutPolicy());
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }

    public void updateLockoutPolicy(final LockoutPolicy policy) throws SystemException, NotAuthenticatedException {
        ValidateUtil.validateNotNull((Object)policy, (String)"Lockout policy");
        new VmomiClientCommand<Void>(){

            @Override
            public Void actionCommand() throws ServiceFault, SystemException {
                LockoutPolicyConfiguratorImpl.this._vmomiService.updateLockoutPolicy(VmodlTypeConversions.toVmodl((LockoutPolicy)policy));
                return null;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

