/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.RoleManagementService;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.admin.RoleManagement;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.InvalidPrincipalException;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.exception.SystemException;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

final class RoleManagementImpl
implements RoleManagement {
    private final RoleManagementService _vmomiService;

    public RoleManagementImpl(RoleManagementService vmomiService) {
        assert (vmomiService != null);
        this._vmomiService = vmomiService;
    }

    public boolean hasAdministratorRole(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.hasAdministratorRole(VmodlTypeConversions.toVmodl((PrincipalId)userId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean hasRegularUserRole(final PrincipalId userId) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.hasRegularUserRole(VmodlTypeConversions.toVmodl((PrincipalId)userId));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean setRole(final PrincipalId userId, final RoleManagement.Role role) throws InvalidPrincipalException, NotAuthenticatedException, SystemException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.setRole(VmodlTypeConversions.toVmodl((PrincipalId)userId), role.name());
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean grantWSTrustRole(final PrincipalId userId, final RoleManagement.WSTrustRole role) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.grantWSTrustRole(VmodlTypeConversions.toVmodl((PrincipalId)userId), VmodlTypeConversions.toVmodl((RoleManagement.WSTrustRole)role));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean revokeWSTrustRole(final PrincipalId userId, final RoleManagement.WSTrustRole role) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.revokeWSTrustRole(VmodlTypeConversions.toVmodl((PrincipalId)userId), VmodlTypeConversions.toVmodl((RoleManagement.WSTrustRole)role));
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean grantIDPProvisioningRole(final PrincipalId userId, final RoleManagement.IDPProvisioningRole role) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.grantIDPProvisioningRole(VmodlTypeConversions.toVmodl((PrincipalId)userId), role.name());
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }

    public boolean revokeIDPProvisioningRole(final PrincipalId userId, final RoleManagement.IDPProvisioningRole role) throws InvalidPrincipalException, NotAuthenticatedException, NoPermissionException {
        return (Boolean)new VmomiClientCommand<Boolean>(){

            @Override
            public Boolean actionCommand() throws ServiceFault, SystemException {
                return RoleManagementImpl.this._vmomiService.revokeIDPProvisioningRole(VmodlTypeConversions.toVmodl((PrincipalId)userId), role.name());
            }
        }.executeEnsuringDomainErrorIs(InvalidPrincipalException.class, NotAuthenticatedException.class);
    }
}

