/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.binding.sso.admin.SsoHealthManagementService;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.sso.admin.SsoHealthManagement;
import com.vmware.vim.sso.admin.SsoHealthStats;
import com.vmware.vim.sso.admin.client.vmomi.impl.VmomiClientCommand;
import com.vmware.vim.sso.admin.exception.NoPermissionException;
import com.vmware.vim.sso.admin.exception.NotAuthenticatedException;
import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import com.vmware.vim.sso.admin.impl.util.VmodlTypeConversions;

public class SsoHealthManagementImpl
implements SsoHealthManagement {
    private final SsoHealthManagementService _service;

    public SsoHealthManagementImpl(SsoHealthManagementService service) {
        ValidateUtil.validateNotNull((Object)service, (String)"service");
        this._service = service;
    }

    public SsoHealthStats getSsoStatistics() throws NotAuthenticatedException, NoPermissionException {
        return (SsoHealthStats)new VmomiClientCommand<SsoHealthStats>(){

            @Override
            public SsoHealthStats actionCommand() throws NotAuthenticated, NoPermission, InvalidCredentials {
                SsoHealthStats stats = null;
                try {
                    stats = VmodlTypeConversions.fromVmodl((com.vmware.vim.binding.sso.admin.SsoHealthStats)SsoHealthManagementImpl.this._service.getSsoStatistics());
                }
                catch (NoPermissionException noPermissionException) {
                    // empty catch block
                }
                return stats;
            }
        }.executeEnsuringDomainErrorIs(NotAuthenticatedException.class);
    }
}

