/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.client.vmomi.impl;

import com.vmware.vim.sso.admin.client.common.SiteAffinityServerEndpointProvider;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vim.vmomi.core.exception.VmodlAlreadyLoadedException;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;

public final class VlsiClientFactory {
    public Client createClient(URI serverUri, Class<?> version) {
        return this.createClient(serverUri, version, true);
    }

    public Client createClient(URI serverUri, Class<?> version, boolean useSiteAffinity) {
        HttpClientConfiguration clientConfig = this.getHttpClientConfig(serverUri, useSiteAffinity);
        serverUri = useSiteAffinity ? null : serverUri;
        return Client.Factory.createClient((URI)serverUri, version, (ClientConfiguration)clientConfig);
    }

    public Client createClient(URI serverUri, Class<?> version, HttpConfiguration httpConfig) {
        return this.createClient(serverUri, version, httpConfig, true);
    }

    public Client createClient(URI serverUri, Class<?> version, HttpConfiguration httpConfig, boolean useSiteAffinity) {
        HttpClientConfiguration clientConfig = this.getHttpClientConfig(serverUri, useSiteAffinity);
        clientConfig.setHttpConfiguration(httpConfig);
        serverUri = useSiteAffinity ? null : serverUri;
        return Client.Factory.createClient((URI)serverUri, version, (ClientConfiguration)clientConfig);
    }

    private HttpClientConfiguration getHttpClientConfig(URI serverUri, boolean useSiteAffinity) {
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        if (useSiteAffinity) {
            SiteAffinityServerEndpointProvider serverEndpointProvider = new SiteAffinityServerEndpointProvider(serverUri);
            clientConfig.setServerEndpointProvider((ServerEndpointProvider)serverEndpointProvider);
        }
        return clientConfig;
    }

    static {
        try {
            VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.sso"});
        }
        catch (VmodlAlreadyLoadedException vmodlAlreadyLoadedException) {
            // empty catch block
        }
    }
}

