/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.vmware.vim.vmomi.core.impl.ThreadLocalRequestContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PropagatingContextDecorator {
    private static final Functions<Void> NO_OP = new Functions<Void>(){

        @Override
        public void beforeExecution(Void t) {
        }

        @Override
        public void afterExecution(Void t) {
        }

        @Override
        public Void copyContext() {
            return null;
        }
    };
    public static final Functions<Map<String, Object>> THREAD_LOCAL_REQUEST_CONTEXT_FUNCTIONS = new Functions<Map<String, Object>>(){

        @Override
        public Map<String, Object> copyContext() {
            return new HashMap<String, Object>((Map<String, Object>)ThreadLocalRequestContext.INSTANCE);
        }

        @Override
        public void beforeExecution(Map<String, Object> t) {
            ThreadLocalRequestContext.INSTANCE.putAll(t);
        }

        @Override
        public void afterExecution(Map<String, Object> t) {
            ThreadLocalRequestContext.INSTANCE.clear();
        }
    };

    public static <C> ExecutorService decorate(ExecutorService executorService, Functions<C> functions) {
        return new ExecutorServiceImpl<C>(executorService, functions);
    }

    public static <C> ScheduledExecutorService decorate(ScheduledExecutorService executorService, Functions<C> functions) {
        return new ScheduledExecutorServiceImpl<C>(executorService, functions);
    }

    private static class DecoratedCallable<T, C>
    implements Callable<T> {
        private final Callable<T> _delegate;
        private final Functions<C> _functions;
        private final C _cachedContext;

        public DecoratedCallable(Callable<T> delegate, Functions<C> functions) {
            this._delegate = delegate;
            this._functions = functions;
            this._cachedContext = this._functions.copyContext();
        }

        @Override
        public T call() throws Exception {
            try {
                this._functions.beforeExecution(this._cachedContext);
                T t = this._delegate.call();
                return t;
            }
            finally {
                this._functions.afterExecution(this._cachedContext);
            }
        }
    }

    private static class ExecutorServiceImpl<C>
    extends AbstractExecutorService {
        private final ExecutorService _executorService;
        private final Functions<C> _functions;

        ExecutorServiceImpl(ExecutorService executorService, Functions<C> functions) {
            this._executorService = executorService;
            if (functions == null) {
                Functions noOp;
                functions = noOp = NO_OP;
            }
            this._functions = functions;
        }

        @Override
        public void shutdown() {
            this._executorService.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this._executorService.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this._executorService.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this._executorService.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this._executorService.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this._executorService.execute(this.decorateRunnable(command));
        }

        protected Runnable decorateRunnable(Runnable command) {
            final DecoratedCallable<Object, C> callable = new DecoratedCallable<Object, C>(Executors.callable(command), this._functions);
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        protected <T> Callable<T> decorateCallable(Callable<T> task) {
            return new DecoratedCallable<T, C>(task, this._functions);
        }
    }

    private static class ScheduledExecutorServiceImpl<C>
    extends ExecutorServiceImpl<C>
    implements ScheduledExecutorService {
        private final ScheduledExecutorService _scheduledExecutorService;

        ScheduledExecutorServiceImpl(ScheduledExecutorService executorService, Functions<C> functions) {
            super(executorService, functions);
            this._scheduledExecutorService = executorService;
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.schedule(Executors.callable(command), delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this._scheduledExecutorService.schedule(this.decorateCallable(callable), delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this._scheduledExecutorService.scheduleAtFixedRate(this.decorateRunnable(command), initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this._scheduledExecutorService.scheduleWithFixedDelay(this.decorateRunnable(command), initialDelay, delay, unit);
        }
    }

    public static interface Functions<T> {
        public T copyContext();

        public void beforeExecution(T var1);

        public void afterExecution(T var1);
    }
}

