/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.vmware.cis.core.Permission;
import com.vmware.cis.core.Principal;
import com.vmware.cis.core.PrivilegeData;
import com.vmware.cis.core.RoleData;
import com.vmware.cis.core.SimplePrincipal;
import com.vmware.cis.core.util.Helper;
import com.vmware.cis.core.util.ImmutableUtils;
import com.vmware.vim.binding.dataservice.accesscontrol.AccessControl;
import com.vmware.vim.binding.dataservice.accesscontrol.Privilege;
import com.vmware.vim.binding.dataservice.accesscontrol.Role;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.AccessControlImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.PrincipalImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.PrivilegeImpl;
import com.vmware.vim.binding.impl.dataservice.accesscontrol.RoleImpl;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TransformerHelper {
    private static final Log _log = LogFactory.getLog(TransformerHelper.class);
    public static ImmutableUtils.TransformMapValueFunc<Role, RoleData> ROLE_TO_ROLEDATA_TRANSFORMER = new ImmutableUtils.TransformMapValueFunc<Role, RoleData>(){

        @Override
        public RoleData to(Object key, Role role) {
            return new RoleData(role.getName(), role.getId(), role.getDescription(), role.getPrivilegeId() == null ? Collections.emptySet() : Helper.getSet(role.getPrivilegeId()), role.getTenant(), role.getVersion());
        }

        @Override
        public Role from(Object key, RoleData role) {
            return new RoleImpl(role.getId(), role.getName(), role.getDesciption(), role.getTenant(), role.getPrivilegeIds().toArray(new String[0]), role.getVersion());
        }
    };
    public static ImmutableUtils.TransformMapValueFunc<Privilege, PrivilegeData> PRIVILEGE_TO_PRIVILEGEDATA_TRANSFORMER = new ImmutableUtils.TransformMapValueFunc<Privilege, PrivilegeData>(){

        @Override
        public PrivilegeData to(Object key, Privilege privilege) {
            return new PrivilegeData(privilege.getId(), privilege.getDescription(), privilege.getGroup(), privilege.getIsOnParent() == null ? false : privilege.getIsOnParent(), privilege.getVersion());
        }

        @Override
        public Privilege from(Object key, PrivilegeData privilege) {
            return new PrivilegeImpl(privilege.getName(), privilege.getDesciption(), privilege.getGroupId(), privilege.getVersion(), Boolean.valueOf(privilege.isOnParent()));
        }
    };
    public static final ImmutableUtils.TransformEntryFunc<String, Collection<Permission>, URI, Collection<AccessControl>> PERMISSION_TO_ACL_TRANFORMER = new ImmutableUtils.TransformEntryFunc<String, Collection<Permission>, URI, Collection<AccessControl>>(){

        @Override
        public Map.Entry<URI, Collection<AccessControl>> to(Object key, Object value) {
            URI transKey = null;
            if (key != null) {
                try {
                    transKey = new URI(TransformerHelper.decode(key.toString()));
                }
                catch (URISyntaxException e) {
                    _log.debug((Object)("Could not convert " + key + " to URI"));
                }
            }
            Collection<AccessControl> transValue = null;
            if (value != null && value instanceof Collection) {
                Collection col = (Collection)value;
                transValue = ImmutableUtils.tranformCollection(col, new ImmutableUtils.TransformFunc<Object, AccessControl>(){

                    @Override
                    public AccessControl apply(Object o) {
                        if (o == null || !(o instanceof Permission)) {
                            return null;
                        }
                        return TransformerHelper.getAccessControl((Permission)o);
                    }
                });
            }
            return new ImmutableUtils.ImmutableMapKey<URI, Object>(transKey, transValue);
        }

        @Override
        public Map.Entry<String, Collection<Permission>> from(Object key, Object value) {
            final String transKey = key != null && key instanceof URI ? TransformerHelper.encode(key.toString()) : null;
            Collection<Permission> transValue = null;
            if (value != null && value instanceof Collection) {
                Collection col = (Collection)value;
                transValue = ImmutableUtils.tranformCollection(col, new ImmutableUtils.TransformFunc<Object, Permission>(){

                    @Override
                    public Permission apply(Object o) {
                        if (o == null || !(o instanceof AccessControl)) {
                            return null;
                        }
                        return TransformerHelper.getPermission(transKey, (AccessControl)o);
                    }
                });
            }
            return new ImmutableUtils.ImmutableMapKey<String, Object>(transKey, transValue);
        }
    };
    public static final ImmutableUtils.TransformEntryFunc<URI, Collection<AccessControl>, String, Collection<Permission>> ACL_TO_PERMISION_TRANFORMER = new ImmutableUtils.TransformEntryFunc<URI, Collection<AccessControl>, String, Collection<Permission>>(){

        @Override
        public Map.Entry<String, Collection<Permission>> to(Object key, Object value) {
            return PERMISSION_TO_ACL_TRANFORMER.from(key, value);
        }

        @Override
        public Map.Entry<URI, Collection<AccessControl>> from(Object key, Object value) {
            return PERMISSION_TO_ACL_TRANFORMER.to(key, value);
        }
    };

    private TransformerHelper() {
        throw new AssertionError();
    }

    public static AccessControl getAccessControl(Permission p) {
        AccessControlImpl permissionImpl = new AccessControlImpl();
        permissionImpl.setPrincipal((com.vmware.vim.binding.dataservice.accesscontrol.Principal)new PrincipalImpl(p.getPrincipal().getName(), p.getPrincipal().isGroup()));
        permissionImpl.setPropagate(p.getPropagate());
        long[] roles = new long[p.getRoleIds().size()];
        int i = 0;
        for (long roleId : p.getRoleIds()) {
            roles[i++] = roleId;
        }
        permissionImpl.setRoles(roles);
        permissionImpl.setVersion(p.getVersion());
        return permissionImpl;
    }

    public static Permission getPermission(String doc, AccessControl p) {
        SimplePrincipal principal = new SimplePrincipal(p.getPrincipal().getName(), p.getPrincipal().isGroup());
        return new Permission(doc, (Principal)principal, p.getRoles(), p.isPropagate(), p.getVersion());
    }

    public static String encode(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decode(String id) {
        if (id == null) {
            return null;
        }
        try {
            return URLDecoder.decode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static final class MergedRolesPermissionFilter
    implements ImmutableUtils.TransformEntryFunc<String, Collection<Permission>, String, Collection<Permission>> {
        private final RoleMergedWithFunction _func;

        public MergedRolesPermissionFilter(RoleMergedWithFunction func) {
            this._func = func;
        }

        @Override
        public Map.Entry<String, Collection<Permission>> to(Object key, Object value) {
            String transKey = null;
            if (key != null) {
                transKey = key.toString();
            }
            Collection<Permission> transValue = null;
            if (value != null && value instanceof Collection) {
                Collection col = (Collection)value;
                transValue = ImmutableUtils.tranformCollection(col, new ImmutableUtils.TransformFunc<Object, Permission>(){

                    @Override
                    public Permission apply(Object o) {
                        if (o == null || !(o instanceof Permission)) {
                            return null;
                        }
                        Permission p = (Permission)o;
                        ArrayList<Long> rIds = new ArrayList<Long>();
                        for (Long rid : p.getRoleIds()) {
                            Long mergedWith = MergedRolesPermissionFilter.this._func.getMergedWith(rid);
                            if (mergedWith != null) {
                                if (_log.isDebugEnabled()) {
                                    _log.debug((Object)("Role " + rid + " is merged with " + mergedWith));
                                }
                                rIds.add(mergedWith);
                                continue;
                            }
                            rIds.add(rid);
                        }
                        return new Permission(p.getObjectId(), p.getPrincipal(), rIds, p.getPropagate(), p.getVersion());
                    }
                });
            }
            return new ImmutableUtils.ImmutableMapKey<String, Object>(transKey, transValue);
        }

        @Override
        public Map.Entry<String, Collection<Permission>> from(Object key, Object value) {
            return this.to(key, value);
        }
    }

    public static interface RoleMergedWithFunction {
        public Long getMergedWith(long var1);
    }
}

