/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ConstantFinder {
    private static final String CONSTANTS_PROP = "JavaString.constants";

    public static String getQuery(String queryName, String callerClsName, String queryFile) {
        String queries;
        int index = callerClsName.lastIndexOf(".");
        String resourceName = "";
        if (index > 0) {
            resourceName = callerClsName.substring(0, index);
            resourceName = resourceName.replace('.', '/');
            resourceName = resourceName + "/" + queryFile;
        } else {
            resourceName = queryFile;
        }
        InputStream in = ConstantFinder.class.getClassLoader().getResourceAsStream(resourceName);
        if (in == null) {
            ConstantFinder.throwException(queryName, resourceName);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        try {
            int len;
            while ((len = in.read(buf)) > 0) {
                bout.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            queries = bout.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding is not supported", e);
        }
        String[] strs = queries.split(String.format("<%s>", queryName));
        if (strs.length < 2) {
            ConstantFinder.throwException(queryName, resourceName);
        }
        return strs[1];
    }

    public static String getQuery(String queryName) {
        Throwable t = new Throwable();
        StackTraceElement methodCaller = t.getStackTrace()[1];
        String callerClsName = methodCaller.getClassName();
        return ConstantFinder.getQuery(queryName, callerClsName, CONSTANTS_PROP);
    }

    private static void throwException(String constantName, String resourceName) {
        throw new IllegalArgumentException("Could not find constant " + constantName + " . Check if the query exists in file with name JavaString.constants exists at " + resourceName);
    }
}

