/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ManyToManyMapper<K1, K2> {
    private final Map<K1, Set<K2>> _map1;
    private final Map<K2, Set<K1>> _map2;
    private final GetNewSet<K1> _getNewSet1;
    private final GetNewSet<K2> _getNewSet2;

    public ManyToManyMapper() {
        this(new GetNewSet<K1>(){

            @Override
            public Set<K1> newSet() {
                return new HashSet();
            }
        }, new GetNewSet<K2>(){

            @Override
            public Set<K2> newSet() {
                return new HashSet();
            }
        });
    }

    public ManyToManyMapper(GetNewSet<K1> newSet1, GetNewSet<K2> newSet2) {
        this(new HashMap(), new HashMap(), newSet1, newSet2);
    }

    public ManyToManyMapper(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, GetNewSet<K1> newSet1, GetNewSet<K2> newSet2) {
        this._map1 = map1;
        this._map2 = map2;
        this._getNewSet1 = newSet1;
        this._getNewSet2 = newSet2;
    }

    public Set<K2> getKey2(K1 key) {
        return ManyToManyMapper.getKey(this, key);
    }

    public Set<K1> getKey1(K2 key) {
        return ManyToManyMapper.getKey(this.getReverseMap(), key);
    }

    public boolean addMapping(K1 key1, K2 key2) {
        ManyToManyMapper.nullCheck(key1, key2);
        return ManyToManyMapper.add(this._map1, this._map2, key1, key2, this._getNewSet1, this._getNewSet2);
    }

    public void retainAllKey2(K1 key1, Collection<K2> key2s) {
        ManyToManyMapper.nullCheck(key1, key2s);
        ManyToManyMapper.retainAllStatic(this._map1, this._map2, key1, key2s, this._getNewSet1, this._getNewSet2);
    }

    public void retainAllKey1(K2 key2, Collection<K1> key1s) {
        ManyToManyMapper.nullCheck(key2, key1s);
        ManyToManyMapper.retainAllStatic(this._map2, this._map1, key2, key1s, this._getNewSet2, this._getNewSet1);
    }

    public boolean removeMapping(K1 key1, K2 key2) {
        return ManyToManyMapper.removeMappingStatic(this._map1, this._map2, key1, key2);
    }

    public void removeKey1(K1 key1) {
        ManyToManyMapper.remove(this._map1, this._map2, key1);
    }

    public void removeKey2(K2 key2) {
        ManyToManyMapper.remove(this._map2, this._map1, key2);
    }

    public void mapAllKey2(K1 key1, Collection<K2> key2s) {
        ManyToManyMapper.nullCheck(key1, key2s);
        ManyToManyMapper.mapAll(this._map1, this._map2, key1, key2s, this._getNewSet1, this._getNewSet2);
    }

    public void mapAllKey1(K2 key2, Collection<K1> key1s) {
        ManyToManyMapper.nullCheck(key2, key1s);
        ManyToManyMapper.mapAll(this._map2, this._map1, key2, key1s, this._getNewSet2, this._getNewSet1);
    }

    public ManyToManyMapper<K2, K1> getReverseMap() {
        return new ManyToManyMapper<K2, K1>(this._map2, this._map1, this._getNewSet2, this._getNewSet1);
    }

    public Set<K1> getAllKey1() {
        return this._map1.keySet();
    }

    public Set<K2> getAllKey2() {
        return this._map2.keySet();
    }

    public void clear() {
        this._map1.clear();
        this._map2.clear();
    }

    public Map<K1, Set<K2>> getMap1() {
        return new MapImpl(this);
    }

    public Map<K2, Set<K1>> getMap2() {
        return new MapImpl<K2, K1>(this.getReverseMap());
    }

    static void nullCheck(Object ... a) {
        for (Object o : a) {
            if (o == null) {
                throw new NullPointerException("Nulls are not allowed in this collection.");
            }
            if (!(o instanceof Collection)) continue;
            for (Object o1 : (Collection)o) {
                if (o1 != null) continue;
                throw new NullPointerException("Nulls are not allowed in this collection.");
            }
        }
    }

    private static <K1, K2> boolean add(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, K1 key1, K2 key2, GetNewSet<K1> newSet1, GetNewSet<K2> newSet2) {
        Set<K2> s2 = ManyToManyMapper.getAndAdd(map1, key1, newSet2);
        Set<K1> s1 = ManyToManyMapper.getAndAdd(map2, key2, newSet1);
        return s2.add(key2) && s1.add(key1);
    }

    private static <K1, K2> Set<K2> getAndAdd(Map<K1, Set<K2>> map1, K1 key1, GetNewSet<K2> newSet) {
        Set<K2> s2 = map1.get(key1);
        if (s2 == null) {
            s2 = newSet.newSet();
            map1.put(key1, s2);
        }
        return s2;
    }

    private static <K1, K2> void remove(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, K1 key1) {
        Set<K2> s2 = map1.remove(key1);
        if (s2 != null) {
            for (K2 key2 : s2) {
                Set<K1> s1 = map2.get(key2);
                if (s1 == null) continue;
                s1.remove(key1);
                if (!s1.isEmpty()) continue;
                map2.remove(key2);
            }
        }
    }

    private static <K1, K2> boolean removeMappingStatic(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, K1 key1, K2 key2) {
        Set<K1> s1;
        Set<K2> s2 = map1.get(key1);
        if (s2 == null) {
            return false;
        }
        s2.remove(key2);
        if (s2.isEmpty()) {
            map1.remove(key1);
        }
        if ((s1 = map2.get(key2)) != null) {
            s1.remove(key1);
            if (s1.isEmpty()) {
                map2.remove(key2);
            }
        }
        return true;
    }

    private static <K1, K2> void retainAllStatic(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, K1 key1, Collection<K2> key2s, GetNewSet<K1> newSet1, GetNewSet<K2> newSet2) {
        Set<K1> s1;
        Set<K2> s2 = ManyToManyMapper.getAndAdd(map1, key1, newSet2);
        Iterator<K2> iter = s2.iterator();
        while (iter.hasNext()) {
            K2 key2 = iter.next();
            if (key2s.contains(key2)) continue;
            iter.remove();
            s1 = map2.get(key2);
            s1.remove(key1);
            if (!s1.isEmpty()) continue;
            map2.remove(key2);
        }
        for (K2 key2 : key2s) {
            if (s2.contains(key2)) continue;
            s2.add(key2);
            s1 = ManyToManyMapper.getAndAdd(map2, key2, newSet1);
            s1.add(key1);
        }
        if (s2.isEmpty()) {
            map1.remove(key1);
        }
    }

    private static <K1, K2> void mapAll(Map<K1, Set<K2>> map1, Map<K2, Set<K1>> map2, K1 key1, Collection<K2> key2s, GetNewSet<K1> newSet1, GetNewSet<K2> newSet2) {
        if (key2s.isEmpty()) {
            return;
        }
        Set<K2> s2 = ManyToManyMapper.getAndAdd(map1, key1, newSet2);
        for (K2 key2 : key2s) {
            if (s2.contains(key2)) continue;
            s2.add(key2);
            Set<K1> s1 = ManyToManyMapper.getAndAdd(map2, key2, newSet1);
            s1.add(key1);
        }
    }

    private static <K1, K2> Set<K2> getKey(ManyToManyMapper<K1, K2> mapper, K1 key) {
        return new SetImpl<K1, K2>(mapper, key);
    }

    private static class SetImpl<K1, K2>
    extends AbstractSet<K2> {
        private final K1 _key;
        private final ManyToManyMapper<K1, K2> _mapper;

        public SetImpl(ManyToManyMapper<K1, K2> mapper, K1 key) {
            this._key = key;
            this._mapper = mapper;
        }

        @Override
        public Iterator<K2> iterator() {
            return new Iterator<K2>(){
                private final Iterator<K2> _delIter;
                private K2 _next;
                {
                    this._delIter = SetImpl.this.getCorrespondingSet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this._delIter.hasNext();
                }

                @Override
                public K2 next() {
                    this._next = this._delIter.next();
                    return this._next;
                }

                @Override
                public void remove() {
                    if (this._next == null) {
                        throw new IllegalStateException();
                    }
                    Set s = (Set)SetImpl.this._mapper._map2.get(this._next);
                    assert (s != null);
                    s.remove(SetImpl.this._key);
                    if (s.isEmpty()) {
                        SetImpl.this._mapper._map2.remove(this._next);
                    }
                    this._delIter.remove();
                    this._next = null;
                }
            };
        }

        @Override
        public void clear() {
            this._mapper.removeKey1(this._key);
        }

        @Override
        public boolean contains(Object o) {
            Set<K2> s = this.getCorrespondingSet();
            return s.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Object key2;
            try {
                Object temp;
                key2 = temp = o;
            }
            catch (ClassCastException e) {
                return false;
            }
            return this._mapper.removeMapping(this._key, key2);
        }

        @Override
        public int size() {
            Set<K2> s = this.getCorrespondingSet();
            return s.size();
        }

        private Set<K2> getCorrespondingSet() {
            Set s = (Set)((ManyToManyMapper)this._mapper)._map1.get(this._key);
            if (s == null) {
                s = Collections.emptySet();
            }
            return s;
        }

        @Override
        public boolean add(K2 e) {
            return this._mapper.addMapping(this._key, e);
        }
    }

    static class MapImpl<K1, K2>
    implements Map<K1, Set<K2>> {
        final ManyToManyMapper<K1, K2> _mapper;
        final Set<Map.Entry<K1, Set<K2>>> _entrySet;
        private final Collection<Set<K2>> _values;
        private final Set<K1> _keySet;

        MapImpl(ManyToManyMapper<K1, K2> mapper) {
            this._mapper = mapper;
            this._entrySet = new EntrySet();
            this._values = new AbstractCollection<Set<K2>>(){

                @Override
                public Iterator<Set<K2>> iterator() {
                    return new Iterator<Set<K2>>(){
                        private Iterator<Map.Entry<K1, Set<K2>>> i;
                        {
                            this.i = MapImpl.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<K2> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public void clear() {
                    MapImpl.this.clear();
                }

                @Override
                public int size() {
                    return MapImpl.this.entrySet().size();
                }
            };
            this._keySet = new AbstractSet<K1>(){

                @Override
                public Iterator<K1> iterator() {
                    return new Iterator<K1>(){
                        private Iterator<Map.Entry<K1, Set<K2>>> i;
                        {
                            this.i = MapImpl.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K1 next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return MapImpl.this.entrySet().size();
                }

                @Override
                public boolean remove(Object o) {
                    Object temp = MapImpl.this.remove(o);
                    return temp != null;
                }

                @Override
                public boolean contains(Object o) {
                    Object candidate = MapImpl.this.get(o);
                    return !candidate.isEmpty();
                }

                @Override
                public void clear() {
                    MapImpl.this.clear();
                }
            };
        }

        @Override
        public Set<Map.Entry<K1, Set<K2>>> entrySet() {
            return this._entrySet;
        }

        @Override
        public int size() {
            return ((ManyToManyMapper)this._mapper)._map1.size();
        }

        @Override
        public boolean isEmpty() {
            return ((ManyToManyMapper)this._mapper)._map1.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return ((ManyToManyMapper)this._mapper)._map1.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return ((ManyToManyMapper)this._mapper)._map1.containsValue(value);
        }

        @Override
        public Set<K2> get(Object o) {
            Object key = o;
            return new SetImpl<Object, K2>(this._mapper, key);
        }

        @Override
        public Set<K2> put(K1 key, Set<K2> value) {
            Set oldValue = ((ManyToManyMapper)this._mapper)._getNewSet2.newSet();
            Set c = (Set)((ManyToManyMapper)this._mapper)._map1.get(key);
            if (c != null) {
                oldValue.addAll(c);
            }
            this._mapper.retainAllKey2(key, value);
            return oldValue;
        }

        @Override
        public Set<K2> remove(Object key) {
            Object key1;
            try {
                Object key2;
                key1 = key2 = key;
            }
            catch (ClassCastException e) {
                return null;
            }
            Set<K2> oldValue = ((ManyToManyMapper)this._mapper)._getNewSet2.newSet();
            oldValue.addAll(this._mapper.getKey2(key1));
            this._mapper.removeKey1(key1);
            return oldValue.isEmpty() ? null : oldValue;
        }

        @Override
        public void putAll(Map<? extends K1, ? extends Set<K2>> m) {
            for (Map.Entry<K1, Set<K2>> entry : m.entrySet()) {
                this._mapper.mapAllKey2(entry.getKey(), (Collection)entry.getValue());
            }
        }

        @Override
        public void clear() {
            this._mapper.clear();
        }

        @Override
        public Set<K1> keySet() {
            return this._keySet;
        }

        @Override
        public Collection<Set<K2>> values() {
            return this._values;
        }

        private class MapEntryImpl
        implements Map.Entry<K1, Set<K2>> {
            private final Map.Entry<K1, Set<K2>> e;

            MapEntryImpl(Map.Entry<K1, Set<K2>> e) {
                this.e = e;
            }

            @Override
            public K1 getKey() {
                return this.e.getKey();
            }

            @Override
            public Set<K2> getValue() {
                return new SetImpl(MapImpl.this._mapper, this.e.getKey());
            }

            @Override
            public Set<K2> setValue(Set<K2> value1) {
                return MapImpl.this.put(this.e.getKey(), value1);
            }
        }

        class EntrySet
        extends AbstractSet<Map.Entry<K1, Set<K2>>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K1, Set<K2>>> iterator() {
                return new Iterator<Map.Entry<K1, Set<K2>>>(){
                    private final Iterator<Map.Entry<K1, Set<K2>>> _entrySetIter;
                    private Map.Entry<K1, Set<K2>> _next;
                    {
                        this._entrySetIter = MapImpl.this._mapper._map1.entrySet().iterator();
                        this._next = null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this._entrySetIter.hasNext();
                    }

                    @Override
                    public Map.Entry<K1, Set<K2>> next() {
                        this._next = new MapEntryImpl(this._entrySetIter.next());
                        return this._next;
                    }

                    @Override
                    public void remove() {
                        if (this._next == null) {
                            throw new IllegalStateException();
                        }
                        for (Object key2 : this._next.getValue()) {
                            Set set = (Set)MapImpl.this._mapper._map2.get(key2);
                            set.remove(this._next.getKey());
                            if (!set.isEmpty()) continue;
                            MapImpl.this._mapper._map2.remove(key2);
                        }
                        this._entrySetIter.remove();
                        this._next = null;
                    }
                };
            }

            @Override
            public void clear() {
                MapImpl.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object candidate = MapImpl.this.get(e.getKey());
                return candidate != null && candidate.equals(e.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object temp = MapImpl.this.remove(e.getKey());
                return temp != null && !temp.isEmpty();
            }

            @Override
            public int size() {
                return MapImpl.this._mapper._map1.size();
            }
        }
    }

    public static interface GetNewSet<E> {
        public Set<E> newSet();
    }
}

