/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmomiUtil {
    private static final Log _log = LogFactory.getLog(VmomiUtil.class);

    public static String createURI(ManagedObjectReference moRef) {
        if (moRef.getServerGuid() == null) {
            String errMsg = String.format("Server Guid for given managed object - urn:vmomi:%s:%s is null : ", moRef.getType(), moRef.getValue());
            if (_log.isErrorEnabled()) {
                _log.error((Object)errMsg);
            }
            throw new IllegalArgumentException(errMsg);
        }
        return String.format("urn:vmomi:%s:%s:%s", moRef.getType(), moRef.getValue(), moRef.getServerGuid());
    }

    public static URI createDirectURI(ManagedObjectReference moRef) {
        try {
            return new URI(VmomiUtil.createURI(moRef));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void moRefUriSanityCheck(String[] fields) {
        if (fields.length != 5 && fields.length != 4 || !fields[0].equals("urn") || !fields[1].equals("vmomi")) {
            throw new IllegalStateException("Invalid managed object reference");
        }
    }

    public static ManagedObjectReference createMoRef(String uri) {
        String[] fields = uri.split(":");
        VmomiUtil.moRefUriSanityCheck(fields);
        ManagedObjectReference moRef = new ManagedObjectReference(fields[2], fields[3], fields[4]);
        return moRef;
    }

    public static String constructMoRefUri(String type, String val, String serverGuid) {
        return "urn:vmomi:" + type + ":" + val + ":" + serverGuid;
    }

    public static boolean isVapiId(String uri) {
        return uri.startsWith("urn:vapi:");
    }

    public static boolean isValidMoRef(String uri) {
        String[] fields = uri.split(":");
        try {
            VmomiUtil.moRefUriSanityCheck(fields);
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }
}

