/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.customfield;

import com.google.common.base.Predicate;
import com.vmware.cis.data.internal.adapters.customfield.CustomFieldRepository;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class VimCustomFieldsManagerRepository
implements CustomFieldRepository {
    private static final Logger _logger = LoggerFactory.getLogger(VimCustomFieldsManagerRepository.class);
    private final Client _vlsiClient;

    VimCustomFieldsManagerRepository(Client vlsiClient) {
        Validate.notNull((Object)vlsiClient, (String)"VLSI client");
        this._vlsiClient = vlsiClient;
    }

    @Override
    public Collection<ManagedObjectReference> getEntities(Collection<String> names, String value, boolean exactMatch) {
        Validate.notNull(names);
        Validate.noNullElements(names);
        CustomFieldsManager stub = this.createCustomFieldsManagerStub();
        LinkedHashSet<ManagedObjectReference> entities = new LinkedHashSet<ManagedObjectReference>();
        for (String fieldName : names) {
            entities.addAll(VimCustomFieldsManagerRepository.getEntities(stub, fieldName, value, exactMatch));
        }
        return entities;
    }

    @Override
    public Collection<ManagedObjectReference> filterEntities(Collection<ManagedObjectReference> entities, Predicate<String> namePredicate, Predicate<String> valuePredicate) {
        Validate.notNull(entities, (String)"entities");
        Validate.notNull(entities, (String)"name predicate");
        Validate.notNull(entities, (String)"value predicate");
        _logger.trace("Filtering entities by custom field value using {} and custom field value using {}: {}", new Object[]{namePredicate, valuePredicate, entities});
        if (entities.isEmpty()) {
            return entities;
        }
        Map<Integer, String> fieldNameByKey = this.getCustomFieldNameByKey(namePredicate);
        ArrayList<ManagedObjectReference> filteredEntities = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference entityRef : entities) {
            if (!this.acceptEntity(entityRef, namePredicate, valuePredicate, fieldNameByKey)) continue;
            filteredEntities.add(entityRef);
        }
        return filteredEntities;
    }

    @Override
    public Collection<String> getCustomFieldNames() {
        CustomFieldsManager stub = this.createCustomFieldsManagerStub();
        CustomFieldsManager.FieldDef[] fields = stub.getField();
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(fields.length);
        for (CustomFieldsManager.FieldDef fieldDef : fields) {
            names.add(fieldDef.getName());
        }
        _logger.trace("Custom field names: {}", names);
        return names;
    }

    public String toString() {
        return this._vlsiClient.getBinding().getEndpointUri().toString();
    }

    private static Collection<ManagedObjectReference> getEntities(CustomFieldsManager stub, String name, String value, boolean exactMatch) {
        assert (stub != null);
        assert (name != null);
        if (_logger.isTraceEnabled()) {
            _logger.trace("CustomFieldsManager.getEntitiesWithCustomFieldAndValue({}, {}, {}) about to be invoked", new Object[]{name, value, exactMatch});
        }
        Object[] refs = stub.getEntitiesWithCustomFieldAndValue(name, value, Boolean.valueOf(exactMatch));
        if (_logger.isTraceEnabled()) {
            _logger.trace("CustomFieldsManager.getEntitiesWithCustomFieldAndValue({}, {}, {}) returned {}", new Object[]{name, value, exactMatch, Arrays.toString(refs)});
        }
        if (refs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(refs);
    }

    private Map<Integer, String> getCustomFieldNameByKey(Predicate<String> namePredicate) {
        assert (namePredicate != null);
        CustomFieldsManager stub = this.createCustomFieldsManagerStub();
        Object[] fields = stub.getField();
        if (_logger.isTraceEnabled()) {
            _logger.trace("Filtering field definitions using {}: {}", namePredicate, (Object)Arrays.toString(fields));
        }
        if (fields == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Integer, String> fieldNameByKey = new LinkedHashMap<Integer, String>(fields.length);
        for (Object fieldDef : fields) {
            assert (fieldDef.getName() != null);
            if (!namePredicate.apply((Object)fieldDef.getName())) continue;
            String old = fieldNameByKey.put(fieldDef.getKey(), fieldDef.getName());
            assert (old == null);
        }
        _logger.trace("Filtered field definitions as Map<FieldKey, FieldName>: {}", fieldNameByKey);
        return fieldNameByKey;
    }

    private boolean acceptEntity(ManagedObjectReference entityRef, Predicate<String> namePredicate, Predicate<String> valuePredicate, Map<Integer, String> fieldNameByKey) {
        assert (entityRef != null);
        assert (namePredicate != null);
        assert (valuePredicate != null);
        assert (fieldNameByKey != null);
        ManagedObject managedObject = this.createStub(ManagedObject.class, entityRef);
        if (!(managedObject instanceof ManagedEntity)) {
            _logger.trace("Skip object which is not a managed entity: {}", (Object)entityRef);
            return false;
        }
        ManagedEntity managedEntity = this.createStub(ManagedEntity.class, entityRef);
        Object[] customValues = managedEntity.getCustomValue();
        if (customValues == null) {
            _logger.trace("Skip entity with no custom values: {}", (Object)entityRef);
            return false;
        }
        for (CustomFieldsManager.Value value : customValues) {
            if (!VimCustomFieldsManagerRepository.acceptCustomValue(value, namePredicate, valuePredicate, fieldNameByKey)) continue;
            _logger.trace("Accept entity {} with custom values {}", (Object)entityRef, (Object)Arrays.toString(customValues));
            return true;
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace("Skip entity '{}' with custom values: {}", (Object)entityRef, (Object)Arrays.toString(customValues));
        }
        return false;
    }

    private static boolean acceptCustomValue(CustomFieldsManager.Value customValue, Predicate<String> namePredicate, Predicate<String> valuePredicate, Map<Integer, String> fieldNameByKey) {
        assert (namePredicate != null);
        assert (valuePredicate != null);
        assert (fieldNameByKey != null);
        if (!(customValue instanceof CustomFieldsManager.StringValue)) {
            return false;
        }
        CustomFieldsManager.StringValue customStringValue = (CustomFieldsManager.StringValue)customValue;
        String value = customStringValue.getValue();
        String fieldName = fieldNameByKey.get(customStringValue.getKey());
        return fieldName != null && value != null && namePredicate.apply((Object)fieldName) && valuePredicate.apply((Object)value);
    }

    private CustomFieldsManager createCustomFieldsManagerStub() {
        ManagedObjectReference ref = new ManagedObjectReference("CustomFieldsManager", "CustomFieldsManager", null);
        return this.createStub(CustomFieldsManager.class, ref);
    }

    private <T extends ManagedObject> T createStub(Class<T> stubBindingClass, ManagedObjectReference ref) {
        assert (stubBindingClass != null);
        assert (ref != null);
        T stub = VlsiClientUtil.createStub(this._vlsiClient, stubBindingClass, ref);
        VimCustomFieldsManagerRepository.setOpId(stub);
        return stub;
    }

    private static void setOpId(ManagedObject mo) {
        assert (mo != null);
        String opId = QueryMarker.getQueryId();
        if (opId == null) {
            return;
        }
        VimCustomFieldsManagerRepository.getRequestContext(mo).put((Object)"operationID", (Object)opId);
    }

    private static RequestContextImpl getRequestContext(ManagedObject mo) {
        assert (mo != null);
        Stub stub = (Stub)mo;
        RequestContextImpl rc = (RequestContextImpl)stub._getRequestContext();
        if (rc == null) {
            rc = new RequestContextImpl();
            stub._setRequestContext((RequestContext)rc);
        }
        return rc;
    }
}

