/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractForeignKeyRouter
implements QueryRouter {
    @Override
    public final Query route(Query query, String targetInstanceId) {
        if (query.getFilter() == null) {
            return query;
        }
        Filter filter = query.getFilter();
        ArrayList<PropertyPredicate> processedPredicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        block3: for (PropertyPredicate predicate : filter.getCriteria()) {
            switch (predicate.getOperator()) {
                case EQUAL: 
                case IN: {
                    List<Object> keysForTargetInstance = this.tryExtractForeignKeysForInstanceId(predicate, targetInstanceId);
                    if (keysForTargetInstance == null) {
                        processedPredicates.add(predicate);
                        continue block3;
                    }
                    if (!keysForTargetInstance.isEmpty()) {
                        processedPredicates.add(AbstractForeignKeyRouter.toEqualityPredicate(predicate.getProperty(), keysForTargetInstance));
                        continue block3;
                    }
                    if (filter.getOperator() != LogicalOperator.AND) continue block3;
                    return null;
                }
            }
            processedPredicates.add(predicate);
        }
        if (processedPredicates.isEmpty() && filter.getOperator() == LogicalOperator.OR) {
            return null;
        }
        return RouterUtils.replaceCriteria(query, processedPredicates);
    }

    protected abstract List<Object> tryExtractForeignKeysForInstanceId(PropertyPredicate var1, String var2);

    private static PropertyPredicate toEqualityPredicate(String property, List<Object> values) {
        Object comparableValue;
        PropertyPredicate.ComparisonOperator operator;
        assert (!values.isEmpty());
        if (values.size() == 1) {
            operator = PropertyPredicate.ComparisonOperator.EQUAL;
            comparableValue = values.iterator().next();
        } else {
            operator = PropertyPredicate.ComparisonOperator.IN;
            comparableValue = values;
        }
        return new PropertyPredicate(property, operator, comparableValue);
    }
}

