/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.federation;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.util.UnqualifiedProperty;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class FederationQuerySchemaLookup {
    private final Map<String, QuerySchema> _schemaBynodeId;

    public FederationQuerySchemaLookup(Map<String, QuerySchema> schemaBynodeId) {
        this._schemaBynodeId = schemaBynodeId;
    }

    public boolean isSelectableAnywhere(String model, String property) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        for (QuerySchema schema : this._schemaBynodeId.values()) {
            if (!FederationQuerySchemaLookup.isSelectable(schema, model, property)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectable(String model, String property, String nodeId) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        assert (!StringUtils.isEmpty((String)nodeId));
        QuerySchema schema = this._schemaBynodeId.get(nodeId);
        if (schema == null) {
            return false;
        }
        return FederationQuerySchemaLookup.isSelectable(schema, model, property);
    }

    public boolean isFilterableAnywhere(String model, String property) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        for (QuerySchema schema : this._schemaBynodeId.values()) {
            if (!FederationQuerySchemaLookup.isFilterable(schema, model, property)) continue;
            return true;
        }
        return false;
    }

    public boolean isFilterableByUnsetAnywhere(String model, String property) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        for (QuerySchema schema : this._schemaBynodeId.values()) {
            if (!FederationQuerySchemaLookup.isFilterableByUnset(schema, model, property)) continue;
            return true;
        }
        return false;
    }

    public boolean isFilterable(String model, String property, String nodeId) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        assert (!StringUtils.isEmpty((String)nodeId));
        QuerySchema schema = this._schemaBynodeId.get(nodeId);
        if (schema == null) {
            return false;
        }
        return FederationQuerySchemaLookup.isFilterable(schema, model, property);
    }

    public boolean isFilterableByUnset(String model, String property, String nodeId) {
        assert (!StringUtils.isEmpty((String)model));
        assert (!StringUtils.isEmpty((String)property));
        assert (!StringUtils.isEmpty((String)nodeId));
        QuerySchema schema = this._schemaBynodeId.get(nodeId);
        if (schema == null) {
            return false;
        }
        return FederationQuerySchemaLookup.isFilterableByUnset(schema, model, property);
    }

    public boolean isSortableAnywhere(String model, String property) {
        return this.isFilterableAnywhere(model, property);
    }

    public boolean isSortable(String model, String property, String nodeId) {
        return this.isFilterable(model, property, nodeId);
    }

    public boolean isModelSupported(String model, String nodeId) {
        QuerySchema schema = this._schemaBynodeId.get(nodeId);
        if (schema == null) {
            return false;
        }
        return schema.getModels().containsKey(model);
    }

    private static boolean isSelectable(QuerySchema schema, String model, String property) {
        QuerySchema.ModelInfo modelInfo = (QuerySchema.ModelInfo)schema.getModels().get(model);
        if (modelInfo == null) {
            return false;
        }
        String rootproperty = UnqualifiedProperty.getRootProperty((String)property);
        return modelInfo.getProperties().containsKey(rootproperty);
    }

    private static boolean isFilterable(QuerySchema schema, String model, String property) {
        QuerySchema.ModelInfo modelInfo = (QuerySchema.ModelInfo)schema.getModels().get(model);
        if (modelInfo == null) {
            return false;
        }
        QuerySchema.PropertyInfo propertyInfo = (QuerySchema.PropertyInfo)modelInfo.getProperties().get(property);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.getFilterable();
    }

    private static boolean isFilterableByUnset(QuerySchema schema, String model, String property) {
        QuerySchema.ModelInfo modelInfo = (QuerySchema.ModelInfo)schema.getModels().get(model);
        if (modelInfo == null) {
            return false;
        }
        QuerySchema.PropertyInfo propertyInfo = (QuerySchema.PropertyInfo)modelInfo.getProperties().get(property);
        if (propertyInfo == null) {
            return false;
        }
        return propertyInfo.getFilterable() || propertyInfo.getFilterableByUnset();
    }
}

