/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.property;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.property.BackCompatPropertyProvider;
import com.vmware.cis.data.internal.adapters.property.BackCompatPropertyProviderRepository;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import com.vmware.cis.data.internal.provider.join.RelationalAlgebra;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.internal.util.TaskExecutor;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vim.vmomi.client.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

final class BackCompatPropertyProviderConnection
implements DataProvider {
    private final DataProvider _provider;
    private final QuerySchema _schema;
    private final Client _vlsiClient;
    private final TaskExecutor _taskExecutor;
    private final BackCompatPropertyProviderRepository _propertyProviderRepository;

    BackCompatPropertyProviderConnection(DataProvider provider, BackCompatPropertyProviderRepository propertyProviderRepository, Client vlsiClient, ExecutorService executor) {
        assert (provider != null);
        assert (executor != null);
        assert (vlsiClient != null);
        assert (propertyProviderRepository != null);
        this._provider = provider;
        this._schema = provider.getSchema();
        this._vlsiClient = vlsiClient;
        this._taskExecutor = new TaskExecutor(executor, TaskExecutor.ErrorHandlingPolicy.STRICT);
        this._propertyProviderRepository = propertyProviderRepository;
    }

    public ResultSet executeQuery(Query query) {
        if (this.skip(query)) {
            return this._provider.executeQuery(query);
        }
        ArrayList<String> remainingProperties = new ArrayList<String>();
        Query rawQuery = QueryCopy.copyAndSelect((Query)query, this.adaptSelect(query.getProperties(), remainingProperties)).build();
        ResultSet rawResult = this._provider.executeQuery(rawQuery);
        if (rawResult.getItems().isEmpty()) {
            return rawResult;
        }
        List keys = ResultSetAnalyzer.gatherModelKeysOrdered((ResultSet)rawResult);
        List<ResultSet> propertyProviderResults = this.execPropertyProviders(remainingProperties, keys);
        ArrayList<ResultSet> resultsToJoin = new ArrayList<ResultSet>(propertyProviderResults);
        resultsToJoin.add(rawResult);
        ResultSet mergedResults = RelationalAlgebra.joinSelectAndProject(resultsToJoin, (Collection)keys, (List)query.getProperties());
        return ResultSet.Builder.copy((ResultSet)mergedResults).totalCount(rawResult.getTotalCount()).build();
    }

    public QuerySchema getSchema() {
        QuerySchema propertyProviderSchema = this.getPropertyProviderSchema();
        QuerySchema baseSchema = this._provider.getSchema();
        return SchemaUtil.merge((QuerySchema)propertyProviderSchema, (QuerySchema)baseSchema);
    }

    public String toString() {
        return this._provider.toString();
    }

    private QuerySchema getPropertyProviderSchema() {
        LinkedHashMap<String, QuerySchema.PropertyInfo> infosByProperty = new LinkedHashMap<String, QuerySchema.PropertyInfo>();
        for (String property : this._propertyProviderRepository.getProperties()) {
            infosByProperty.put(property, QuerySchema.PropertyInfo.forNonFilterableProperty());
        }
        return QuerySchema.forProperties(infosByProperty);
    }

    private boolean skip(Query query) {
        assert (query != null);
        for (String property : query.getProperties()) {
            if (!this.isFromPropertyProvider(property)) continue;
            return false;
        }
        return true;
    }

    private List<String> adaptSelect(List<String> properties, List<String> remainingProperties) {
        assert (properties != null);
        assert (!properties.isEmpty());
        ArrayList<String> executableSelect = new ArrayList<String>(properties.size());
        for (String property : properties) {
            if (this.isFromPropertyProvider(property)) {
                remainingProperties.add(property);
                continue;
            }
            executableSelect.add(property);
        }
        return executableSelect;
    }

    private boolean isFromPropertyProvider(String property) {
        assert (property != null);
        return this._propertyProviderRepository.getProperties().contains(property) && SchemaUtil.getPropertyInfoForQualifiedName((QuerySchema)this._schema, (String)property) == null;
    }

    private List<ResultSet> execPropertyProviders(List<String> properties, final List<Object> keys) {
        Map<BackCompatPropertyProvider, List<String>> propertiesByProvider = this._propertyProviderRepository.getPropertiesByProvider(properties);
        ArrayList<1> tasks = new ArrayList<1>(properties.size());
        for (final BackCompatPropertyProvider propertyProvider : propertiesByProvider.keySet()) {
            final List<String> providerProperties = propertiesByProvider.get(propertyProvider);
            tasks.add(new Callable<ResultSet>(){

                @Override
                public ResultSet call() throws Exception {
                    List<Collection<?>> columns = propertyProvider.fetchPropertyValues(providerProperties, keys, BackCompatPropertyProviderConnection.this._provider, BackCompatPropertyProviderConnection.this._vlsiClient);
                    return ResultSetUtil.toResult((Collection)keys, (List)providerProperties, columns);
                }

                public String toString() {
                    return "execute property provider for " + providerProperties;
                }
            });
        }
        List results = this._taskExecutor.invokeTasks(tasks);
        assert (!results.isEmpty());
        return results;
    }
}

