/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.tagging;

import com.vmware.cis.data.internal.adapters.tagging.LenientTaggingFacade;
import com.vmware.cis.tagging.BatchTypes;
import com.vmware.cis.tagging.CategoryModel;
import com.vmware.cis.tagging.TagModel;
import com.vmware.vapi.std.DynamicID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TaggingFacadeCache
implements LenientTaggingFacade {
    private static final TagModel NO_SUCH_TAG = new TagModel();
    private static final CategoryModel NO_SUCH_CATEGORY = new CategoryModel();
    private final LenientTaggingFacade _tagging;
    private final Map<String, TagModel> _cachedTagById;
    private List<TagModel> _cachedAllTags;
    private final Map<String, CategoryModel> _cachedCategoryById;
    private List<CategoryModel> _cachedAllCategories;

    TaggingFacadeCache(LenientTaggingFacade tagging) {
        assert (tagging != null);
        this._tagging = tagging;
        this._cachedTagById = new HashMap<String, TagModel>();
        this._cachedAllTags = null;
        this._cachedCategoryById = new HashMap<String, CategoryModel>();
        this._cachedAllCategories = null;
    }

    @Override
    public List<String> listTags() {
        return this._tagging.listTags();
    }

    @Override
    public TagModel getTag(String tagId) {
        assert (tagId != null);
        TagModel cached = this._cachedTagById.get(tagId);
        if (cached == NO_SUCH_TAG) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        TagModel tagModel = this._tagging.getTag(tagId);
        if (tagModel == null) {
            this._cachedTagById.put(tagId, NO_SUCH_TAG);
        } else {
            this._cachedTagById.put(tagId, tagModel);
        }
        return tagModel;
    }

    @Override
    public List<TagModel> getAllTags() {
        if (this._cachedAllTags != null) {
            return this._cachedAllTags;
        }
        this._cachedAllTags = this._tagging.getAllTags();
        for (TagModel tagModel : this._cachedAllTags) {
            this._cachedTagById.put(tagModel.getId(), tagModel);
        }
        return this._cachedAllTags;
    }

    @Override
    public List<TagModel> getTags(List<String> tagIds) {
        ArrayList<String> noncachedIds = new ArrayList<String>(tagIds.size());
        HashMap<String, TagModel> modelById = new HashMap<String, TagModel>(tagIds.size());
        for (String tagId : tagIds) {
            TagModel cached = this._cachedTagById.get(tagId);
            if (cached == null) {
                noncachedIds.add(tagId);
                continue;
            }
            if (cached == NO_SUCH_TAG) continue;
            modelById.put(tagId, cached);
        }
        if (!noncachedIds.isEmpty()) {
            List<TagModel> noncachedModels = this._tagging.getTags(noncachedIds);
            for (TagModel model : noncachedModels) {
                modelById.put(model.getId(), model);
                this._cachedTagById.put(model.getId(), model);
            }
        }
        ArrayList<TagModel> models = new ArrayList<TagModel>(tagIds.size());
        for (String tagId : tagIds) {
            TagModel model = (TagModel)modelById.get(tagId);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    @Override
    public List<String> findTagsByName(String tagNamePattern) {
        return this._tagging.findTagsByName(tagNamePattern);
    }

    @Override
    public List<String> listCategories() {
        return this._tagging.listCategories();
    }

    @Override
    public CategoryModel getCategory(String categoryId) {
        assert (categoryId != null);
        CategoryModel cached = this._cachedCategoryById.get(categoryId);
        if (cached == NO_SUCH_CATEGORY) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        CategoryModel categoryModel = this._tagging.getCategory(categoryId);
        if (categoryModel == null) {
            this._cachedCategoryById.put(categoryId, NO_SUCH_CATEGORY);
        } else {
            this._cachedCategoryById.put(categoryId, categoryModel);
        }
        return categoryModel;
    }

    @Override
    public List<CategoryModel> getAllCategories() {
        if (this._cachedAllCategories != null) {
            return this._cachedAllCategories;
        }
        this._cachedAllCategories = this._tagging.getAllCategories();
        for (CategoryModel categoryModel : this._cachedAllCategories) {
            this._cachedCategoryById.put(categoryModel.getId(), categoryModel);
        }
        return this._cachedAllCategories;
    }

    @Override
    public List<CategoryModel> getCategories(List<String> categoryIds) {
        assert (categoryIds != null);
        ArrayList<String> noncachedIds = new ArrayList<String>(categoryIds.size());
        HashMap<String, CategoryModel> modelById = new HashMap<String, CategoryModel>(categoryIds.size());
        for (String categoryId : categoryIds) {
            CategoryModel model = this._cachedCategoryById.get(categoryId);
            if (model == null) {
                noncachedIds.add(categoryId);
                continue;
            }
            if (model == NO_SUCH_CATEGORY) continue;
            modelById.put(categoryId, model);
        }
        if (!noncachedIds.isEmpty()) {
            List<CategoryModel> noncachedModels = this._tagging.getCategories(noncachedIds);
            for (CategoryModel model : noncachedModels) {
                modelById.put(model.getId(), model);
                this._cachedCategoryById.put(model.getId(), model);
            }
        }
        ArrayList<CategoryModel> models = new ArrayList<CategoryModel>(categoryIds.size());
        for (String tagId : categoryIds) {
            CategoryModel model = (CategoryModel)modelById.get(tagId);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    @Override
    public List<String> listTagsForCategory(String categoryId) {
        assert (categoryId != null);
        return this._tagging.listTagsForCategory(categoryId);
    }

    @Override
    public List<String> listAttachedTags(List<DynamicID> objectIds) {
        assert (objectIds != null);
        return this._tagging.listAttachedTags(objectIds);
    }

    @Override
    public List<DynamicID> listAttachedObjects(List<String> tagIds) {
        assert (tagIds != null);
        return this._tagging.listAttachedObjects(tagIds);
    }

    @Override
    public List<BatchTypes.TagToObjects> listAllAttachedObjectsOnTags() {
        return this._tagging.listAllAttachedObjectsOnTags();
    }

    @Override
    public List<BatchTypes.TagToObjects> listAttachedObjectsOnTags(List<String> tagIds) {
        assert (tagIds != null);
        return this._tagging.listAttachedObjectsOnTags(tagIds);
    }

    @Override
    public List<BatchTypes.ObjectToTags> listAttachedTagsOnObjects(List<DynamicID> objectIds) {
        assert (objectIds != null);
        return this._tagging.listAttachedTagsOnObjects(objectIds);
    }
}

