/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSessionSource;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenewableVapiSession
implements VapiSession {
    private static Logger _logger = LoggerFactory.getLogger(RenewableVapiSession.class);
    private final VapiSessionSource _authenticator;
    private final AtomicReference<Future<char[]>> _sessionIdFuture;

    public RenewableVapiSession(VapiSessionSource authenticator) {
        assert (authenticator != null);
        this._authenticator = authenticator;
        this._sessionIdFuture = new AtomicReference<Future<char[]>>(authenticator.createSession());
    }

    @Override
    public char[] get() {
        Future<char[]> future = this._sessionIdFuture.get();
        this.validateIsOpen(future);
        return RenewableVapiSession.getSessionId(future);
    }

    @Override
    public char[] renew(char[] expired) {
        assert (expired != null);
        Future<char[]> currentFuture = this._sessionIdFuture.get();
        this.validateIsOpen(currentFuture);
        char[] current = RenewableVapiSession.getSessionId(this._sessionIdFuture);
        if (current != expired) {
            return current;
        }
        Future<char[]> freshFuture = this._authenticator.createSession();
        char[] fresh = RenewableVapiSession.getSessionId(freshFuture);
        boolean changed = this._sessionIdFuture.compareAndSet(currentFuture, freshFuture);
        if (changed) {
            _logger.debug("Renewed session from {}", (Object)this._authenticator);
            return fresh;
        }
        _logger.debug("Destroying redundant new session from {} because somebody renewed the session before us", (Object)this._authenticator);
        this.silentLogout(fresh);
        return this.get();
    }

    @Override
    public void logout() {
        Future session = this._sessionIdFuture.getAndSet(null);
        if (session == null) {
            return;
        }
        this.silentLogout(RenewableVapiSession.getSessionId(session));
    }

    private static char[] getSessionId(AtomicReference<Future<char[]>> sessionIdRef) {
        return RenewableVapiSession.getSessionId(sessionIdRef.get());
    }

    private static char[] getSessionId(Future<char[]> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }

    private void silentLogout(char[] session) {
        try {
            this._authenticator.deleteSession(session);
        }
        catch (RuntimeException ex) {
            _logger.debug("Error while logging out session", (Throwable)ex);
        }
    }

    private void validateIsOpen(Future<char[]> future) {
        if (future == null) {
            throw new IllegalStateException("Session is closed");
        }
    }
}

