/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.util.vapi;

import com.vmware.cis.data.internal.adapters.util.vapi.VapiInvocationSecurity;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiSession;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ErrorValue;
import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionAwareApiProvider
implements ApiProvider {
    private static Logger _logger = LoggerFactory.getLogger(SessionAwareApiProvider.class);
    private final ApiProvider _api;
    private final VapiSession _session;
    private final URI _providerURI;

    public SessionAwareApiProvider(ApiProvider api, VapiSession session, URI providerURI) {
        assert (api != null);
        assert (session != null);
        assert (providerURI != null);
        this._api = api;
        this._session = session;
        this._providerURI = providerURI;
    }

    public void invoke(String serviceId, String operationId, DataValue input, ExecutionContext ctx, AsyncHandle<MethodResult> asyncHandle) {
        MethodResult result;
        char[] sessionId = this._session.get();
        ExecutionContext.ApplicationData appData = this.createApplicationData(ctx);
        ExecutionContext ctxWithSession = VapiInvocationSecurity.ctxWithSessionId(sessionId, appData);
        AsyncHandleFuture asyncHandleFuture = new AsyncHandleFuture();
        this._api.invoke(serviceId, operationId, input, ctxWithSession, (AsyncHandle)asyncHandleFuture);
        try {
            result = asyncHandleFuture.get();
        }
        catch (RuntimeException e) {
            asyncHandle.setError(e);
            return;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (SessionAwareApiProvider.isUnauthenticated(result)) {
            Object[] logObjects = new Object[]{serviceId, operationId, this._providerURI};
            _logger.info("Operation {}.{} failed with Unauthenticated to {}. Will re-login and retry.", logObjects);
            char[] newSessionId = this._session.renew(sessionId);
            ExecutionContext ctxWithNewSession = VapiInvocationSecurity.ctxWithSessionId(newSessionId, appData);
            this._api.invoke(serviceId, operationId, input, ctxWithNewSession, asyncHandle);
        } else {
            asyncHandle.setResult((Object)result);
        }
    }

    private static boolean isUnauthenticated(MethodResult result) {
        assert (result != null);
        ErrorValue errorValue = result.getError();
        return errorValue != null && "com.vmware.vapi.std.errors.unauthenticated".equals(errorValue.getName());
    }

    private ExecutionContext.ApplicationData createApplicationData(ExecutionContext ctx) {
        ExecutionContext.ApplicationData appData = ctx.retrieveApplicationData();
        String queryId = QueryMarker.getQueryId();
        if (queryId == null) {
            return appData;
        }
        HashMap<String, String> properties = appData == null ? new HashMap<String, String>() : new HashMap(appData.getAllProperties());
        properties.put("opId", queryId);
        return new ExecutionContext.ApplicationData(properties);
    }

    private static class AsyncHandleFuture
    extends AsyncHandle<MethodResult> {
        private final Lock lock = new ReentrantLock();
        private final Condition set = this.lock.newCondition();
        private boolean completed = false;
        private MethodResult result;
        private RuntimeException error;

        private AsyncHandleFuture() {
        }

        public MethodResult get() throws InterruptedException, RuntimeException {
            this.lock.lock();
            try {
                while (!this.completed) {
                    this.set.await();
                }
                if (this.error == null) {
                    MethodResult methodResult = this.result;
                    return methodResult;
                }
                throw this.error;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(MethodResult result) {
            this.lock.lock();
            try {
                this.result = result;
                this.completed = true;
                this.set.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(RuntimeException error) {
            this.lock.lock();
            try {
                this.error = error;
                this.completed = true;
                this.set.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void updateProgress(DataValue progress) {
        }
    }
}

