/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vcenter;

import com.vmware.cis.data.internal.adapters.customfield.CustomFieldDataProvider;
import com.vmware.cis.data.internal.adapters.federation.DynamicIdForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.FederationConnection;
import com.vmware.cis.data.internal.adapters.federation.FederationDataProvider;
import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.federation.InstanceUuidRouter;
import com.vmware.cis.data.internal.adapters.federation.QueryRouter;
import com.vmware.cis.data.internal.adapters.federation.RouterChain;
import com.vmware.cis.data.internal.adapters.federation.ServiceEndpointDiscovery;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ForeignKeyRouter;
import com.vmware.cis.data.internal.adapters.federation.Vmodl1ModelKeyRouter;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.tagging.TagAssociationDataProvider;
import com.vmware.cis.data.internal.adapters.tagging.TagDataProvider;
import com.vmware.cis.data.internal.adapters.tagging.TaggingDiscovery;
import com.vmware.cis.data.internal.adapters.util.vapi.SharedProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiAuthenticator;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.impl.VapiDataProvider;
import com.vmware.cis.data.internal.adapters.vcenter.ExtensionDataProviderConnector;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vmomi.impl.SharedHttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VlsiClientUtil;
import com.vmware.cis.data.internal.adapters.vmomi.impl.VmomiDataProvider;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.DataProviderConnection;
import com.vmware.cis.data.internal.provider.DataProviderConnector;
import com.vmware.cis.data.internal.provider.ext.CustomPropertyRepositories;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.cis.data.internal.provider.ext.aggregated.DefaultAggregatedModels;
import com.vmware.cis.data.internal.provider.ext.relationship.invert.RelationshipInversionRepository;
import com.vmware.cis.data.internal.provider.profiler.DataProviderProfilerFactory;
import com.vmware.cis.data.internal.provider.profiler.OperationThresholdConfig;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCache;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCacheDecorator;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCacheFactory;
import com.vmware.cis.data.internal.util.TaskExecutor;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.vcenter.VcenterDataProviderFactory;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VcenterDataProviders {
    private static final Logger logger = LoggerFactory.getLogger(VcenterDataProviders.class);
    private static final String ENDPOINT_DATA_PROVIDER = "com.vmware.cis.data.provider";
    private final ServiceLocator _serviceLocator;
    private final Map<String, IdentifiableServiceInstance> _vpxdInstanceIdByNode;
    private final Collection<VcenterDataProviderFactory> _providerFactories;
    private final ExecutorService _executorService;
    private final OperationThresholdConfig _thresholdConfig;
    private final VmomiDataProviderConfig _vmomiCfg;
    private final VapiDataProviderConfig _vapiCfg;
    private final CustomPropertyRepositories _vapiCustomPropRepositories;
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final RelationshipInversionRepository _relationshipInversions;
    private final QuerySchemaCache _schemaCache;
    private volatile Collection<DataProviderConnector> _providerConnectors;

    private VcenterDataProviders(ServiceLocator serviceLocator, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode, Collection<VcenterDataProviderFactory> providerFactories, ExecutorService executorService, OperationThresholdConfig thresholdConfig, VmomiDataProviderConfig vmomiCfg, VapiDataProviderConfig vapiCfg, QuerySchemaCache schemaCache) {
        assert (serviceLocator != null);
        assert (vmomiCfg != null);
        assert (vapiCfg != null);
        assert (schemaCache != null);
        this._serviceLocator = serviceLocator;
        this._vpxdInstanceIdByNode = vpxdInstanceIdByNode;
        this._providerFactories = providerFactories;
        this._executorService = executorService;
        this._thresholdConfig = thresholdConfig;
        this._vmomiCfg = vmomiCfg;
        this._vapiCfg = vapiCfg;
        this._vapiCustomPropRepositories = new CustomPropertyRepositories(vapiCfg.getExtendedModels());
        this._schemaCache = schemaCache;
        this._aggregatedModelLookup = DefaultAggregatedModels.getModelLookup();
        this._relationshipInversions = RelationshipInversionRepository.getDefaultRelationshipInversions();
    }

    public static Builder fromLocator(ServiceLocator serviceLocator) {
        return new Builder(serviceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DataProviderConnector> getProviderConnectors() {
        Collection<DataProviderConnector> providerConnectors = this._providerConnectors;
        if (providerConnectors != null) {
            return providerConnectors;
        }
        VcenterDataProviders vcenterDataProviders = this;
        synchronized (vcenterDataProviders) {
            providerConnectors = this._providerConnectors;
            if (providerConnectors == null) {
                this._providerConnectors = providerConnectors = this.createDefaultSet();
            }
            return providerConnectors;
        }
    }

    private Collection<DataProvider> createFactoryMadeProviders(Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        if (this._providerFactories.isEmpty()) {
            logger.info("No data provider factories found");
            return Collections.emptyList();
        }
        Set<String> vcGuids = this.getVcGuids(vpxdInstanceIdByNode);
        if (vcGuids.isEmpty()) {
            logger.info("No VC servers found. Will not create data providers via data provider factories.");
            return Collections.emptyList();
        }
        logger.info("Creating data providers via data provider factories for VC servers: {}", vcGuids);
        ArrayList<DataProvider> federations = new ArrayList<DataProvider>(this._providerFactories.size());
        for (VcenterDataProviderFactory providerFactory : this._providerFactories) {
            federations.add(this.federateFactoryMadeProviders(providerFactory, vcGuids));
        }
        return federations;
    }

    private Set<String> getVcGuids(Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        HashSet<String> vcGuids = new HashSet<String>();
        for (Map.Entry<String, IdentifiableServiceInstance> e : vpxdInstanceIdByNode.entrySet()) {
            IdentifiableServiceInstance vc = e.getValue();
            String version = vc.getVersion();
            String vcGuid = vc.getServiceInstanceUuid();
            if (version != null && ServiceEndpointDiscovery.isSupportedVersion(version)) {
                vcGuids.add(vcGuid);
                continue;
            }
            logger.debug("Ignoring old VC {} with version {}", (Object)vcGuid, (Object)version);
        }
        return vcGuids;
    }

    private DataProvider federateFactoryMadeProviders(VcenterDataProviderFactory providerFactory, Set<String> vcGuids) {
        assert (providerFactory != null);
        assert (!vcGuids.isEmpty());
        ArrayList<FederationConnection.FederatedProviderInfo> nodes = new ArrayList<FederationConnection.FederatedProviderInfo>(vcGuids.size());
        String cacheKey = providerFactory.getClass().getSimpleName();
        for (String vcGuid : vcGuids) {
            DataProvider dataProvider = this.providerForVc(providerFactory, vcGuid);
            if (dataProvider == null) continue;
            nodes.add(new FederationConnection.FederatedProviderInfo(dataProvider.toString(), vcGuid, cacheKey, this.profileProvider(dataProvider)));
        }
        return this.federateFactoryMadeProviders(nodes);
    }

    private DataProvider providerForVc(VcenterDataProviderFactory providerFactory, String vcGuid) {
        assert (providerFactory != null);
        assert (vcGuid != null);
        DataProvider dataProvider = null;
        try {
            dataProvider = providerFactory.getDataProviderForVcenter(vcGuid);
        }
        catch (RuntimeException ex) {
            logger.error("Failed to create data provider via factory '{}' for VC '{}'", new Object[]{providerFactory.getClass(), vcGuid, ex});
            return null;
        }
        if (dataProvider == null) {
            logger.error("No data provider via factory '{}' for VC '{}'", providerFactory.getClass(), (Object)vcGuid);
        } else {
            logger.debug("Created data provider for VC '{}' : '{}'", (Object)vcGuid, (Object)dataProvider);
        }
        return dataProvider;
    }

    private DataProvider federateFactoryMadeProviders(List<FederationConnection.FederatedProviderInfo> nodes) {
        assert (nodes != null);
        assert (!nodes.isEmpty());
        RouterChain queryRouter = new RouterChain(new InstanceUuidRouter(), new Vmodl1ModelKeyRouter(), new Vmodl1ForeignKeyRouter());
        TaskExecutor taskExecutor = new TaskExecutor(this._executorService, TaskExecutor.ErrorHandlingPolicy.LENIENT);
        return FederationConnection.create(queryRouter, taskExecutor, this._schemaCache, nodes);
    }

    private Collection<DataProviderConnector> createDefaultSet() {
        List<DataProviderConnector> providerConnectors = this.createProviderConnectorsForServices();
        return Collections.unmodifiableCollection(providerConnectors);
    }

    private void addFactoryMadeProviders(List<DataProviderConnector> providerConnectors, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<DataProvider> dataProviders = this.createFactoryMadeProviders(vpxdInstanceIdByNode);
        for (final DataProvider dp : dataProviders) {
            providerConnectors.add(new DataProviderConnector(){

                public DataProviderConnection getConnection(AuthenticationTokenSource authn) {
                    return new DataProviderConnection(){

                        public void close() throws Exception {
                        }

                        public DataProvider getDataProvider() {
                            return dp;
                        }

                        public String toString() {
                            return dp.toString();
                        }
                    };
                }
            });
        }
    }

    private List<DataProviderConnector> createProviderConnectorsForServices() {
        Collection<ServiceEndpointInfo> providerEndpoints = VcenterDataProviders.findDataProviderEndpoints(this._serviceLocator);
        Collection<ServiceEndpointInfo> vpxdEndpoints = ServiceEndpointDiscovery.filterByServiceType(providerEndpoints, ServiceEndpointDiscovery.PROVIDER_TYPE_VC);
        Collection<ServiceEndpointInfo> clsEndpoints = ServiceEndpointDiscovery.filterByServiceType(providerEndpoints, ServiceEndpointDiscovery.PROVIDER_TYPE_CLS);
        Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode = this._vpxdInstanceIdByNode != null ? this._vpxdInstanceIdByNode : ServiceEndpointDiscovery.createVpxdInstanceIdPerNode(vpxdEndpoints, this._vmomiCfg.getVmodlContext(), this._vmomiCfg.getVlsiHttpConfigFactory());
        ArrayList<DataProviderConnector> federatedGroups = new ArrayList<DataProviderConnector>();
        this.addVpxdProviders(federatedGroups, vpxdEndpoints, vpxdInstanceIdByNode);
        this.addClsProviders(federatedGroups, clsEndpoints, vpxdInstanceIdByNode);
        this.addTaggingProviders(federatedGroups, vpxdInstanceIdByNode);
        this.addCustomFieldProviders(federatedGroups, vpxdInstanceIdByNode);
        this.addFactoryMadeProviders(federatedGroups, vpxdInstanceIdByNode);
        return federatedGroups;
    }

    private static String getServiceTypeAndVersion(ServiceEndpointInfo endpointInfo, IdentifiableServiceInstance vpxdInstanceId) {
        assert (endpointInfo != null);
        assert (vpxdInstanceId != null);
        String serviceType = endpointInfo.getServiceType();
        String vpxdVersion = vpxdInstanceId.getVersion();
        String vpxdBuild = vpxdInstanceId.getBuild();
        String serviceTypeAndVersion = serviceType + ":" + vpxdVersion + ":" + vpxdBuild;
        return serviceTypeAndVersion;
    }

    private static Collection<ServiceEndpointInfo> findDataProviderEndpoints(ServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        Collection<ServiceEndpointInfo> endpointInfos = serviceLocator.findServiceEndpoints(null, null, ENDPOINT_DATA_PROVIDER, null);
        return endpointInfos;
    }

    private List<FederationDataProvider.FederatedInstanceInfo> getFederatedInfos(Collection<ServiceEndpointInfo> endpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<ServiceEndpointInfo> nonLegacyEndpoints = ServiceEndpointDiscovery.onlySupported(endpoints, vpxdInstanceIdByNode);
        ArrayList<FederationDataProvider.FederatedInstanceInfo> federatedInstances = new ArrayList<FederationDataProvider.FederatedInstanceInfo>(nonLegacyEndpoints.size());
        for (ServiceEndpointInfo endpoint : nonLegacyEndpoints) {
            String nodeId = endpoint.getNodeId();
            if (nodeId == null) {
                logger.error("No nodeId was discovered for endpoint [service = {}, url = {}]. The data provider at this endpoint will not be connected.", (Object)endpoint.getServiceType(), (Object)endpoint.getUrl());
                continue;
            }
            IdentifiableServiceInstance vpxdInstanceId = vpxdInstanceIdByNode.get(nodeId);
            String serviceTypeAndVersion = VcenterDataProviders.getServiceTypeAndVersion(endpoint, vpxdInstanceId);
            DataProviderConnector dataProvider = this.createProviderForEndpoint(endpoint, serviceTypeAndVersion);
            logger.debug("Created data adapter for data provider of type '{}' at {}", (Object)endpoint.getServiceType(), (Object)endpoint.getUrl());
            String mnemonicName = endpoint.getServiceType() + "@" + endpoint.getUrl();
            IdentifiableServiceInstance instanceId = vpxdInstanceIdByNode.get(nodeId);
            federatedInstances.add(new FederationDataProvider.FederatedInstanceInfo(mnemonicName, instanceId, serviceTypeAndVersion, dataProvider));
        }
        return federatedInstances;
    }

    private DataProviderConnector createProviderForEndpoint(ServiceEndpointInfo endpointInfo, String serviceTypeAndVersion) {
        String protocolName;
        Validate.notNull((Object)endpointInfo);
        Validate.notNull((Object)serviceTypeAndVersion);
        switch (protocolName = endpointInfo.getEndpointProtocol()) {
            case "vmomi": {
                return this.createVmomiAdapter(endpointInfo, serviceTypeAndVersion);
            }
            case "vapi.json.https": 
            case "vapi.json.http": {
                return this.createVapiAdapter(endpointInfo, serviceTypeAndVersion);
            }
        }
        throw new IllegalArgumentException(String.format("Data provider endpoint '%s' has unknown protocol '%s'", endpointInfo.getUrl(), protocolName));
    }

    private DataProviderConnector createVmomiAdapter(ServiceEndpointInfo endpoint, String serviceTypeAndVersion) {
        URI url = endpoint.getUrl();
        KeyStore trustStore = endpoint.getTrustStore();
        VmomiAuthenticator authenticator = this._vmomiCfg.getAuthenticatorFactory().getAuthenticator(endpoint);
        VmomiDataProvider vmomiProvider = new VmomiDataProvider(this._vmomiCfg, url, trustStore, authenticator, this._schemaCache, serviceTypeAndVersion, this._executorService, endpoint.getVcVmodlVersion());
        DataProviderConnector extended = ExtensionDataProviderConnector.extendVmomi(this.profileConnector(vmomiProvider), this._aggregatedModelLookup, this._executorService, this._relationshipInversions, this._schemaCache, serviceTypeAndVersion);
        return extended;
    }

    private DataProviderConnector createVapiAdapter(ServiceEndpointInfo endpoint, String serviceTypeAndVersion) {
        VapiAuthenticator authenticator = this._vapiCfg.getAuthenticatorFactory().getAuthenticator(endpoint);
        VapiDataProvider vapiProvider = new VapiDataProvider(endpoint.getUrl(), endpoint.getTrustStore(), this._vapiCfg, authenticator);
        DataProviderConnector extended = ExtensionDataProviderConnector.extendVapi(this.profileConnector(vapiProvider), this._vapiCustomPropRepositories, this._schemaCache, serviceTypeAndVersion);
        return extended;
    }

    private void addVpxdProviders(List<DataProviderConnector> providers, Collection<ServiceEndpointInfo> vpxdEndpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        List<FederationDataProvider.FederatedInstanceInfo> federatedInstances = this.getFederatedInfos(vpxdEndpoints, vpxdInstanceIdByNode);
        if (federatedInstances.isEmpty()) {
            logger.info("No VC data provider API endpoints found. VC data provider will not be available.");
            return;
        }
        QueryRouter queryRouter = federatedInstances.size() > 1 ? new RouterChain(new InstanceUuidRouter(), new Vmodl1ModelKeyRouter(), new Vmodl1ForeignKeyRouter()) : new InstanceUuidRouter();
        providers.add(this.federateConnector(queryRouter, federatedInstances));
    }

    private void addClsProviders(List<DataProviderConnector> providers, Collection<ServiceEndpointInfo> clsEndpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        List<FederationDataProvider.FederatedInstanceInfo> federatedInstances = this.getFederatedInfos(clsEndpoints, vpxdInstanceIdByNode);
        if (federatedInstances.isEmpty()) {
            logger.info("No CLS data provider API endpoints found. CLS data provider will not be available.");
            return;
        }
        providers.add(this.federateConnector(new InstanceUuidRouter(), federatedInstances));
    }

    private void addTaggingProviders(Collection<DataProviderConnector> providers, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<ServiceEndpointInfo> taggingEndpoints;
        try {
            taggingEndpoints = TaggingDiscovery.findTaggingEndpoints(this._serviceLocator);
        }
        catch (Exception e) {
            logger.warn("Exception caught while creating Tagging data providers. Tagging data will not be available.", (Throwable)e);
            return;
        }
        taggingEndpoints = ServiceEndpointDiscovery.onlySupported(taggingEndpoints, vpxdInstanceIdByNode);
        if (taggingEndpoints.isEmpty()) {
            logger.info("No Tagging API endpoints found. Tagging will not be available.");
        } else {
            this.addTagDataProvider(providers, taggingEndpoints);
            this.addTagAssociationDataProvider(providers, taggingEndpoints, vpxdInstanceIdByNode);
        }
    }

    private void addTagDataProvider(Collection<DataProviderConnector> providers, Collection<ServiceEndpointInfo> taggingServiceEndpoints) {
        ServiceEndpointInfo taggingEndpoint = TaggingDiscovery.chooseEndpointForTagAndCategoryData(taggingServiceEndpoints);
        TagDataProvider tagging = new TagDataProvider(this._vapiCfg.getVApiConnectionFactory(), taggingEndpoint.getUrl(), taggingEndpoint.getTrustStore());
        String taggingCacheKey = "Tags";
        providers.add(this.cacheConnector(this.profileConnector(tagging), taggingCacheKey));
        logger.debug("Created data adapter for tag and category data at {}", (Object)taggingEndpoint.getUrl());
    }

    private void addTagAssociationDataProvider(Collection<DataProviderConnector> providers, Collection<ServiceEndpointInfo> taggingServiceEndpoints, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        ArrayList<FederationDataProvider.FederatedInstanceInfo> associationProviderInfos = new ArrayList<FederationDataProvider.FederatedInstanceInfo>();
        for (ServiceEndpointInfo endpointInfo : taggingServiceEndpoints) {
            TagAssociationDataProvider associationProvider = new TagAssociationDataProvider(this._vapiCfg.getVApiConnectionFactory(), endpointInfo.getUrl(), endpointInfo.getTrustStore());
            String nodeId = endpointInfo.getNodeId();
            IdentifiableServiceInstance vpxdInstanceId = vpxdInstanceIdByNode.get(nodeId);
            FederationDataProvider.FederatedInstanceInfo instanceInfo = new FederationDataProvider.FederatedInstanceInfo("TagAssociations@" + endpointInfo.getUrl(), vpxdInstanceId, "TagAssociations", this.profileConnector(associationProvider));
            associationProviderInfos.add(instanceInfo);
            logger.debug("Created data adapter for tag association data at {}", (Object)endpointInfo.getUrl());
        }
        RouterChain router = new RouterChain(new InstanceUuidRouter(), new DynamicIdForeignKeyRouter());
        providers.add(this.federateConnector(router, associationProviderInfos));
    }

    private void addCustomFieldProviders(Collection<DataProviderConnector> providers, Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
        Collection<ServiceEndpointInfo> vcEndpoints = ServiceEndpointDiscovery.findVcEndpoints(this._serviceLocator);
        if ((vcEndpoints = ServiceEndpointDiscovery.onlySupported(vcEndpoints, vpxdInstanceIdByNode)).isEmpty()) {
            logger.info("No VIM API endpoints found. Custom fields will not be available.");
            return;
        }
        ArrayList<FederationDataProvider.FederatedInstanceInfo> instanceInfos = new ArrayList<FederationDataProvider.FederatedInstanceInfo>();
        for (ServiceEndpointInfo endpointInfo : vcEndpoints) {
            VmomiAuthenticator authenticator = this._vmomiCfg.getAuthenticatorFactory().getAuthenticator(endpointInfo);
            CustomFieldDataProvider customFieldProvider = new CustomFieldDataProvider(this._vmomiCfg.getVmodlContext(), this._vmomiCfg.getVlsiHttpConfigFactory(), endpointInfo.getUrl(), endpointInfo.getTrustStore(), authenticator);
            String nodeId = endpointInfo.getNodeId();
            IdentifiableServiceInstance fakeInstanceId = vpxdInstanceIdByNode.get(nodeId);
            FederationDataProvider.FederatedInstanceInfo instanceInfo = new FederationDataProvider.FederatedInstanceInfo("CustomFields@" + endpointInfo.getUrl(), fakeInstanceId, "CustomFields", this.profileConnector(customFieldProvider));
            instanceInfos.add(instanceInfo);
            logger.debug("Created data adapter for custom fields data at {}", (Object)endpointInfo.getUrl());
        }
        providers.add(this.federateConnector(new InstanceUuidRouter(), instanceInfos));
    }

    private DataProviderConnector profileConnector(DataProviderConnector providerConnector) {
        return DataProviderProfilerFactory.profileConnector((DataProviderConnector)providerConnector, (OperationThresholdConfig)this._thresholdConfig);
    }

    private DataProvider profileProvider(DataProvider provider) {
        return DataProviderProfilerFactory.profileProvider((DataProvider)provider, (long)this._thresholdConfig.getOperationThreshold());
    }

    private DataProviderConnector cacheConnector(DataProviderConnector connector, String key) {
        return QuerySchemaCacheDecorator.cacheConnector((DataProviderConnector)connector, (String)key, (QuerySchemaCache)this._schemaCache);
    }

    private DataProviderConnector federateConnector(QueryRouter router, Collection<FederationDataProvider.FederatedInstanceInfo> instanceInfos) {
        return new FederationDataProvider(router, this._executorService, this._schemaCache, instanceInfos);
    }

    public static final class Builder {
        private final ServiceLocator _serviceLocator;
        private Map<String, IdentifiableServiceInstance> _vpxdInstanceIdByNode;
        private Collection<VcenterDataProviderFactory> _providerFactories;
        private ExecutorService _executorService;
        private VmomiDataProviderConfig _vmomiCfg = null;
        private VapiDataProviderConfig _vapiCfg = null;
        private QuerySchemaCache _schemaCache = null;
        private OperationThresholdConfig _thresholdConfig = null;

        private Builder(ServiceLocator serviceLocator) {
            Validate.notNull((Object)serviceLocator, (String)"The serviceLocator is required.");
            this._serviceLocator = serviceLocator;
        }

        public Builder withVpxdInstanceIdByNodeMap(Map<String, IdentifiableServiceInstance> vpxdInstanceIdByNode) {
            this._vpxdInstanceIdByNode = vpxdInstanceIdByNode;
            return this;
        }

        public Builder withProviderFactories(Collection<VcenterDataProviderFactory> providerFactories) {
            this._providerFactories = providerFactories;
            return this;
        }

        public Builder withExecutor(ExecutorService executorService) {
            this._executorService = executorService;
            return this;
        }

        public Builder withVmomiDataProviderConfig(VmomiDataProviderConfig vmomiCfg) {
            this._vmomiCfg = vmomiCfg;
            return this;
        }

        public Builder withVapiDataProviderConfig(VapiDataProviderConfig vapiCfg) {
            this._vapiCfg = vapiCfg;
            return this;
        }

        public Builder withQuerySchemaCache(QuerySchemaCache schemaCache) {
            this._schemaCache = schemaCache;
            return this;
        }

        public Builder withProviderOperationThreshold(OperationThresholdConfig thresholdConfig) {
            assert (thresholdConfig != null);
            this._thresholdConfig = thresholdConfig;
            return this;
        }

        public VcenterDataProviders build() {
            QuerySchemaCache schemaCache;
            Collection<VcenterDataProviderFactory> providerFactories;
            VapiDataProviderConfig vapiCfgToUse;
            ExecutorService executorToUse = this._executorService != null ? this._executorService : Executors.newSingleThreadExecutor();
            OperationThresholdConfig thresholdConfigToUse = this._thresholdConfig != null ? this._thresholdConfig : OperationThresholdConfig.Builder.create().build();
            VmomiDataProviderConfig vmomiCfgToUse = this._vmomiCfg;
            if (vmomiCfgToUse == null) {
                VmodlContext vmodlContext = VlsiClientUtil.createDefaultVmodlContext();
                SharedHttpConfigurationFactory httpConfigFactory = new SharedHttpConfigurationFactory();
                vmomiCfgToUse = VmomiDataProviderConfig.Builder.create().withHttpConfigurationFactory(httpConfigFactory).withVmodlContext(vmodlContext).build();
            }
            if ((vapiCfgToUse = this._vapiCfg) == null) {
                SharedProtocolConnectionFactory vapiConnFactory = new SharedProtocolConnectionFactory();
                vapiCfgToUse = VapiDataProviderConfig.Builder.create().withVapiConnectionFactory(vapiConnFactory).build();
            }
            if ((providerFactories = this._providerFactories) == null) {
                providerFactories = Collections.emptyList();
            }
            if ((schemaCache = this._schemaCache) == null) {
                schemaCache = QuerySchemaCacheFactory.createNoOpCache();
            }
            return new VcenterDataProviders(this._serviceLocator, this._vpxdInstanceIdByNode, providerFactories, executorToUse, thresholdConfigToUse, vmomiCfgToUse, vapiCfgToUse, schemaCache);
        }
    }
}

