/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.impl;

import com.google.common.collect.ImmutableSet;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.util.filter.OperatorLikeEvaluator;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

final class NamePropertyValueConverter
implements DataProvider {
    private static final int HEX_SEQUENCE_LENGTH = 2;
    private static final int HEX_RADIX = 16;
    private static final char PERCENTAGE = '%';
    private static final char FORWARD_SLASH = '/';
    private static final char BACK_SLASH = '\\';
    private static final String ESCAPED_BACK_SLASH = "%5c";
    private static final String ESCAPED_FORWARD_SLASH = "%2f";
    private static final String ESCAPED_PERCENTAGE = "%25";
    private static final int ESCAPED_BACK_SLASH_HEX = Integer.parseInt("5c", 16);
    private static final int ESCAPED_FORWARD_SLASH_HEX = Integer.parseInt("2f", 16);
    private static final int ESCAPED_PERCENTAGE_HEX = Integer.parseInt("25", 16);
    private static final Set<String> PROPERTIES_TO_CONVERT = ImmutableSet.of((Object)"Network/name", (Object)"OpaqueNetwork/name", (Object)"DistributedVirtualPortgroup/name", (Object)"ComputeResource/name", (Object)"ClusterComputeResource/name", (Object)"Datacenter/name", (Object[])new String[]{"Datastore/name", "Folder/name", "StoragePod/name", "HostSystem/name", "ResourcePool/name", "VirtualApp/name", "DistributedVirtualSwitch/name", "VmwareDistributedVirtualSwitch/name", "VirtualMachine/name", "VimSearch/name", "VimSearch/searchTerm"});
    private final DataProvider _provider;

    public NamePropertyValueConverter(DataProvider provider) {
        assert (provider != null);
        this._provider = provider;
    }

    public ResultSet executeQuery(Query query) {
        assert (query != null);
        Query queryToExecute = NamePropertyValueConverter.requiresConversion(query) ? NamePropertyValueConverter.convertQuery(query) : query;
        ResultSet result = this._provider.executeQuery(queryToExecute);
        if (NamePropertyValueConverter.requiresConversion(result)) {
            return NamePropertyValueConverter.convertResult(result);
        }
        return result;
    }

    public QuerySchema getSchema() {
        return this._provider.getSchema();
    }

    public String toString() {
        return this._provider.toString();
    }

    private static boolean requiresConversion(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        if (filter == null) {
            return false;
        }
        for (PropertyPredicate predicate : filter.getCriteria()) {
            String property = predicate.getProperty();
            if (!PROPERTIES_TO_CONVERT.contains(property)) continue;
            return true;
        }
        return false;
    }

    private static boolean requiresConversion(ResultSet result) {
        assert (result != null);
        List properties = result.getProperties();
        for (String property : properties) {
            if (!PROPERTIES_TO_CONVERT.contains(property)) continue;
            return true;
        }
        return false;
    }

    private static Query convertQuery(Query originalQuery) {
        assert (originalQuery != null);
        assert (NamePropertyValueConverter.requiresConversion(originalQuery));
        Filter filter = originalQuery.getFilter();
        ArrayList<PropertyPredicate> convertedPredicates = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate predicate : filter.getCriteria()) {
            String property = predicate.getProperty();
            if (PROPERTIES_TO_CONVERT.contains(property)) {
                convertedPredicates.add(NamePropertyValueConverter.convertPredicate(predicate));
                continue;
            }
            convertedPredicates.add(predicate);
        }
        return QueryCopy.copy((Query)originalQuery).where(filter.getOperator(), convertedPredicates).build();
    }

    private static PropertyPredicate convertPredicate(PropertyPredicate predicate) {
        String escapedValue;
        assert (predicate != null);
        assert (predicate.getComparableValue() != null);
        String property = predicate.getProperty();
        PropertyPredicate.ComparisonOperator operator = predicate.getOperator();
        Object value = predicate.getComparableValue();
        if (operator.equals((Object)PropertyPredicate.ComparisonOperator.IN)) {
            Collection<?> escapedValue2 = NamePropertyValueConverter.escape(property, (Collection)value);
            return NamePropertyValueConverter.copy(predicate, escapedValue2);
        }
        if (!(value instanceof String)) {
            String msg = String.format("The comparable value for property '%s' must be 'String' not '%s'.", property, value.getClass().getSimpleName());
            throw new IllegalArgumentException(msg);
        }
        if (operator.equals((Object)PropertyPredicate.ComparisonOperator.LIKE)) {
            OperatorLikeEvaluator.StringMatchingInfo matchInfo = OperatorLikeEvaluator.analyzeTemplate((String)((String)value));
            String escapedSearchText = NamePropertyValueConverter.escape(matchInfo.getSearchText());
            escapedValue = OperatorLikeEvaluator.toSearchTemplate((String)escapedSearchText, (OperatorLikeEvaluator.StringMatchingMode)matchInfo.getMode());
        } else {
            escapedValue = NamePropertyValueConverter.escape((String)value);
        }
        return NamePropertyValueConverter.copy(predicate, escapedValue);
    }

    private static Collection<?> escape(String property, Collection<?> values) {
        assert (property != null);
        assert (values != null);
        ArrayList<String> escaped = new ArrayList<String>(values.size());
        for (Object value : values) {
            if (value instanceof String) {
                escaped.add(NamePropertyValueConverter.escape((String)value));
                continue;
            }
            String msg = String.format("The comparable value for property '%s' must contain only 'String' values not '%s'.", property, value.getClass().getSimpleName());
            throw new IllegalArgumentException(msg);
        }
        return escaped;
    }

    private static String escape(String value) {
        assert (value != null);
        StringBuilder escaped = new StringBuilder();
        block5: for (int index = 0; index < value.length(); ++index) {
            char ch = value.charAt(index);
            switch (ch) {
                case '%': {
                    escaped.append(ESCAPED_PERCENTAGE);
                    continue block5;
                }
                case '/': {
                    escaped.append(ESCAPED_FORWARD_SLASH);
                    continue block5;
                }
                case '\\': {
                    escaped.append(ESCAPED_BACK_SLASH);
                    continue block5;
                }
                default: {
                    escaped.append(ch);
                }
            }
        }
        return escaped.toString();
    }

    private static ResultSet convertResult(ResultSet result) {
        assert (result != null);
        assert (NamePropertyValueConverter.requiresConversion(result));
        List properties = result.getProperties();
        boolean[] propertyConvertIndex = NamePropertyValueConverter.getPropertyConvertIndex(properties);
        ResultSet.Builder resultBuilder = ResultSet.Builder.properties((List)properties);
        for (ResourceItem item : result.getItems()) {
            List values = item.getPropertyValues();
            ArrayList convertedValues = new ArrayList(values.size());
            for (int i = 0; i < values.size(); ++i) {
                boolean propertyToConvert = propertyConvertIndex[i];
                Object value = values.get(i);
                Object convertedValue = !propertyToConvert ? value : (value == null ? value : (!(value instanceof String) ? value : NamePropertyValueConverter.unescape((String)value)));
                convertedValues.add(convertedValue);
            }
            resultBuilder.item(item.getKey(), convertedValues);
        }
        return resultBuilder.totalCount(result.getTotalCount()).build();
    }

    private static boolean[] getPropertyConvertIndex(List<String> properties) {
        assert (properties != null);
        boolean[] propertyConvertIndex = new boolean[properties.size()];
        for (int i = 0; i < properties.size(); ++i) {
            String property = properties.get(i);
            propertyConvertIndex[i] = PROPERTIES_TO_CONVERT.contains(property);
        }
        return propertyConvertIndex;
    }

    private static String unescape(String value) {
        assert (value != null);
        int escapeIndex = value.indexOf(37);
        if (escapeIndex == -1 || escapeIndex + 2 >= value.length()) {
            return value;
        }
        StringBuilder unescaped = new StringBuilder();
        int index = 0;
        while (index < value.length()) {
            char ch2;
            char ch;
            int escapeSequenceEnd = index + 2;
            if ((ch = value.charAt(index++)) != '%' || escapeSequenceEnd >= value.length()) {
                unescaped.append(ch);
                continue;
            }
            char ch1 = value.charAt(index);
            Character unescapedCh = NamePropertyValueConverter.getUnescapedChar(ch1, ch2 = value.charAt(index + 1));
            if (unescapedCh == null) {
                unescaped.append(ch);
                continue;
            }
            unescaped.append(unescapedCh);
            index += 2;
        }
        return unescaped.toString();
    }

    private static Character getUnescapedChar(char ch1, char ch2) {
        int hex1 = Character.digit(ch1, 16);
        if (hex1 == -1) {
            return null;
        }
        int hex2 = Character.digit(ch2, 16);
        if (hex2 == -1) {
            return null;
        }
        int hex = hex1 * 16 + hex2;
        if (hex == ESCAPED_FORWARD_SLASH_HEX) {
            return Character.valueOf('/');
        }
        if (hex == ESCAPED_BACK_SLASH_HEX) {
            return Character.valueOf('\\');
        }
        if (hex == ESCAPED_PERCENTAGE_HEX) {
            return Character.valueOf('%');
        }
        return null;
    }

    private static PropertyPredicate copy(PropertyPredicate predicate, Object comparableValue) {
        return new PropertyPredicate(predicate.getProperty(), predicate.getOperator(), comparableValue, predicate.isIgnoreCase());
    }
}

