/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.model;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

@QueryModel(value="Datastore")
public class DatastoreExtendedDataModel {
    @Property(value="Datastore/capability/perFileThinProvisioningSupported")
    public Boolean thinProvisioningSupported;
    @Property(value="Datastore/host")
    public Datastore.HostMount hostMount;
    @Property(value="Datastore/summary/url")
    public String url;
    @Property(value="Datastore/parentStoragePod")
    public ManagedObjectReference parentPod;
    @Relationship(value={"Datastore/parent"})
    @Property(value="StoragePod/name")
    public String dsClusterName;
    @Relationship(value={"Datastore/parent"})
    @Property(value="Folder/@modelKey")
    public ManagedObjectReference folder;
    @Relationship(value={"Datastore/hostKey", "HostSystem/parent"})
    @Property(value="ClusterComputeResource/@modelKey")
    public ManagedObjectReference[] cluster;
    @Relationship(value={"Datastore/hostKey", "HostSystem/parent"})
    @Property(value="ComputeResource/@modelKey")
    public ManagedObjectReference[] computeResource;
    @Relationship(value={"Datastore/hostKey", "HostSystem/rps"})
    @Property(value="ResourcePool/@modelKey")
    public ManagedObjectReference[] resourcePool;
    @Relationship(value={"Datastore/hostKey", "HostSystem/vapp"})
    @Property(value="VirtualApp/@modelKey")
    public ManagedObjectReference[] hostVapp;
    @Relationship(value={"Datastore/parent", "Folder/parent"})
    @Property(value="Datacenter/@modelKey")
    public ManagedObjectReference grandparentDc;

    @PredicateProperty(value="Datastore/belongsToDsCluster")
    public static PropertyPredicate getBelongsToDsCluster() {
        return new PropertyPredicate("Datastore/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"StoragePod");
    }

    @PredicateProperty(value="Datastore/isSystemDatastore")
    public static PropertyPredicate getIsSystemDatastore() {
        return new PropertyPredicate("Datastore/summary/type", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"PMEM");
    }

    @DerivedProperty(value="Datastore/specificType")
    public static String getSpecificType(@SourceProperty(value="Datastore/info") Object info, @SourceProperty(value="Datastore/summary/type") String summaryType) {
        if (info instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)info;
            if (vmfsInfo.vmfs.majorVersion > 0) {
                return "VMFS " + vmfsInfo.vmfs.majorVersion;
            }
            return "VMFS";
        }
        if (info instanceof VvolDatastoreInfo) {
            return "VVol";
        }
        return summaryType;
    }
}

