/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.adapters.vmomi.model;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.encryption.CryptoKeyId;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

@QueryModel(value="VirtualMachine")
public class VmExtendedDataModel {
    @Property(value="VirtualMachine/runtime/consolidationNeeded")
    public Boolean consolidationNeeded;
    @Property(value="VirtualMachine/config/version")
    public String hwVersion;
    @Property(value="VirtualMachine/guest/toolsVersionStatus2")
    public String toolsVersionStatus;
    @Property(value="VirtualMachine/config/template")
    public Boolean template;
    @Property(value="VirtualMachine/config/ftInfo/role")
    public String ftRole;
    @Property(value="VirtualMachine/runtime/powerState")
    public String powerState;
    @Property(value="VirtualMachine/runtime/faultToleranceState")
    public String ftState;
    @Property(value="VirtualMachine/runtime/question")
    public String question;
    @Property(value="VirtualMachine/config/annotation")
    public String annotation;
    @Property(value="VirtualMachine/config/guestFullName")
    public String guestOS;
    @Property(value="VirtualMachine/guest/ipAddress")
    public String ip;
    @Property(value="VirtualMachine/runtime/host")
    public String host;
    @Property(value="VirtualMachine/parentVApp")
    public String vapp;
    @Property(value="VirtualMachine/network")
    public String allNetwork;
    @Property(value="VirtualMachine/parent")
    public String parentFolder;
    @Property(value="VirtualMachine/summary/storage/committed")
    public Long usedSpace;
    @Property(value="VirtualMachine/config/files/vmPathName")
    public String vmPathName;
    @Property(value="VirtualMachine/runtime/connectionState")
    public String connectionState;
    @Property(value="VirtualMachine/config/ftInfo/primaryVM")
    public String primaryVM;
    @Property(value="VirtualMachine/config/ftInfo/secondaries")
    public String secondaries;
    @Property(value="VirtualMachine/summary/quickStats/overallCpuUsage")
    public Long hostCpuUsage;
    @Property(value="VirtualMachine/summary/quickStats/hostMemoryUsage")
    public Long hostMemoryUsage;
    @Relationship(value={"VirtualMachine/runtime/host"})
    @Property(value="HostSystem/name")
    public String hostName;
    @Relationship(value={"VirtualMachine/datastore"})
    @Property(value="Datastore/name")
    public String[] datastoreNames;
    @Relationship(value={"VirtualMachine/runtime/host", "HostSystem/parent"})
    @Property(value="ClusterComputeResource/name")
    public String vmClusterName;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="DistributedVirtualPortgroup/@modelKey")
    public ManagedObjectReference[] dvPortGroup;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="Network/@modelKey")
    public ManagedObjectReference[] standardnetwork;
    @Relationship(value={"VirtualMachine/datastore", "Datastore/parent"})
    @Property(value="StoragePod/@modelKey")
    public ManagedObjectReference[] storagePod;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="OpaqueNetwork/@modelKey")
    public ManagedObjectReference[] opaquenetwork;
    @Relationship(value={"ScheduledTask/info/taskObject~"})
    @Property(value="ScheduledTask/@modelKey")
    public ManagedObjectReference[] scheduledTask;
    @Relationship(value={"VirtualMachine/network"})
    @Property(value="HostNetwork/@modelKey")
    public ManagedObjectReference[] hostNetwork;
    @Relationship(value={"VirtualMachine/parent", "Folder/parent"})
    @Property(value="Datacenter/@modelKey")
    public ManagedObjectReference grandparentDc;
    @Relationship(value={"VirtualMachine/resourcePool", "ResourcePool/parent"})
    @Property(value="ClusterComputeResource/@modelKey")
    public ManagedObjectReference rpParentCluster;

    @PredicateProperty(value="VirtualMachine/hasSnapshot")
    public static PropertyPredicate getHasSnapshot() {
        return new PropertyPredicate("VirtualMachine/snapshot", PropertyPredicate.ComparisonOperator.UNSET, (Object)false);
    }

    @DerivedProperty(value="VirtualMachine/haProtected")
    public static String getHaProtected(@SourceProperty(value="VirtualMachine/runtime/dasVmProtection") RuntimeInfo.DasProtectionState dasProtectionState) {
        if (dasProtectionState == null) {
            return "na";
        }
        return String.valueOf(dasProtectionState.dasProtected);
    }

    @DerivedProperty(value="VirtualMachine/haProtectedLabel")
    public static String getHaProtectedLabel(@SourceProperty(value="VirtualMachine/runtime/dasVmProtection") RuntimeInfo.DasProtectionState dasProtectionState) {
        return VmExtendedDataModel.getHaProtected(dasProtectionState);
    }

    @DerivedProperty(value="VirtualMachine/isEncryptedVm")
    public static Boolean getIsEncryptedVm(@SourceProperty(value="VirtualMachine/config/keyId") CryptoKeyId keyId) {
        return keyId != null;
    }

    @DerivedProperty(value="VirtualMachine/guestMemoryPercentage")
    public static long getGuestMemoryPercentage(@SourceProperty(value="VirtualMachine/summary/config/memorySizeMB") Integer memorySizeMB, @SourceProperty(value="VirtualMachine/summary/quickStats/guestMemoryUsage") Integer guestMemoryUsage) {
        if (VmExtendedDataModel.isNullOrZero(memorySizeMB) || VmExtendedDataModel.isNullOrZero(guestMemoryUsage)) {
            return 0L;
        }
        return Math.round(guestMemoryUsage * 100 / memorySizeMB);
    }

    private static boolean isNullOrZero(Integer i) {
        return i == null || i == 0;
    }
}

