/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.WebssoClientException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreImpl
implements MessageStore {
    private final LinkedList<Message> messages;
    private final Logger logger = LoggerFactory.getLogger(MessageStoreImpl.class);
    private final ReentrantReadWriteLock readWriteLock;
    private final Lock readLock;
    private final Lock writeLock;
    private static final int DEFAULT_MAX_CONCURRENT_REQUEST = 5000;
    private final int maxSize;

    public MessageStoreImpl() {
        this(5000);
    }

    public MessageStoreImpl(int maxConcurrentReqeusts) {
        this.maxSize = maxConcurrentReqeusts > 0 ? maxConcurrentReqeusts : 5000;
        this.messages = new LinkedList();
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String messageId) throws WebssoClientException {
        Validate.notNull((Object)messageId);
        try {
            this.writeLock.lock();
            for (Message message : this.messages) {
                if (!message.getId().equals(messageId)) continue;
                this.messages.remove(message);
                break;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associate(String messageId1, String messageId2) {
        if (messageId1 == null || messageId2 == null) {
            return;
        }
        try {
            this.writeLock.lock();
            Message a = this.get(messageId1);
            Message b = this.get(messageId2);
            if (a == null || b == null) {
                return;
            }
            a.addToAssociated(b);
            b.addToAssociated(a);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collection<Message> getAll() {
        return this.messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> getAllByType(MessageType type) {
        if (type == null) {
            return null;
        }
        LinkedList<Message> resultMessages = new LinkedList<Message>();
        try {
            this.readLock.lock();
            for (Message message : this.messages) {
                if (message.getType() != type) continue;
                resultMessages.add(message);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return resultMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> getAllByRelayState(String relayState) {
        if (relayState == null) {
            return null;
        }
        LinkedList<Message> resultMessages = new LinkedList<Message>();
        try {
            this.readLock.lock();
            for (Message message : this.messages) {
                String rState = message.getRelayState();
                if (rState == null || !rState.equals(relayState)) continue;
                resultMessages.add(message);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return resultMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message get(String messageId) {
        if (messageId == null) {
            return null;
        }
        Message message = null;
        try {
            this.readLock.lock();
            Iterator iterator = this.messages.iterator();
            while (iterator.hasNext() && !(message = (Message)iterator.next()).getId().equals(messageId)) {
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (null == message) {
            this.logger.error("No request with id=:%s found.  Message store size:%s", (Object)messageId, (Object)this.size());
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> get(MessageType type, String relayState) {
        if (relayState == null || type == null) {
            return null;
        }
        LinkedList<Message> resultMessages = new LinkedList<Message>();
        try {
            this.readLock.lock();
            for (Message message : this.messages) {
                String rState = message.getRelayState();
                if (rState == null || !rState.equals(relayState) || !message.getType().equals((Object)type)) continue;
                resultMessages.add(message);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return resultMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.writeLock.lock();
            this.messages.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Message message) {
        if (message != null && message.getId() != null && !message.getId().isEmpty()) {
            try {
                this.writeLock.lock();
                if (this.size() == this.getMaxSize()) {
                    this.messages.removeFirst();
                    assert (this.size() < this.getMaxSize());
                }
                this.messages.add(message);
            }
            finally {
                this.writeLock.unlock();
            }
            this.logger.debug(String.format("New MessageStore entry added:%s , store size: %s ", new Object[]{message.getType(), this.messages.size()}));
        }
    }

    public int size() {
        return this.messages.size();
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

