/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.IDPConfiguration;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SPConfiguration;
import com.vmware.identity.websso.client.WebssoClientException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.Validate;

public class MetadataSettingsImpl
implements MetadataSettings {
    private final List<SPConfiguration> spConfigurations = new LinkedList<SPConfiguration>();
    private final List<IDPConfiguration> idpConfigurations = new LinkedList<IDPConfiguration>();
    private final ReentrantReadWriteLock readWriteLock_SP = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock readWriteLock_IDP = new ReentrantReadWriteLock();
    private final Lock readLock_SP = this.readWriteLock_SP.readLock();
    private final Lock writeLock_SP = this.readWriteLock_SP.writeLock();
    private final Lock readLock_IDP = this.readWriteLock_IDP.readLock();
    private final Lock writeLock_IDP = this.readWriteLock_IDP.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSPConfiguration(SPConfiguration spConfiguration) {
        if (spConfiguration == null) {
            return;
        }
        try {
            this.writeLock_SP.lock();
            this.spConfigurations.add(spConfiguration);
        }
        finally {
            this.writeLock_SP.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSPConfiguration(SPConfiguration spConfiguration) throws WebssoClientException {
        this.writeLock_SP.lock();
        try {
            this.removeSPConfiguration(spConfiguration.getAlias());
            this.addSPConfiguration(spConfiguration);
        }
        finally {
            this.writeLock_SP.unlock();
        }
    }

    @Override
    public Collection<SPConfiguration> getAllSPConfigurations() {
        return this.spConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SPConfiguration getSPConfiguration(String alias) {
        Validate.notNull((Object)alias, (String)(this.getClass() + " null argument"));
        SPConfiguration retConfig = null;
        try {
            this.readLock_SP.lock();
            for (SPConfiguration config : this.spConfigurations) {
                if (!config.getAlias().equals(alias)) continue;
                retConfig = config;
                break;
            }
        }
        finally {
            this.readLock_SP.unlock();
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SPConfiguration getSPConfigurationByEntityID(String entityId) {
        Validate.notNull((Object)entityId, (String)(this.getClass() + " null argument"));
        SPConfiguration retConfig = null;
        try {
            this.readLock_SP.lock();
            for (SPConfiguration config : this.spConfigurations) {
                if (!config.getEntityID().equals(entityId)) continue;
                retConfig = config;
                break;
            }
        }
        finally {
            this.readLock_SP.unlock();
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SPConfiguration removeSPConfiguration(String alias) {
        Validate.notNull((Object)alias, (String)(this.getClass() + " null argument"));
        SPConfiguration retConfig = null;
        try {
            this.writeLock_SP.lock();
            for (SPConfiguration config : this.spConfigurations) {
                if (!config.getAlias().equals(alias)) continue;
                this.spConfigurations.remove(config);
                retConfig = config;
                break;
            }
        }
        finally {
            this.writeLock_SP.unlock();
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIDPConfiguration(IDPConfiguration config) {
        if (config == null) {
            return;
        }
        try {
            this.writeLock_IDP.lock();
            this.idpConfigurations.add(config);
        }
        finally {
            this.writeLock_IDP.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIDPConfiguration(IDPConfiguration idpConfiguration) throws WebssoClientException {
        try {
            this.writeLock_IDP.lock();
            this.removeIDPConfiguration(idpConfiguration.getAlias());
            this.addIDPConfiguration(idpConfiguration);
        }
        finally {
            this.writeLock_IDP.unlock();
        }
    }

    @Override
    public Collection<IDPConfiguration> getAllIDPConfigurations() {
        return this.idpConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDPConfiguration getIDPConfiguration(String alias) {
        Validate.notNull((Object)alias, (String)(this.getClass() + " null argument"));
        IDPConfiguration retConfig = null;
        try {
            this.readLock_IDP.lock();
            for (IDPConfiguration config : this.idpConfigurations) {
                if (!config.getAlias().equals(alias)) continue;
                retConfig = config;
                break;
            }
        }
        finally {
            this.readLock_IDP.unlock();
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDPConfiguration getIDPConfigurationByEntityID(String id) {
        IDPConfiguration retConfig;
        block5: {
            Validate.notNull((Object)id, (String)(this.getClass() + " null argument"));
            retConfig = null;
            try {
                this.readLock_IDP.lock();
                for (IDPConfiguration config : this.idpConfigurations) {
                    if (!config.getEntityID().equals(id)) continue;
                    retConfig = config;
                    break;
                }
                if (retConfig != null) break block5;
                for (IDPConfiguration config : this.idpConfigurations) {
                    if (!config.isSameEntity(id)) continue;
                    retConfig = config;
                    break;
                }
            }
            finally {
                this.readLock_IDP.unlock();
            }
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDPConfiguration removeIDPConfiguration(String alias) {
        Validate.notNull((Object)alias, (String)(this.getClass() + " null argument"));
        IDPConfiguration retConfig = null;
        try {
            this.writeLock_IDP.lock();
            for (IDPConfiguration config : this.idpConfigurations) {
                if (!config.getAlias().equals(alias)) continue;
                this.idpConfigurations.remove(config);
                retConfig = config;
                break;
            }
        }
        finally {
            this.writeLock_IDP.unlock();
        }
        return retConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.writeLock_SP.lock();
            this.writeLock_IDP.lock();
            this.spConfigurations.clear();
            this.idpConfigurations.clear();
        }
        finally {
            this.writeLock_SP.unlock();
            this.writeLock_IDP.unlock();
        }
    }

    @Override
    public void StartRebuilding() {
        this.writeLock_SP.lock();
        this.writeLock_IDP.lock();
    }

    @Override
    public void EndRebuilding() {
        this.writeLock_SP.unlock();
        this.writeLock_IDP.unlock();
    }
}

