/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client.endpoint;

import com.vmware.identity.websso.client.LogonProcessor;
import com.vmware.identity.websso.client.LogonProcessorEx;
import com.vmware.identity.websso.client.Message;
import com.vmware.identity.websso.client.MessageStore;
import com.vmware.identity.websso.client.MessageType;
import com.vmware.identity.websso.client.MetadataSettings;
import com.vmware.identity.websso.client.SsoValidationState;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class SsoResponseListener {
    private static final Logger logger = LoggerFactory.getLogger(SsoResponseListener.class);
    @Autowired
    private MetadataSettings metadataSettings;
    @Autowired
    private MessageStore messageStore;
    @Autowired
    private LogonProcessor logonProcessor;
    private boolean assertionMustBeSigned = true;

    @Deprecated
    public void consumeResponse(@PathVariable(value="tenant") String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        this.consumeResponse(null, tenant, request, httpResponse);
    }

    @RequestMapping(value={"/SsoClient/SSO/{tenant:.*}"}, method={RequestMethod.POST})
    public void consumeResponse(Locale locale, @PathVariable(value="tenant") String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        logger.info("You have POST'ed to Websso client library!");
        Validate.notNull((Object)request);
        SsoValidationState validator = new SsoValidationState(request, this);
        try {
            ((ValidationState)validator).validate();
            Message message = this.createMessage(validator);
            if (validator.getStatus().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
                this.authenticationSuccess(message, locale, tenant, request, httpResponse);
            } else {
                this.authenticationError(message, locale, tenant, request, httpResponse);
            }
        }
        catch (Exception e) {
            logger.error("Authentication Exception:", (Throwable)e);
            if (validator.getValidationResult().isValid()) {
                validator.setValidationResult(new ValidationResult(400, "BadResponse", e.getMessage()));
                this.internalError(e, locale, tenant, request, httpResponse);
            }
            Message errorMessage = this.createMessage(validator);
            this.authenticationError(errorMessage, locale, tenant, request, httpResponse);
        }
    }

    private void authenticationError(Message message, Locale locale, String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        if (this.logonProcessor instanceof LogonProcessorEx) {
            ((LogonProcessorEx)this.logonProcessor).authenticationError(message, locale, tenant, request, httpResponse);
        } else {
            this.logonProcessor.authenticationError(message, request, httpResponse);
        }
    }

    private void internalError(Exception exception, Locale locale, String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        if (this.logonProcessor instanceof LogonProcessorEx) {
            ((LogonProcessorEx)this.logonProcessor).internalError(exception, locale, tenant, request, httpResponse);
        } else {
            this.logonProcessor.internalError(exception, request, httpResponse);
        }
    }

    private void authenticationSuccess(Message message, Locale locale, String tenant, HttpServletRequest request, HttpServletResponse httpResponse) {
        if (this.logonProcessor instanceof LogonProcessorEx) {
            ((LogonProcessorEx)this.logonProcessor).authenticationSuccess(message, locale, tenant, request, httpResponse);
        } else {
            this.logonProcessor.authenticationSuccess(message, request, httpResponse);
        }
    }

    private Message createMessage(ValidationState validator) {
        Message message = new Message(MessageType.AUTHN_RESPONSE, validator.getMessageID(), validator.getRelayState(), validator.getIssueInstant(), validator.getIssuerVal(), validator.getDestination(), validator.getStatus(), validator.getSubStatus(), validator.getSessionIndex(), validator.getMessageData(), null, validator.isIdpInitiated());
        message.setValidationResult(validator.getValidationResult());
        return message;
    }

    public void setMetadataSettings(MetadataSettings metadataSettings) {
        this.metadataSettings = metadataSettings;
    }

    public MetadataSettings getMetadataSettings() {
        return this.metadataSettings;
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public void setLogonProcessor(LogonProcessor logonProcessor) {
        this.logonProcessor = logonProcessor;
    }

    public boolean isAssertionMustBeSigned() {
        return this.assertionMustBeSigned;
    }

    public void setAssertionMustBeSigned(boolean assertionMustBeSigned) {
        this.assertionMustBeSigned = assertionMustBeSigned;
    }
}

