/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.datacenter.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.IpPoolManager;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.util.ObjectNamesRetriever;
import com.vmware.vsphere.client.datacenter.util.DatacenterUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatacenterPropertyProvider
implements PropertyProviderBean {
    private static final String DEFAULT_DATACENTER_NAME = DatacenterUtil.getLocalizedString("datacenter.defaultName");
    private static final String DATACENTER_TYPE = Datacenter.class.getSimpleName();
    private static final Log _logger = LogFactory.getLog(DatacenterPropertyProvider.class);
    private DataService _dataService;

    public DatacenterPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="Datacenter,Folder")
    public IpPool[] getIpPools(ManagedObjectReference ref) throws Exception {
        ManagedObjectReference dcRef = DatacenterUtil.getDc(this._dataService, ref);
        String serviceGuid = dcRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serviceGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        ManagedObjectReference managerRef = content.getIpPoolManager();
        IpPoolManager manager = (IpPoolManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
        IpPool[] pools = manager.queryIpPools(dcRef);
        if (pools != null) {
            this.unescapeSpecialChars(pools);
        }
        return pools;
    }

    private void unescapeSpecialChars(IpPool[] pools) {
        for (IpPool pool : pools) {
            pool.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)pool.name);
        }
    }

    @type(value="Folder")
    public String getNewUniqueDatacenterName(ManagedObjectReference context) {
        ArrayList<String> existingNames = this.getAllDatacenterNames(context);
        String newUniqueDatastoreName = StringUtil.getIndexedString(existingNames, (String)DEFAULT_DATACENTER_NAME, (String)" ");
        return newUniqueDatastoreName;
    }

    private ArrayList<String> getAllDatacenterNames(ManagedObjectReference context) {
        ArrayList existingNames = null;
        try {
            existingNames = ObjectNamesRetriever.getNamesOfAllObjectsWithinVC((DataService)this._dataService, (ManagedObjectReference)context, (String)DATACENTER_TYPE, (String)DEFAULT_DATACENTER_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        return existingNames;
    }
}

