/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.store.impl;

import com.vmware.vise.store.AddUserDataSpec;
import com.vmware.vise.store.AuthService;
import com.vmware.vise.store.InvalidArgumentException;
import com.vmware.vise.store.NoPermissionException;
import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceScope;
import com.vmware.vise.store.PersistenceServerScopeProvider;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.PersistenceStore;
import com.vmware.vise.store.SearchCriteria;
import com.vmware.vise.store.UpdateUserDataSpec;
import com.vmware.vise.store.User;
import com.vmware.vise.store.UserData;
import com.vmware.vise.store.internal.Config;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistenceServiceImpl
implements PersistenceService {
    private PersistenceStore _store;
    private AuthService _authService;
    private final ServiceRegistry _serviceRegistry;
    private PersistenceServerScopeProvider _serverScopeProvider;
    private static Log _logger = LogFactory.getLog(PersistenceServiceImpl.class);

    public PersistenceServiceImpl(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
    }

    public void setPersistenceStore(PersistenceStore persistenceStore) {
        this._store = persistenceStore;
    }

    @Override
    public void setAuthService(AuthService authService) {
        this._authService = authService;
    }

    @Override
    public void setNamespace(String string) {
        this._store.setNamespace(string);
    }

    @Override
    public OperationResult[] addUserData(String string, UserData[] userDataArray) {
        this.setupPersistenceStore();
        OperationResult[] operationResultArray = null;
        if (string == null || string.length() == 0) {
            operationResultArray = new OperationResult[]{new OperationResult()};
            operationResultArray[0].error = new InvalidArgumentException("Invalid path.");
            return operationResultArray;
        }
        if (userDataArray == null || userDataArray.length == 0) {
            operationResultArray = new OperationResult[]{new OperationResult()};
            operationResultArray[0].error = new InvalidArgumentException("Atleast one UserData should be specified.");
            return operationResultArray;
        }
        operationResultArray = new OperationResult[userDataArray.length];
        User user = this.getCurrentUser();
        for (int i = 0; i < userDataArray.length; ++i) {
            operationResultArray[i] = new OperationResult();
            try {
                operationResultArray[i].result = this._store.create(user, string + "/" + UUID.randomUUID(), userDataArray[i]);
                continue;
            }
            catch (Exception exception) {
                operationResultArray[i].error = exception;
            }
        }
        return operationResultArray;
    }

    @Override
    public OperationResult setUserData(UserData userData, boolean bl, PersistenceScope persistenceScope) {
        this.setupPersistenceStore();
        OperationResult operationResult = new OperationResult();
        if (userData == null || userData.metadata == null || userData.metadata.uid == null) {
            operationResult.error = new InvalidArgumentException("Invalid user data.");
            return operationResult;
        }
        try {
            User user = this.getCurrentUser();
            this._store.save(user, userData, bl, this.getServerGuids(persistenceScope));
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult getUserData(String string, String string2, PersistenceScope persistenceScope) {
        this.setupPersistenceStore();
        OperationResult operationResult = new OperationResult();
        if (string == null || string.length() == 0) {
            operationResult.error = new InvalidArgumentException("Invalid path.");
            return operationResult;
        }
        try {
            long l = System.currentTimeMillis();
            User user = this.getCurrentUser();
            long l2 = System.currentTimeMillis();
            List<String> list = this.getServerGuids(persistenceScope);
            long l3 = System.currentTimeMillis();
            operationResult.result = this._store.read(user, string, string2, list);
            long l4 = System.currentTimeMillis();
            if (l4 - l > (long)Config.PERSISTENCE_SERVICE_READ_LOG_TIMEOUT) {
                _logger.warn((Object)String.format("getUserData took too long (ms): %d, get user = %d, get guids = %d, read = %d, scope = %s, path = %s", new Object[]{l4 - l, l2 - l, l3 - l2, l4 - l3, persistenceScope, string}));
            }
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult[] getUserDataMulti(String[] stringArray, String string, PersistenceScope persistenceScope) {
        ArrayList<OperationResult> arrayList = new ArrayList<OperationResult>();
        for (String string2 : (String[])ArrayUtil.toSafe((Object[])stringArray, String.class)) {
            OperationResult operationResult = this.getUserData(string2, string, persistenceScope);
            arrayList.add(operationResult);
        }
        return (OperationResult[])ArrayUtil.toArray(arrayList, OperationResult.class);
    }

    @Override
    public OperationResult queryUserData(String string, SearchCriteria searchCriteria, PersistenceScope persistenceScope) {
        this.setupPersistenceStore();
        OperationResult operationResult = new OperationResult();
        if (string == null && searchCriteria == null) {
            operationResult.error = new InvalidArgumentException("Invalid query.");
            return operationResult;
        }
        try {
            long l = System.currentTimeMillis();
            User user = this.getCurrentUser();
            long l2 = System.currentTimeMillis();
            List<String> list = this.getServerGuids(persistenceScope);
            long l3 = System.currentTimeMillis();
            operationResult.result = this._store.search(user, string, searchCriteria, list);
            long l4 = System.currentTimeMillis();
            if (l4 - l > (long)Config.PERSISTENCE_SERVICE_READ_LOG_TIMEOUT) {
                _logger.warn((Object)String.format("queryUserData took too long (ms): %d, get user = %d, get guids = %d, search = %d, path = %s, scope = %s, criteria = %s", new Object[]{l4 - l, l2 - l, l3 - l2, l4 - l3, string, persistenceScope, ObjectUtil.prettyPrint((Object)searchCriteria)}));
            }
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult queryMetadata(String string, SearchCriteria searchCriteria, PersistenceScope persistenceScope) {
        this.setupPersistenceStore();
        OperationResult operationResult = new OperationResult();
        if (string == null && searchCriteria == null) {
            operationResult.error = new InvalidArgumentException("Invalid query.");
            return operationResult;
        }
        try {
            long l = System.currentTimeMillis();
            User user = this.getCurrentUser();
            long l2 = System.currentTimeMillis();
            List<String> list = this.getServerGuids(persistenceScope);
            long l3 = System.currentTimeMillis();
            operationResult.result = this._store.searchForMetadata(user, string, searchCriteria, list);
            long l4 = System.currentTimeMillis();
            if (l4 - l > (long)Config.PERSISTENCE_SERVICE_READ_LOG_TIMEOUT) {
                _logger.warn((Object)String.format("queryMetadata took too long (ms): %d get user = %d, get guids = %d, search metadata = %d, path = %s, scope = %s, criteria = %s", new Object[]{l4 - l, l2 - l, l3 - l2, l4 - l3, string, persistenceScope, ObjectUtil.prettyPrint((Object)searchCriteria)}));
            }
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult[] removeUserData(String[] stringArray, String string, PersistenceScope persistenceScope) {
        this.setupPersistenceStore();
        OperationResult[] operationResultArray = null;
        if (stringArray == null || stringArray.length == 0) {
            operationResultArray = new OperationResult[]{new OperationResult()};
            operationResultArray[0].error = new InvalidArgumentException("Invalid input.");
            return operationResultArray;
        }
        operationResultArray = new OperationResult[stringArray.length];
        User user = this.getCurrentUser();
        for (int i = 0; i < stringArray.length; ++i) {
            operationResultArray[i] = new OperationResult();
            try {
                this._store.remove(user, stringArray[i], string, this.getServerGuids(persistenceScope));
                continue;
            }
            catch (Exception exception) {
                operationResultArray[i].error = exception;
            }
        }
        return operationResultArray;
    }

    @Override
    public OperationResult apply(String string, UpdateUserDataSpec updateUserDataSpec) {
        OperationResult operationResult = null;
        if (updateUserDataSpec == null) {
            _logger.debug((Object)"Invalid update spec to apply.");
            return new OperationResult();
        }
        try {
            if (updateUserDataSpec.data != null && updateUserDataSpec.data.metadata != null) {
                updateUserDataSpec.data.metadata.uid = string;
            }
            operationResult = this.setUserData(updateUserDataSpec.data, false, null);
        }
        catch (Exception exception) {
            operationResult = new OperationResult();
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult add(AddUserDataSpec addUserDataSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            operationResult.result = this.addUserData(addUserDataSpec.path, addUserDataSpec.data);
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult[] addMulti(AddUserDataSpec[] addUserDataSpecArray) {
        OperationResult[] operationResultArray = null;
        if (addUserDataSpecArray == null) {
            _logger.debug((Object)"Invalid add spec's.");
            return new OperationResult[0];
        }
        operationResultArray = new OperationResult[addUserDataSpecArray.length];
        for (int i = 0; i < addUserDataSpecArray.length; ++i) {
            operationResultArray[i] = this.add(addUserDataSpecArray[i]);
        }
        return operationResultArray;
    }

    @Override
    public OperationResult remove(String string, Object object) {
        OperationResult operationResult = null;
        try {
            operationResult = this.removeUserData(new String[]{string}, null, null)[0];
        }
        catch (Exception exception) {
            operationResult = new OperationResult();
            operationResult.error = exception;
        }
        return operationResult;
    }

    @Override
    public OperationResult[] removeOnMultiEntity(String[] stringArray, Object object) {
        try {
            return this.removeUserData(stringArray, null, null);
        }
        catch (Exception exception) {
            OperationResult operationResult = new OperationResult();
            operationResult.error = exception;
            return new OperationResult[]{operationResult};
        }
    }

    @Override
    public OperationResult reset() {
        this.setupPersistenceStore();
        OperationResult operationResult = new OperationResult();
        try {
            User user = this.getCurrentUser();
            if (user.isGroup()) {
                throw new NoPermissionException("Current user permission does not allow reset.");
            }
            this._store.reset(user);
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    private synchronized void setupPersistenceStore() {
        if (this._store != null) {
            return;
        }
        PersistenceStore persistenceStore = null;
        try {
            persistenceStore = (PersistenceStore)this._serviceRegistry.getService(PersistenceStore.class.getName());
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when getting implementers of PersistenceStore interface", (Throwable)exception);
        }
        if (persistenceStore != null) {
            this._store = persistenceStore;
        } else {
            _logger.error((Object)"Cannot get persistence store");
        }
    }

    private User getCurrentUser() {
        if (this._authService == null) {
            throw new IllegalStateException("AuthService is not set.");
        }
        User user = this._authService.getCurrentUser();
        if (user == null) {
            throw new IllegalStateException("Invalid user session.");
        }
        if (user.getName() == null) {
            throw new IllegalStateException("Invalid user information.");
        }
        return user;
    }

    private List<String> getServerGuids(PersistenceScope persistenceScope) {
        if (PersistenceScope.SERVER != persistenceScope) {
            return null;
        }
        PersistenceServerScopeProvider persistenceServerScopeProvider = this.getServerScopeProvider();
        if (persistenceServerScopeProvider == null) {
            return null;
        }
        return persistenceServerScopeProvider.getServerGuids();
    }

    private synchronized PersistenceServerScopeProvider getServerScopeProvider() {
        if (this._serverScopeProvider != null) {
            return this._serverScopeProvider;
        }
        List list = this._serviceRegistry.getServices(PersistenceServerScopeProvider.class.getName());
        if (list == null || list.size() == 0) {
            return null;
        }
        this._serverScopeProvider = (PersistenceServerScopeProvider)list.get(0);
        return this._serverScopeProvider;
    }
}

