/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport;

import com.google.common.collect.ImmutableList;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.http.transport.urlResolver.DatastoreFileDownloadUrlResolver;
import com.vmware.vise.vim.http.transport.urlResolver.DatastoreFileLocation;
import com.vmware.vise.vim.http.transport.util.FileRequestHandlerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.HttpRequestHandler;

public class FileDownloadRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(FileDownloadRequestHandler.class);
    private static final int ONE_MB = 0x100000;
    private static final String RESULT_FILE_NAME_PARAM = "resultFileName";
    private static final String BASE_DATASTORE_PATH_PARAM = "baseDatastorePath";
    private static final String DEFAULT_RESULT_FILE_NAME = "files.zip";
    private static final String ERROR_LOG_FILE_NAME = "Error report.log";
    private KeystoreService _keystoreService;
    private DatastoreFileDownloadUrlResolver _datastoreFileDownloadUrlResolver;
    private ImmutableList<String> supportedMethods = ImmutableList.of((Object)HttpMethod.GET.toString(), (Object)HttpMethod.POST.toString());

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setDatastoreFileDownloadUrlResolver(DatastoreFileDownloadUrlResolver datastoreFileDownloadUrlResolver) {
        this._datastoreFileDownloadUrlResolver = datastoreFileDownloadUrlResolver;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.supportedMethods.contains((Object)string)) {
            this.doRequest(httpServletRequest, httpServletResponse);
        } else {
            FileRequestHandlerUtil.returnResponse(httpServletResponse, 405, string + " request method is not supported.");
        }
    }

    private void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        List<DatastoreFileLocation> list = this.resolveFilePaths(httpServletRequest);
        if (list == null || list.isEmpty()) {
            _logger.error((Object)"Failed to parse datastore file locations");
            FileRequestHandlerUtil.returnError(httpServletResponse, "Failed to parse file locations.");
            return;
        }
        String string = httpServletRequest.getParameter("vcServerGuid");
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"Missing vcGuid");
            FileRequestHandlerUtil.returnError(httpServletResponse, "Invalid request. Missing vcGuid parameter.");
            return;
        }
        String string2 = httpServletRequest.getParameter(RESULT_FILE_NAME_PARAM);
        if (StringUtil.isNullOrEmpty((String)string2)) {
            string2 = DEFAULT_RESULT_FILE_NAME;
        }
        string2 = URLEncoder.encode(string2, "UTF-8").replace("+", "%20");
        httpServletResponse.setContentType("application/octet-stream");
        String string3 = String.format("attachment; filename*=UTF-8''%s", string2);
        httpServletResponse.addHeader("Content-Disposition", string3);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)servletOutputStream);
        zipOutputStream.setLevel(0);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string4 = httpServletRequest.getParameter(BASE_DATASTORE_PATH_PARAM);
        try {
            for (DatastoreFileLocation datastoreFileLocation : list) {
                HttpsURLConnection httpsURLConnection = FileDownloadRequestHandler.createConnection(datastoreFileLocation.getFileUrl(), FileRequestHandlerUtil.getSSLSocketFactory(this._keystoreService), string);
                String string5 = null;
                if (string4 != null && !string4.isEmpty()) {
                    string5 = datastoreFileLocation.getRelativePath(string4);
                }
                if (string5 == null) {
                    string5 = FileRequestHandlerUtil.generateUniqueFileName(datastoreFileLocation.getFileName(), hashSet);
                    hashSet.add(string5);
                }
                try {
                    InputStream inputStream = httpsURLConnection.getInputStream();
                    Throwable throwable = null;
                    try {
                        FileDownloadRequestHandler.addFileToZip(string5, inputStream, zipOutputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    arrayList.add(String.format("Failed to download \"%s\": %s", datastoreFileLocation.getDatastorePath(), iOException.toString()));
                }
            }
            if (!arrayList.isEmpty()) {
                String string6 = FileRequestHandlerUtil.generateUniqueFileName(ERROR_LOG_FILE_NAME, hashSet);
                hashSet.add(string6);
                this.writeErrorsToLog(arrayList, zipOutputStream, string6);
            }
            zipOutputStream.close();
        }
        catch (IOException | GeneralSecurityException exception) {
            _logger.error((Object)"Failed to download and generate zip file.", (Throwable)exception);
        }
    }

    private void writeErrorsToLog(List<String> list, ZipOutputStream zipOutputStream, String string) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(string));
        PrintWriter printWriter = new PrintWriter(zipOutputStream);
        for (String string2 : list) {
            printWriter.write(string2);
            printWriter.write("\n");
            printWriter.flush();
        }
        zipOutputStream.closeEntry();
        zipOutputStream.flush();
    }

    private List<DatastoreFileLocation> resolveFilePaths(HttpServletRequest httpServletRequest) {
        if (this._datastoreFileDownloadUrlResolver.canResolveUrl(httpServletRequest)) {
            return this._datastoreFileDownloadUrlResolver.resolveFileLocations(httpServletRequest);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(String string, InputStream inputStream, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[0x100000];
        zipOutputStream.putNextEntry(new ZipEntry(string));
        try {
            int n;
            while ((n = inputStream.read(byArray)) > -1) {
                zipOutputStream.write(byArray, 0, n);
                zipOutputStream.flush();
            }
        }
        finally {
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
        }
    }

    private static HttpsURLConnection createConnection(URL uRL, SSLSocketFactory sSLSocketFactory, String string) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        httpsURLConnection.setRequestMethod(HttpMethod.GET.name());
        httpsURLConnection.setDoInput(true);
        FileRequestHandlerUtil.setVcSessionCookie(httpsURLConnection, string);
        return httpsURLConnection;
    }
}

