/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.http.transport.urlResolver.IUploadUrlResolver;
import com.vmware.vise.vim.http.transport.util.FileRequestHandlerUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.HttpRequestHandler;

public class FileUploadRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(FileUploadRequestHandler.class);
    private static final int ONE_MB = 0x100000;
    private static final String VC_SERVICE_GUID_PARAM = "vcServerGuid";
    ImmutableList<String> supportedMethods = ImmutableList.of((Object)HttpMethod.POST.toString(), (Object)HttpMethod.PUT.toString());
    private KeystoreService _keystoreService;
    private List<IUploadUrlResolver> _uploadUrlResolvers;
    private int _bufferSizeInBytes = 0x100000;

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setUploadUrlResolvers(List<IUploadUrlResolver> list) {
        this._uploadUrlResolvers = list;
    }

    public void setBufferSizeInBytes(int n) {
        this._bufferSizeInBytes = n;
    }

    public void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.supportedMethods.contains((Object)string)) {
            this.doRequest(httpServletRequest, httpServletResponse);
        } else {
            FileRequestHandlerUtil.returnResponse(httpServletResponse, 405, string + " request method is not supported.");
        }
    }

    private URL resolveUrl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = null;
        boolean bl = false;
        if (this._uploadUrlResolvers != null && this._uploadUrlResolvers.size() > 0) {
            for (IUploadUrlResolver iUploadUrlResolver : this._uploadUrlResolvers) {
                bl = iUploadUrlResolver.canResolveUrl(httpServletRequest);
                if (!bl) continue;
                uRL = iUploadUrlResolver.resolveUrl(httpServletRequest);
                break;
            }
        }
        if (!bl || uRL == null) {
            throw new MalformedURLException("The proxy URL cannot be resolved from URL: " + httpServletRequest.getRequestURL().toString());
        }
        return uRL;
    }

    protected void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object;
        Object object2;
        Object object3;
        HttpsURLConnection httpsURLConnection;
        Object object4;
        URL uRL;
        try {
            uRL = this.resolveUrl(httpServletRequest);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            String string = "The requested URL is not correct.";
            String string2 = this.createErrorMessage(string, new URL(httpServletRequest.getRequestURL().toString()));
            this.logAndReturnError(httpServletResponse, exception, string2, string);
            return;
        }
        try {
            object4 = httpServletRequest.getParameter(VC_SERVICE_GUID_PARAM);
            Preconditions.checkArgument((!StringUtil.isNullOrEmpty((String)object4) ? 1 : 0) != 0);
            httpsURLConnection = FileUploadRequestHandler.createConnection(uRL, httpServletRequest, FileRequestHandlerUtil.getSSLSocketFactory(this._keystoreService));
            FileRequestHandlerUtil.setVcSessionCookie(httpsURLConnection, (String)object4);
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException exception) {
            String string = "Failed to create connection.";
            String string3 = this.createErrorMessage(string, uRL);
            this.logAndReturnError(httpServletResponse, exception, string3, string);
            return;
        }
        object4 = new byte[this._bufferSizeInBytes];
        try {
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            object3 = null;
            try {
                object2 = httpsURLConnection.getOutputStream();
                object = null;
                try {
                    int n = 0;
                    while ((n = servletInputStream.read((byte[])object4)) > 0) {
                        ((OutputStream)object2).write((byte[])object4, 0, n);
                        ((OutputStream)object2).flush();
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 != null) {
                        if (object != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((OutputStream)object2).close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (servletInputStream != null) {
                    if (object3 != null) {
                        try {
                            servletInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        servletInputStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            String string = "Failed to transfer data.";
            String string4 = this.createErrorMessage(string, uRL);
            this.logAndReturnError(httpServletResponse, iOException, string4, string);
            return;
        }
        try {
            int n = httpsURLConnection.getResponseCode();
            if (n >= 200 && n < 300) {
                FileRequestHandlerUtil.returnResponse(httpServletResponse, 200, "File uploaded successfully.");
            } else {
                object3 = httpsURLConnection.getResponseMessage();
                object2 = "HTTP connection to url: %s failed with status code: %s and response message: %s";
                object = String.format((String)object2, uRL, n, object3);
                this.logAndReturnError(httpServletResponse, null, (String)object, (String)object3);
            }
        }
        catch (IOException iOException) {
            object3 = "Failed to get response from server.";
            object2 = this.createErrorMessage((String)object3, uRL);
            this.logAndReturnError(httpServletResponse, iOException, (String)object2, (String)object3);
        }
    }

    private String createErrorMessage(String string, URL uRL) {
        String string2 = "%s URL: %s";
        return String.format(string2, string, uRL);
    }

    private void logAndReturnError(HttpServletResponse httpServletResponse, Exception exception, String string, String string2) throws IOException {
        string2 = string2 + "For more information check out the logs.";
        _logger.error((Object)string, (Throwable)exception);
        FileRequestHandlerUtil.returnError(httpServletResponse, string2);
    }

    private static HttpsURLConnection createConnection(URL uRL, HttpServletRequest httpServletRequest, SSLSocketFactory sSLSocketFactory) throws IOException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        httpsURLConnection.setRequestMethod(httpServletRequest.getMethod());
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestProperty("Content-Type", httpServletRequest.getContentType());
        long l = FileUploadRequestHandler.getContentLength(httpServletRequest);
        if (l > -1L) {
            httpsURLConnection.setRequestProperty("Content-Length", String.valueOf(l));
            httpsURLConnection.setFixedLengthStreamingMode(l);
        } else {
            httpsURLConnection.setChunkedStreamingMode(0x100000);
        }
        return httpsURLConnection;
    }

    private static long getContentLength(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("Content-Length");
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }
}

