/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http.transport.urlResolver;

import com.google.common.collect.ImmutableList;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.http.transport.urlResolver.DatastoreFileLocation;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreFileDownloadUrlResolver {
    private static final Log _logger = LogFactory.getLog(DatastoreFileDownloadUrlResolver.class);
    private static final String DATACENTER = "datacenterId";
    private static final String DATASTORE = "datastoreId";
    public static final String DATASTORE_PATH = "datastorePath";
    public static final String DATASTORE_FILE_URLS = "datastoreFilesUrls";
    private final DataService _dataService;
    private final ObjectReferenceService _objectReferenceService;

    public DatastoreFileDownloadUrlResolver(DataService dataService, ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objectReferenceService = objectReferenceService;
    }

    public List<DatastoreFileLocation> resolveFileLocations(HttpServletRequest httpServletRequest) {
        ArrayList<DatastoreFileLocation> arrayList = new ArrayList<DatastoreFileLocation>();
        String string = httpServletRequest.getParameter(DATACENTER);
        String string2 = httpServletRequest.getParameter(DATASTORE);
        String[] stringArray = httpServletRequest.getParameterValues(DATASTORE_PATH);
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objectReferenceService.getReference(string);
        ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this._objectReferenceService.getReference(string2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(DATACENTER, managedObjectReference);
        hashMap.put(DATASTORE_PATH, stringArray);
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = DATASTORE_FILE_URLS;
        parameterSpec.parameter = hashMap;
        HashMap<String, ImmutableList> hashMap2 = new HashMap<String, ImmutableList>();
        hashMap2.put(DATASTORE_FILE_URLS, ImmutableList.of((Object)parameterSpec));
        try {
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference2, (String[])new String[]{DATASTORE_FILE_URLS}, hashMap2);
            if (propertyValueArray != null && propertyValueArray.length == 1 && propertyValueArray[0].value instanceof String[]) {
                String[] stringArray2 = (String[])propertyValueArray[0].value;
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(new DatastoreFileLocation(stringArray[i], new URL(stringArray2[i])));
                }
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Datastore file download URL cannot be resolved due to an exception.", (Throwable)exception);
        }
        return arrayList;
    }

    public boolean canResolveUrl(HttpServletRequest httpServletRequest) {
        String[] stringArray = httpServletRequest.getParameterValues(DATASTORE_PATH);
        boolean bl = !StringUtil.isNullOrEmpty((String)httpServletRequest.getParameter(DATACENTER)) && !StringUtil.isNullOrEmpty((String)httpServletRequest.getParameter(DATASTORE)) && stringArray != null && stringArray.length > 0;
        return bl;
    }
}

